import org.jetbrains.kotlin.gradle.tasks.KotlinCompile


buildscript {

    val nexusUrl = System.getenv("NEXUS_URL") ?: "https://store.aggregate.digital"

    repositories {
        maven(url = "$nexusUrl/repository/gradle-plugins/")
        maven(url = "$nexusUrl/repository/maven-libs")
        maven(url = "$nexusUrl/repository/maven-central")
    }
    dependencies {
        classpath("org.gradle.kotlin:gradle-kotlin-dsl-plugins:1.4.9")
    }
}

apply(plugin = "org.gradle.kotlin.kotlin-dsl")

val nexusUrl = System.getenv("NEXUS_URL") ?: "https://store.aggregate.digital"

repositories {
    maven(url = "$nexusUrl/repository/maven-libs/")
    maven(url = "$nexusUrl/repository/maven-central/")
    maven(url = "$nexusUrl/repository/jetbrains/")
    maven(url = "$nexusUrl/repository/jitpack/")
    maven(url = "$nexusUrl/repository/m2/")
    maven(url = "$nexusUrl/repository/google/")
    maven(url = "$nexusUrl/repository/jboss/")
    maven(url = "$nexusUrl/repository/repo1/")
    maven(url = "$nexusUrl/repository/wso2/")
    maven(url = "$nexusUrl/repository/wso2dist/")
    maven(url = "$nexusUrl/repository/atlassian/")
    maven(url = "$nexusUrl/repository/oracle/")
    maven(url = "$nexusUrl/repository/wso2releases/")
}

dependencies {
    implementation("commons-net:commons-net:3.3")
}

tasks.withType<KotlinCompile> {
    kotlinOptions {
        jvmTarget = "1.8"
    }
}