package com.tibbo.aggregate.common.datatable.encoding;

import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.tests.CommonsTestCase;

public class TestFormatCache extends CommonsTestCase
{
  private final String format1 = "<<value><I><F=><A=0>><M=1><X=1>";
  private final String format2 = "<<value><I><F=><A=0><D=>><M=1><X=1>";
  
  public void testServerFormatCache() throws Exception
  {
    TableFormat f1 = new TableFormat(format1, new ClassicEncodingSettings(true));
    f1.makeImmutable(null);
    TableFormat f2 = new TableFormat(format2, new ClassicEncodingSettings(true));
    f2.makeImmutable(null);

    FormatCache fc = new LocalFormatCache("test");
    
    int id = fc.addIfNotExists(f1);
    
    assertEquals(0, id);
    
    id = fc.addIfNotExists(f2);
    
    assertEquals(1, id);
    
    TableFormat res = fc.get(0);
    
    assertSame(f1, res);
    
    res = fc.get(1);
    
    assertSame(f2, res);
    
    TableFormat newf1 = new TableFormat(format1, new ClassicEncodingSettings(true));
    newf1.makeImmutable(null);

    res = fc.getCachedVersion(newf1);
    
    assertSame(f1, res);
    
    TableFormat newf2 = new TableFormat(format2, new ClassicEncodingSettings(true));
    newf2.makeImmutable(null);

    res = fc.getCachedVersion(newf2);
    
    assertSame(f2, res);

    fc.put(0, newf1);

    res = fc.getCachedVersion(f1);

    assertSame(newf1, res);
  }
  
  public void testClientFormatCache() throws Exception
  {
    TableFormat f1 = new TableFormat(format1, new ClassicEncodingSettings(true));
    f1.makeImmutable(null);
    TableFormat f2 = new TableFormat(format2, new ClassicEncodingSettings(true));
    f2.makeImmutable(null);
    AbstractFormatCache fc = new RemoteFormatCache(null,"test");
    
    fc.put(123, f1);
    
    TableFormat res = fc.get(123);
    
    assertSame(f1, res);
    
    int id = fc.obtainId(f1);
    
    assertEquals(123, id);
    
    fc.put(123, f2);
    
    res = fc.get(123);

    assertSame(f2, res);

    TableFormat f3 = new TableFormat(format1, new ClassicEncodingSettings(true));
    f1.makeImmutable(null);

    fc.put(456, f3);

    res = fc.get(456);

    assertSame(f3, res);

    assertEquals(123, fc.obtainId(f2).intValue());
    assertEquals(456, fc.obtainId(f3).intValue());

  }
  
  public void testStrangerFormatCache()
  {
    TableFormat format = new TableFormat(format1, new ClassicEncodingSettings(true));

    AbstractFormatCache alisaCache = new LocalFormatCache("alisa");
    AbstractFormatCache bobCache = new LocalFormatCache("bob");
    
    format.applyCachedFormat(alisaCache, f -> {});
    
    assertNotNull(alisaCache.obtainId(format));
    
    format.applyCachedFormat(bobCache, f -> fail());
  
    assertNull(bobCache.obtainId(format));
  }
}
