package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.tests.CommonsTestCase;

import org.junit.Assert;

import static org.junit.Assert.assertNotEquals;

public class TestDataTableSorter extends CommonsTestCase
{
  public void testAllCommonFields()
  {
    TableFormat tf = new TableFormat(1, 1);
    tf.addField("<commonColumn1><I>");
    tf.addField("<commonColumn2><I>");
    tf.addField("<commonColumn3><I>");

    DataTableSorter sorter = new DataTableSorter();
    sorter.addOrder(new SortOrder("commonColumn1", true));
    sorter.addOrder(new SortOrder("commonColumn2", true));
    sorter.addOrder(new SortOrder("commonColumn3", true));

    DataTableSorter adjustedSorter = sorter.fitTo(tf);
    Assert.assertEquals(3, adjustedSorter.getOrders().size());
  }

  public void testNoCommonFields()
  {
    TableFormat tf = new TableFormat(1, 1);
    tf.addField("<col1><I>");
    tf.addField("<col2><I>");
    tf.addField("<col3><I>");

    DataTableSorter sorter = new DataTableSorter();
    sorter.addOrder(new SortOrder("anotherCol1", true));
    sorter.addOrder(new SortOrder("anotherCol2", true));
    sorter.addOrder(new SortOrder("anotherCol3", true));
    sorter.addOrder(new SortOrder("anotherCol4", true));

    DataTableSorter adjustedSorter = sorter.fitTo(tf);
    Assert.assertEquals(0, adjustedSorter.getOrders().size());
  }

  public void testIntersectOfFormatAndSorterFields()
  {
    TableFormat tf = new TableFormat(1, 1);
    tf.addField("<commonColumn1><I>");
    tf.addField("<commonColumn2><I>");
    tf.addField("<commonColumn3><I>");
    tf.addField("<col6><I>");

    DataTableSorter sorter = new DataTableSorter();
    sorter.addOrder(new SortOrder("commonColumn1", true));
    sorter.addOrder(new SortOrder("commonColumn2", true));
    sorter.addOrder(new SortOrder("anotherCol1", true));
    sorter.addOrder(new SortOrder("commonColumn3", true));
    sorter.addOrder(new SortOrder("anotherCol2", true));

    DataTableSorter adjustedSorter = sorter.fitTo(tf);
    Assert.assertEquals(3, adjustedSorter.getOrders().size());
  }
}
