package com.tibbo.aggregate.common.sql;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public interface SqlTable
{
    String getRealName();

    List<SqlColumn> getColumns() throws SQLException;

    SqlColumn getColumnByName(String name) throws SQLException;

    Map<String, SqlTableHierarchyLink> getLinks() throws SQLException;

    SqlTableHierarchyLink getLinkByTableName(String tableName) throws SQLException;

    List<SqlColumn> getPrimaryKeyColumns() throws SQLException;

    boolean exists();
}
