package com.tibbo.aggregate.common.server;

public interface AlertContextConstants
{
  int INSTANCE_TYPE_PENDING = 0;
  int INSTANCE_TYPE_ACTIVE = 1;
  
  int STATUS_ENABLED = 0;
  int STATUS_DISABLED = 1;
  int STATUS_ACTIVE = 2;
  int STATUS_ESCALATED = 3;
  
  int CORRECTIVE_ACTION_TYPE_RISE = 0;
  int CORRECTIVE_ACTION_TYPE_ACTIVATION = 1;
  int CORRECTIVE_ACTION_TYPE_DEACTIVATION = 2;
  int CORRECTIVE_ACTION_TYPE_ESCALATION = 3;
  int CORRECTIVE_ACTION_TYPE_DEESCALATION = 4;
  int CORRECTIVE_ACTION_TYPE_ACKNOWLEDGEMENT = 5;
  
  String V_ALERT_ACTIONS = "alertActions";
  String V_ESCALATION = "escalation";
  String V_EVENT_TRIGGERS = "eventTriggers";
  String V_VARIABLE_TRIGGERS = "variableTriggers";
  String V_STATUS = "status";
  String V_EVENT_TRIGGER_STATUS = "eventTriggerStatus";
  String V_VARIABLE_TRIGGER_STATUS = "variableTriggerStatus";
  String V_NOTIFICATIONS = "notifications";
  String V_INTERACTIVE_ACTIONS = "interactiveActions";
  String V_ACTIVE_INSTANCES = "activeInstances";
  String V_PERSISTENT_STATUS = "persistentStatus";

  String E_ALERT = "alert";
  String E_ALERTNOTIFY = "alertnotify";
  String E_DEACTIVATION = "deactivation";
  String E_STARTED = "started";

  String A_PENDING_ALERTS = "pendingAlerts";

  String VF_ALERT_ACTIONS_EXECUTION_TYPE = "executionType";
  String VF_ALERT_ACTIONS_MASK = "mask";
  String VF_ALERT_ACTIONS_ACTION = "action";
  String VF_ALERT_ACTIONS_INPUT = "input";
  String VF_ALERT_ACTIONS_CONDITION = "condition";
  String VF_ALERT_ACTIONS_RUN_FROM_SOURCE = "runFromSource";

  String VF_INTERACTIVE_ACTIONS_EXECUTION_TYPE = "executionType";
  String VF_INTERACTIVE_ACTIONS_MASK = "mask";
  String VF_INTERACTIVE_ACTIONS_ACTION = "action";
  String VF_INTERACTIVE_ACTIONS_INPUT = "input";
  String VF_INTERACTIVE_ACTIONS_RUN_FROM_SOURCE = "runFromSource";

  String VF_STATUS_ENABLED = "enabled";
  String VF_STATUS_PENDING_INSTANCE_COUNT = "pendingInstanceCount";
  String VF_STATUS_MAX_PENDING_TIME = "maxPendingTime";
  String VF_STATUS_ESCALATED = "escalated";
  String VF_STATUS_ESCALATION_REASON = "escalationReason";

  String VF_ACTIVE_INSTANCES_EVENT = "event";
  String VF_ACTIVE_INSTANCES_TYPE = "type";
  String VF_ACTIVE_INSTANCES_TIME = "time";
  String VF_ACTIVE_INSTANCES_LEVEL = "level";
  String VF_ACTIVE_INSTANCES_SOURCE = "source";
  String VF_ACTIVE_INSTANCES_KEY = "key";
  String VF_ACTIVE_INSTANCES_CAUSE = "cause";
  String VF_ACTIVE_INSTANCES_MESSAGE = "message";
  String VF_ACTIVE_INSTANCES_TRIGGER = "trigger";
  String VF_ACTIVE_INSTANCES_DATA = "data";

  String VF_EVENT_TRIGGER_STATUS_TRIGGER = "trigger";
  String VF_EVENT_TRIGGER_STATUS_ACTIVE = "active";
  String VF_EVENT_TRIGGER_STATUS_DETAILS = "details";

  String VF_EVENT_TRIGGER_STATUS_DETAILS_CONTEXT = "context";
  String VF_EVENT_TRIGGER_STATUS_DETAILS_KEY = "key";
  String VF_EVENT_TRIGGER_STATUS_DETAILS_ACTIVE = "active";
  String VF_EVENT_TRIGGER_STATUS_DETAILS_EVENTS = "events";

  String VF_VARIABLE_TRIGGER_STATUS_TRIGGER = "trigger";
  String VF_VARIABLE_TRIGGER_STATUS_ACTIVE = "active";
  String VF_VARIABLE_TRIGGER_STATUS_DETAILS = "details";

  String VF_VARIABLE_TRIGGER_STATUS_DETAILS_CONTEXT = "context";
  String VF_VARIABLE_TRIGGER_STATUS_DETAILS_KEY = "key";
  String VF_VARIABLE_TRIGGER_STATUS_DETAILS_ACTIVE = "active";
  String VF_VARIABLE_TRIGGER_STATUS_DETAILS_TIME = "time";
  String VF_VARIABLE_TRIGGER_STATUS_DETAILS_FLAPPING = "flapping";

  String VF_NOTIFICATIONS_NOTIFY_OWNER = "notifyOwner";
  String VF_NOTIFICATIONS_NOTIFICATION_NECESSITY_EXPRESSION = "notificationNecessityExpression";
  String VF_NOTIFICATIONS_ACK_REQUIRED = "ackRequired";
  String VF_NOTIFICATIONS_LIFETIME = "lifetime";
  String VF_NOTIFICATIONS_SOUND = "sound";
  String VF_NOTIFICATIONS_MAIL_TO_OWNER = "mailToOwner";
  String VF_NOTIFICATIONS_MAIL_RECIPIENTS = "mailRecipients";
  String VF_NOTIFICATIONS_ADDITIONAL_MAIL_RECIPIENTS = "additionalMailRecipients";
  String VF_NOTIFICATIONS_SMS_RECIPIENTS = "smsRecipients";
  String VF_NOTIFICATIONS_SMS_RECIPIENTS_PHONE = "phone";
  String VF_NOTIFICATIONS_MAIL_RECIPIENTS_USERNAME = "username";

  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS = "eventTriggers";

  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_BEAN = "bean";
  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_CONTEXTS = "contexts";

  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_CONTEXTS_CONTEXT = "context";
  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_CONTEXTS_STATUSES = "statuses";

  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_CONTEXTS_STATUSES_KEY = "key";
  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_CONTEXTS_STATUSES_ALERT = "alertID";
  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_CONTEXTS_STATUSES_ACTIVE = "active";
  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_CONTEXTS_STATUSES_EVENTS = "events";

  String VF_PERSISTENT_STATUS_EVENT_TRIGGERS_CONTEXTS_STATUSES_EVENTS_ID = "eventID";

  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS = "variableTriggers";

  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_BEAN = "bean";
  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS = "contexts";

  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS_CONTEXT = "context";
  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS_STATUSES = "statuses";

  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS_STATUSES_KEY = "key";
  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS_STATUSES_ALERT = "alertID";
  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS_STATUSES_ACTIVE = "active";
  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS_STATUSES_TIME = "time";
  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS_STATUSES_FLAPPING = "flapping";
  String VF_PERSISTENT_STATUS_VARIABLE_TRIGGERS_CONTEXTS_STATUSES_FLAPPING_ALERT = "flappingAlertID";

  String VF_PERSISTENT_STATUS_ESCALATED = "escalated";

  String EF_ALERT_DESCRIPTION = "description";
  String EF_ALERT_CONTEXT = "context";
  String EF_ALERT_ENTITY = "entity";
  String EF_ALERT_CAUSE = "cause";
  String EF_ALERT_MESSAGE = "message";
  String EF_ALERT_TRIGGER = "trigger";
  String EF_ALERT_DATA = "data";
  String EF_ALERT_DURATION = "duration";
  
  String EF_DEACTIVATION_ID = "id";
  String EF_DEACTIVATION_CONTEXT = "context";
  String EF_DEACTIVATION_DURATION = "duration";
  String EF_DEACTIVATOR_DATA = "deactivatorData";
  
  String EF_ALERTNOTIFY_DESCRIPTION = "description";
  String EF_ALERTNOTIFY_CONTEXT = "context";
  String EF_ALERTNOTIFY_ENTITY = "entity";
  String EF_ALERTNOTIFY_CAUSE = "cause";
  String EF_ALERTNOTIFY_MESSAGE = "message";
  String EF_ALERTNOTIFY_TRIGGER = "trigger";
  String EF_ALERTNOTIFY_DATA = "data";
  String EF_ALERTNOTIFY_ALERT_EVENT_ID = "alertEventId";

  String EF_ALERT_STARTED = "started";


}
