package com.tibbo.aggregate.common.expression.function.math;

import org.apache.commons.math3.stat.descriptive.rank.Median;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.function.AbstractSingleValueCollectorFunction;

public class MedianFunction extends AbstractSingleValueCollectorFunction
{
  public MedianFunction()
  {
    super(null, "median", Function.GROUP_MATH, "DataTable table [, String field]", "Double", Cres.get().getString("fDescMedian"));
  }

  @Override
  protected Object collect(DataTable table, FieldFormat ff) throws EvaluationException
  {
    return new Median().evaluate(toArray(table, ff));
  }
}
