package com.tibbo.aggregate.common.expression.function.math;

import org.apache.commons.math3.stat.descriptive.rank.Max;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.function.AbstractSingleValueCollectorFunction;

public class MaxFunction extends AbstractSingleValueCollectorFunction
{
  public MaxFunction()
  {
    super(new Max(), "max", Function.GROUP_MATH, "(DataTable table [, String field]) OR (Double first, Double second)", "Double", Cres.get().getString("fDescMax"));
  }

  @Override
  protected Object compare(Number first, Number second)
  {
    return Math.max(first.doubleValue(), second.doubleValue());
  }
}
