package com.tibbo.aggregate.common.expression.function.date;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;

import com.tibbo.aggregate.common.expression.EvaluationException;

public class DateFieldFunction extends DateFunction
{
  private final ChronoField field;

  public DateFieldFunction(String name, ChronoField field, String description)
  {
    super(name, "Integer", description);
    this.field = field;
  }
  
  @Override
  public Object execute(ZonedDateTime zonedDateTime, Object... parameters) throws EvaluationException
  {
    int result = zonedDateTime.get(field);
    if (field == ChronoField.MONTH_OF_YEAR)
    {
      // To keep backward compatibility where January = 0;
      result = result - 1;
    }
    return result;
  }
}
