package com.tibbo.aggregate.common.expression.function.date;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.function.AbstractFunction;
import com.tibbo.aggregate.common.util.DateUtils;
import com.tibbo.aggregate.common.util.TimeHelper;
import com.tibbo.aggregate.common.util.TimeUnit;
import com.tibbo.aggregate.common.util.Util;
import org.apache.logging.log4j.util.Strings;

public class DateAddFunction extends AbstractFunction
{
  public DateAddFunction()
  {
    super("dateAdd", Function.GROUP_DATE_TIME_PROCESSING, "Date date, Integer count, String unit [, String timezone]", "Date", Cres.get().getString("fDescDateAdd"));
  }
  
  @Override
  public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object... parameters) throws EvaluationException
  {
    checkParameters(3, false, parameters);
    
    Date date = Util.convertToDate(parameters[0], true, false);
    int count = Util.convertToNumber(parameters[1], false, false).intValue();
    TimeUnit unit = TimeHelper.getTimeUnit(parameters[2].toString());

    ZoneId zoneId = DateUtils.UTC_TIME_ZONE.toZoneId();

    if (parameters.length > 3)
    {
      String zone = parameters[3].toString();
      if (!Strings.isEmpty(zone))
      {
        zoneId = ZoneId.of(zone);
      }
    }

    ZonedDateTime zdt = date.toInstant().atZone(zoneId);
    zdt = zdt.plus(count, unit.getChronoUnit());
    return Date.from(zdt.toInstant());
  }
}
