package com.tibbo.aggregate.common.context;

import java.io.*;
import java.util.Objects;

public class EntityReference implements Serializable, Cloneable, Comparable<EntityReference>
{
  protected String context;
  protected String entity;
  protected String serverID;

  public EntityReference()
  {
  }
  
  public EntityReference(String context, String entity)
  {
    this.context = context;
    this.entity = entity;
  }
  
  public EntityReference(String context, String entity, String serverID)
  {
    this(context, entity);
    this.serverID = serverID;
  }
  
  public String getContext()
  {
    return context;
  }
  
  public String getEntity()
  {
    return entity;
  }
  
  // For compatibility with LS properties table mapping
  public String getProperty()
  {
    return entity;
  }
  
  public void setContext(String context)
  {
    this.context = context;
  }
  
  public void setEntity(String entity)
  {
    this.entity = entity;
  }
  
  // For compatibility with LS properties table mapping
  public void setProperty(String property)
  {
    this.entity = property;
  }
  
  public String getServerID()
  {
    return serverID;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o)
    {
      return true;
    }
    if (o == null || getClass() != o.getClass())
    {
      return false;
    }

    EntityReference that = (EntityReference) o;

    return Objects.equals(context, that.context) &&
            Objects.equals(entity, that.entity);
  }

  @Override
  public int hashCode()
  {
    return Objects.hash(context, entity);
  }

  public int compareTo(EntityReference ref)
  {
    return toString().compareTo(ref.toString());
  }
  
  @Override
  public String toString()
  {
    return context + ":" + entity;
  }
  
  @Override
  public EntityReference clone()
  {
    try
    {
      return (EntityReference) super.clone();
    }
    catch (CloneNotSupportedException ex)
    {
      throw new IllegalStateException(ex.getMessage(), ex);
    }
  }
}
