package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.field.StringFieldFormat;
import com.tibbo.aggregate.common.util.WebWindowLocation;

public class GridDashboardActionCommand extends GenericActionCommand
{
  public static final String CF_DEFAULT_CONTEXT = "defaultContext";
  public static final String CF_FULL_CONTEXT_PATH = "fullContextPath";
  public static final String CF_CONTEXT_PATH = "contextPath";
  public static final String CF_LOCATION = "location";
  public static final String CF_PARAMS = "params";

  public static TableFormat CFT_GRID_DASHBOARD = new TableFormat();
  static
  {
      FieldFormat ff = FieldFormat.create(CF_DEFAULT_CONTEXT, FieldFormat.STRING_FIELD, Cres.get().getString("conDefaultContext"));
      ff.setNullable(true);
      ff.setEditor(StringFieldFormat.EDITOR_CONTEXT);
      CFT_GRID_DASHBOARD.addField(ff);

      ff = FieldFormat.create(CF_FULL_CONTEXT_PATH, FieldFormat.STRING_FIELD);
      ff.setNullable(true);
      ff.setEditor(StringFieldFormat.EDITOR_CONTEXT);
      CFT_GRID_DASHBOARD.addField(ff);

      ff = FieldFormat.create(CF_CONTEXT_PATH, FieldFormat.STRING_FIELD);
      ff.setNullable(true);
      ff.setEditor(StringFieldFormat.EDITOR_CONTEXT);
      CFT_GRID_DASHBOARD.addField(ff);

      ff = FieldFormat.create(CF_LOCATION, FieldFormat.DATATABLE_FIELD);
      ff.setNullable(true);
      ff.setDefault(new WebWindowLocation().toDataTable());
      CFT_GRID_DASHBOARD.addField(ff);

      CFT_GRID_DASHBOARD.addField("<" + CF_COMPONENT_LOCATION + "><T><F=NH><D=" + Cres.get().getString("componentLocation") + ">");

      ff = FieldFormat.create(CF_PARAMS, FieldFormat.DATATABLE_FIELD);
      ff.setNullable(true);
      ff.setDefault(null);
      CFT_GRID_DASHBOARD.addField(ff);
  }
  private final String contextPath;
  private final String fullContextPath;
  private final String defaultContext;
  private final WebWindowLocation location;
  
  public GridDashboardActionCommand(String type, String title, String fullContextPath, String contextPath, String defaultContext, WebWindowLocation location)
  {
    super(type, title);
    this.fullContextPath = fullContextPath;
    this.contextPath = contextPath;
    this.defaultContext = defaultContext;
    this.location = location;
  }
  
  public GridDashboardActionCommand(String cmdOpenGridDashboard, String title, DataTable parameters)
  {
    super(cmdOpenGridDashboard, title, parameters);
    this.fullContextPath = null;
    this.contextPath = parameters.rec().getString(CF_CONTEXT_PATH);
    this.defaultContext = parameters.rec().getString(CF_DEFAULT_CONTEXT);
    this.location = parameters.rec().getDataTable(CF_LOCATION) != null ? new WebWindowLocation(parameters.rec().getDataTable(CF_LOCATION).rec()) : null;
  }

  @Override
  protected DataTable constructParameters()
  {
    DataRecord dr = new DataRecord(CFT_GRID_DASHBOARD);
    dr.setValue(CF_DEFAULT_CONTEXT, defaultContext);
    dr.setValue(CF_FULL_CONTEXT_PATH, fullContextPath);
    dr.setValue(CF_CONTEXT_PATH, contextPath);
    dr.setValue(CF_LOCATION, location != null ? location.toDataTable() : null);
    dr.addDataTable(getComponentLocation() != null ? getComponentLocation().toDataTable() : null);
    return dr.wrap();
  }
}
