package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.ActionUtils;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.ComponentLocation;

public class EditExpression extends GenericActionCommand
{
  public static final TableFormat CFT_EDIT_EXPRESSION = new TableFormat();
  
  static
  {
    CFT_EDIT_EXPRESSION.addField(FieldFormat.create(CF_COMPONENT_LOCATION, FieldFormat.DATATABLE_FIELD, Cres.get().getString("componentLocation"))
        .setDefault(new SimpleDataTable(ComponentLocation.OFT_COMPONENT_LOCATION))
        .setNullable(true)
        .setHidden(true));
  }

  public EditExpression(String title, DataTable parameters)
  {
    super(ActionUtils.CMD_EDIT_EXPRESSION, title, parameters);
  }

  public EditExpression()
  {
    super(ActionUtils.CMD_EDIT_EXPRESSION, Cres.get().getString("editExpression"));
  }

  @Override
  protected DataTable constructParameters()
  {
    DataRecord rec = new DataRecord(CFT_EDIT_EXPRESSION);
    rec.addDataTable(getComponentLocation() != null ? getComponentLocation().toDataTable() : null);
    return rec.wrap();
  }
}
