package com.tibbo.aggregate.common.action.command;

import java.net.URI;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.ActionUtils;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.ComponentLocation;

public class Browse extends GenericActionCommand
{
  public static final String CF_BROWSE_URI = "uri";
  
  public static final TableFormat CFT_BROWSE = new TableFormat(1, 1);
  
  static
  {
    CFT_BROWSE.addField(FieldFormat.create("<" + CF_BROWSE_URI + "><S>").setDescription(Cres.get().getString("url")));
    CFT_BROWSE.addField(FieldFormat.create(CF_COMPONENT_LOCATION, FieldFormat.DATATABLE_FIELD, Cres.get().getString("componentLocation"))
        .setDefault(new SimpleDataTable(ComponentLocation.OFT_COMPONENT_LOCATION))
        .setNullable(true)
        .setHidden(true));
  }

  private URI url;
  
  public Browse()
  {
    super(ActionUtils.CMD_BROWSE, CFT_BROWSE, null);
  }
  
  public Browse(URI url)
  {
    super(ActionUtils.CMD_BROWSE, (String) null);
    this.url = url;
  }
  
  public Browse(String title, DataTable parameters)
  {
    super(ActionUtils.CMD_BROWSE, title, parameters);
  }
  
  @Override
  protected DataTable constructParameters()
  {
    return new SimpleDataTable(CFT_BROWSE, url.toString(), getComponentLocation() != null ? getComponentLocation().toDataTable() : null);
  }
  
  public URI getUrl()
  {
    return url;
  }
  
  public void setUrl(URI url)
  {
    this.url = url;
  }
  
}
