package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.datatable.*;

public class ServerActionInput implements InitialRequest
{
  private DataTable data = new SimpleDataTable();
  private boolean remember;
  private RequestIdentifier requestId;
  private final boolean last;

  public ServerActionInput()
  {
    last = false;
  }

  public ServerActionInput(DataTable dataTable)
  {
    this();
    setData(dataTable);
  }

  public ServerActionInput(DataTable dataTable, boolean last)
  {
    this.last = last;
    setData(dataTable);
  }
  
  public ServerActionInput(GenericActionResponse request)
  {
    this();
    if (request == null)
    {
      throw new NullPointerException();
    }
    
    if (request.getParameters() != null)
    {
      data = request.getParameters().clone();
    }
  }
  
  public DataTable getData()
  {
    return data;
  }

    public void setData(DataTable data)
    {
        if (data != null)
        {
            this.data = data.clone();
        }
    }
  
  public boolean shouldRemember()
  {
    return remember;
  }
  
  public void setRemember(boolean flag)
  {
    this.remember = flag;
  }
  
  public void setRequestId(RequestIdentifier requestId)
  {
    this.requestId = requestId;
  }
  
  public RequestIdentifier getRequestId()
  {
    return requestId;
  }

  public boolean isLast()
  {
    return last;
  }
}
