/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.java.plugin.util.ResourceManager;

public final class IoUtil {
    private static final String PACKAGE_NAME = "org.java.plugin.util";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        if (!src.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFile", src));
        }
        if (dest.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFolder", dest));
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest, false));
            try {
                IoUtil.copyStream(in, out, 1024);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        dest.setLastModified(src.lastModified());
    }

    public static void copyFolder(File src, File dest) throws IOException {
        IoUtil.copyFolder(src, dest, true, false, null);
    }

    public static void copyFolder(File src, File dest, boolean recursive) throws IOException {
        IoUtil.copyFolder(src, dest, recursive, false, null);
    }

    public static void copyFolder(File src, File dest, boolean recursive, boolean onlyNew) throws IOException {
        IoUtil.copyFolder(src, dest, recursive, onlyNew, null);
    }

    public static void copyFolder(File src, File dest, boolean recursive, boolean onlyNew, FileFilter filter) throws IOException {
        if (!src.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFolder", src));
        }
        if (dest.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFile", dest));
        }
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantMakeFolder", dest));
        }
        File[] srcFiles = filter != null ? src.listFiles(filter) : src.listFiles();
        for (int i = 0; i < srcFiles.length; ++i) {
            File file = srcFiles[i];
            if (file.isDirectory()) {
                if (!recursive) continue;
                IoUtil.copyFolder(file, new File(dest, file.getName()), recursive, onlyNew, filter);
                continue;
            }
            File destFile = new File(dest, file.getName());
            if (onlyNew && destFile.isFile() && destFile.lastModified() > file.lastModified()) continue;
            IoUtil.copyFile(file, destFile);
        }
        dest.setLastModified(src.lastModified());
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buf = new byte[bufferSize];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    public static boolean emptyFolder(File folder) {
        if (!folder.isDirectory()) {
            return true;
        }
        File[] files = folder.listFiles();
        boolean result = true;
        for (File file : files) {
            if (file.isDirectory()) {
                if (IoUtil.emptyFolder(file)) {
                    result &= file.delete();
                    continue;
                }
                result = false;
                continue;
            }
            result &= file.delete();
        }
        return result;
    }

    public static boolean compareFiles(File file1, File file2) {
        if (!file1.isFile() || !file2.isFile()) {
            return false;
        }
        if (!file1.getName().equals(file2.getName())) {
            return false;
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        return IoUtil.compareFileDates(new Date(file1.lastModified()), new Date(file2.lastModified()));
    }

    public static boolean compareFileDates(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cldr = Calendar.getInstance(Locale.ENGLISH);
        cldr.setTime(date1);
        cldr.set(14, 0);
        long dt1 = cldr.getTimeInMillis();
        cldr.setTime(date2);
        cldr.set(14, 0);
        long dt2 = cldr.getTimeInMillis();
        return dt1 == dt2;
    }

    public static void synchronizeFolders(File src, File dest) throws IOException {
        IoUtil.synchronizeFolders(src, dest, null);
    }

    public static void synchronizeFolders(File src, File dest, FileFilter filter) throws IOException {
        File[] srcFiles;
        if (!src.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFolder", src));
        }
        if (dest.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFile", dest));
        }
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantMakeFolder", dest));
        }
        for (File srcFile : srcFiles = filter != null ? src.listFiles(filter) : src.listFiles()) {
            File destFile = new File(dest, srcFile.getName());
            if (srcFile.isDirectory()) {
                if (destFile.isFile() && !destFile.delete()) {
                    throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantDeleteFile", destFile));
                }
                IoUtil.synchronizeFolders(srcFile, destFile, filter);
                continue;
            }
            if (IoUtil.compareFiles(srcFile, destFile)) continue;
            IoUtil.copyFile(srcFile, destFile);
        }
        File[] destFiles = dest.listFiles();
        for (int i = 0; i < destFiles.length; ++i) {
            File srcFile;
            File destFile = destFiles[i];
            srcFile = new File(src, destFile.getName());
            if (filter != null && filter.accept(destFile) && srcFile.exists() || filter == null && srcFile.exists()) continue;
            if (destFile.isDirectory() && !IoUtil.emptyFolder(destFile)) {
                throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantEmptyFolder", destFile));
            }
            if (destFile.delete()) continue;
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantDeleteFile", destFile));
        }
        dest.setLastModified(src.lastModified());
    }

    public static boolean isResourceExists(URL url) {
        File file = IoUtil.url2file(url);
        if (file != null) {
            return file.canRead();
        }
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            return IoUtil.isJarResourceExists(url);
        }
        return IoUtil.isUrlResourceExists(url);
    }

    private static boolean isUrlResourceExists(URL url) {
        try {
            InputStream is = url.openStream();
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isJarResourceExists(URL url) {
        boolean bl;
        String urlStr = url.toExternalForm();
        int p = urlStr.indexOf("!/");
        if (p == -1) {
            return false;
        }
        URL fileUrl = new URL(urlStr.substring(4, p));
        File file = IoUtil.url2file(fileUrl);
        if (file == null) {
            return IoUtil.isUrlResourceExists(url);
        }
        if (!file.canRead()) {
            return false;
        }
        if (p == urlStr.length() - 2) {
            return true;
        }
        JarFile jarFile = new JarFile(file);
        try {
            bl = jarFile.getEntry(urlStr.substring(p + 2)) != null;
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getResourceInputStream(URL url) throws IOException {
        File file = IoUtil.url2file(url);
        if (file != null) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        if (!"jar".equalsIgnoreCase(url.getProtocol())) {
            return url.openStream();
        }
        String urlStr = url.toExternalForm();
        if (urlStr.endsWith("!/")) {
            throw new FileNotFoundException(url.toExternalForm());
        }
        int p = urlStr.indexOf("!/");
        if (p == -1) {
            throw new MalformedURLException(url.toExternalForm());
        }
        String path = urlStr.substring(p + 2);
        file = IoUtil.url2file(new URL(urlStr.substring(4, p)));
        if (file == null) {
            return url.openStream();
        }
        JarFile jarFile = new JarFile(file);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ZipEntry entry = jarFile.getEntry(path);
            if (entry == null) {
                throw new FileNotFoundException(url.toExternalForm());
            }
            InputStream in = jarFile.getInputStream(entry);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IoUtil.copyStream(in, out, 1024);
                byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return byteArrayInputStream;
        }
        finally {
            jarFile.close();
        }
    }

    public static File url2file(URL url) {
        String prot = url.getProtocol();
        if ("jar".equalsIgnoreCase(prot)) {
            if (url.getFile().endsWith("!/")) {
                String urlStr = url.toExternalForm();
                try {
                    return IoUtil.url2file(new URL(urlStr.substring(4, urlStr.length() - 2)));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
        if (!"file".equalsIgnoreCase(prot)) {
            return null;
        }
        try {
            return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new File(URLDecoder.decode(url.getFile()));
        }
    }

    public static URL file2url(File file) throws MalformedURLException {
        try {
            return file.getCanonicalFile().toURI().toURL();
        }
        catch (MalformedURLException mue) {
            throw mue;
        }
        catch (IOException ioe) {
            throw new MalformedURLException(ResourceManager.getMessage(PACKAGE_NAME, "file2urlFailed", new Object[]{file, ioe}));
        }
    }

    private IoUtil() {
    }
}

