/*
 * Decompiled with CFR 0.152.
 */
package examples.plugin;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.UncheckedCallerController;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.plugin.AbstractContextPlugin;
import com.tibbo.aggregate.common.plugin.PluginException;
import com.tibbo.aggregate.common.server.ServerContext;
import java.awt.Color;

public class DemoServerPlugin
extends AbstractContextPlugin {
    private static final String CONTEXT_TYPE_TRACKERS = "trackers";
    private static final String TRACKER_NAME = "usersDeviceCount";
    private static final String VARIABLE_CONFIG = "config";
    private static final String FIELD_CREATE_TRACKERS = "createTrackers";
    private static final TableFormat FORMAT_CONFIG = new TableFormat(1, 1);

    @Override
    public void globalInit(Context rootContext) throws PluginException {
        VariableDefinition config = new VariableDefinition(VARIABLE_CONFIG, FORMAT_CONFIG, true, true, "Demo Plugin Configuration", "default");
        this.createGlobalConfigContext(rootContext, true, config);
    }

    @Override
    public void install(ServerContext context) throws ContextException, PluginException {
        UncheckedCallerController caller = new UncheckedCallerController();
        if (context.getType().equals(CONTEXT_TYPE_TRACKERS)) {
            try {
                if (context.getChild(TRACKER_NAME, caller) != null) {
                    return;
                }
                boolean create = this.getGlobalConfigContext().getVariable(VARIABLE_CONFIG, caller).rec().getBoolean(FIELD_CREATE_TRACKERS);
                if (!create) {
                    return;
                }
                String userContextName = context.getParent().getName();
                String userContextDescription = context.getParent().getDescription();
                String trackerDescription = "Device count of user '" + userContextDescription + "'";
                String devicesContextPath = ContextUtils.devicesContextPath(userContextName);
                String expression = "{" + devicesContextPath + ":" + "children" + "#" + "records" + "}";
                context.callFunction("create", (CallerController)caller, TRACKER_NAME, trackerDescription, expression);
                Object tracker = context.getChild(TRACKER_NAME, caller);
                SimpleDataTable statuses = new SimpleDataTable(tracker.getVariableDefinition("statuses").getFormat());
                statuses.addRecord("Many", "{tracker/} > 100", Color.RED);
                statuses.addRecord("Some", "{tracker/} > 10", Color.ORANGE);
                statuses.addRecord("Few", "{tracker/} > 3", Color.YELLOW);
                statuses.addRecord("Very few", "{tracker/} > 0", Color.GREEN);
                statuses.addRecord("None", "true", Color.WHITE);
                tracker.setVariable("statuses", (CallerController)caller, statuses);
            }
            catch (Exception ex) {
                Log.TRACKERS.error((Object)"Error creating demo tracker", (Throwable)ex);
                context.fireEvent("info", "Error creating demo tracker" + ex.getMessage());
            }
        }
    }

    static {
        FORMAT_CONFIG.addField(FieldFormat.create(FIELD_CREATE_TRACKERS, 'B', "Create Demo Trackers", true));
    }
}

