/*
 * Decompiled with CFR 0.152.
 */
package examples.driver;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.device.AbstractDeviceDriver;
import com.tibbo.aggregate.common.device.DeviceContext;
import com.tibbo.aggregate.common.device.DeviceEntities;
import com.tibbo.aggregate.common.device.DeviceException;
import com.tibbo.aggregate.common.device.DisconnectionException;
import java.util.Collections;
import java.util.List;

public class DemoDeviceDriver
extends AbstractDeviceDriver {
    private String demoSettingValue = "Demo Setting Value";

    public DemoDeviceDriver() {
        super("Demo", null);
    }

    @Override
    public void setupDeviceContext(DeviceContext deviceContext) throws ContextException {
        super.setupDeviceContext(deviceContext);
        deviceContext.setDefaultSynchronizationPeriod(30000L);
        deviceContext.setDeviceType("demo");
    }

    @Override
    public List<VariableDefinition> readVariableDefinitions(DeviceEntities entities) throws ContextException, DeviceException, DisconnectionException {
        FieldFormat ff = FieldFormat.create("demoSettingField", 'S');
        TableFormat format = new TableFormat(1, 1, ff);
        VariableDefinition vd = new VariableDefinition("demoSetting", format, true, true, "Demo Setting", "remote");
        return Collections.singletonList(vd);
    }

    @Override
    public List<FunctionDefinition> readFunctionDefinitions(DeviceEntities entities) throws ContextException, DeviceException, DisconnectionException {
        FieldFormat iff = FieldFormat.create("demoOperationInputField", 'I');
        TableFormat inputFormat = new TableFormat(1, 1, iff);
        FieldFormat off = FieldFormat.create("demoOperationOutputField", 'S');
        TableFormat outputFormat = new TableFormat(1, 1, off);
        FunctionDefinition fd = new FunctionDefinition("demoOperation", inputFormat, outputFormat, "Demo Operation", "default");
        return Collections.singletonList(fd);
    }

    @Override
    public List<EventDefinition> readEventDefinitions(DeviceEntities entities) throws ContextException, DeviceException, DisconnectionException {
        FieldFormat ff = FieldFormat.create("demoEventField", 'S');
        TableFormat format = new TableFormat(1, 1, ff);
        EventDefinition ed = new EventDefinition("demoEvent", format, "Demo Event", "default");
        return Collections.singletonList(ed);
    }

    @Override
    public DataTable readVariableValue(VariableDefinition vd, CallerController caller) throws ContextException, DeviceException, DisconnectionException {
        if (vd.getName().equals("demoSetting")) {
            return new SimpleDataTable(vd.getFormat(), this.demoSettingValue);
        }
        throw new IllegalArgumentException("Unknown demo device setting: " + vd.getName());
    }

    @Override
    public void writeVariableValue(VariableDefinition vd, CallerController caller, DataTable value, DataTable deviceValue) throws ContextException, DeviceException, DisconnectionException {
        if (vd.getName().equals("demoSetting")) {
            this.demoSettingValue = value.rec().getString("demoSettingField");
            return;
        }
        throw new IllegalArgumentException("Unknown demo device setting: " + vd.getName());
    }

    @Override
    public DataTable executeFunction(FunctionDefinition fd, CallerController caller, DataTable parameters) throws ContextException, DeviceException, DisconnectionException {
        if (fd.getName().equals("demoOperation")) {
            int inputParameter = parameters.rec().getInt("demoOperationInputField");
            return new SimpleDataTable(fd.getOutputFormat(), "Value of input parameter multiplied by two: " + inputParameter * 2);
        }
        throw new IllegalArgumentException("Unknown demo device operation: " + fd.getName());
    }

    @Override
    public void finishSynchronization() throws DeviceException {
        this.getDeviceContext().fireEvent("demoEvent", "Demo Event Data: " + Math.random());
    }

    public String getDemoSettingValue() {
        return this.demoSettingValue;
    }
}

