/*
 * Decompiled with CFR 0.152.
 */
package examples.component;

import com.tibbo.aggregate.common.widget.runtime.SwingWidgetEngine;
import com.tibbo.aggregate.common.widget.runtime.renderers.DefaultSwingComponentRenderer;
import com.tibbo.aggregate.common.widget.runtime.renderers.SwingRendererSupport;
import examples.component.WCustomProgressBar;
import examples.component.WCustomProgressBarContext;
import java.awt.Color;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CustomProgressBarSwingRenderer
extends DefaultSwingComponentRenderer<WCustomProgressBar, WCustomProgressBarContext, JProgressBar, SwingRendererSupport> {
    public CustomProgressBarSwingRenderer(WCustomProgressBarContext progressBarContext, SwingWidgetEngine engine) {
        super(progressBarContext, engine);
    }

    @Override
    public JProgressBar createRender() {
        final JProgressBar progressBar = new JProgressBar();
        progressBar.setOrientation(((WCustomProgressBar)this.getComponent()).getOrientation());
        progressBar.setMinimum(((WCustomProgressBar)this.getComponent()).getMinimum());
        progressBar.setMaximum(((WCustomProgressBar)this.getComponent()).getMaximum());
        progressBar.setValue(((WCustomProgressBar)this.getComponent()).getValue());
        progressBar.setStringPainted(true);
        progressBar.setForeground(this.getColor((float)progressBar.getPercentComplete()));
        if (((SwingRendererSupport)this.getRendererSupport()).isInteractive()) {
            progressBar.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ((WCustomProgressBar)CustomProgressBarSwingRenderer.this.getComponent()).setValue(progressBar.getValue());
                }
            });
        }
        return progressBar;
    }

    @Override
    public void componentPropertyChanged(String property) {
        super.componentPropertyChanged(property);
        if (property.equals("value")) {
            ((JProgressBar)this.getRender()).setForeground(this.getColor());
            ((SwingRendererSupport)this.getRendererSupport()).renderChanged();
        }
    }

    public Color getColor() {
        float percentComplete = (float)((JProgressBar)this.getRender()).getPercentComplete();
        return this.getColor(percentComplete);
    }

    public Color getColor(float power) {
        float Hue = power * 0.4f;
        float Saturation = 1.0f;
        float Brightness = 1.0f;
        return Color.getHSBColor(Hue, Saturation, Brightness);
    }
}

