/*
 * Decompiled with CFR 0.152.
 */
package examples.api;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.protocol.RemoteServer;
import com.tibbo.aggregate.common.protocol.RemoteServerController;
import java.util.Date;
import java.util.List;

public class ManageUsers {
    public static void main(String[] args) {
        try {
            Log.start();
            RemoteServer rls = new RemoteServer("localhost", 6460, "admin", "admin");
            RemoteServerController rlc = new RemoteServerController(rls, true);
            rlc.connect();
            rlc.login();
            ContextManager cm = rlc.getContextManager();
            ManageUsers.listUserAccounts(cm);
            ManageUsers.createEditDeleteUser(cm);
            rlc.disconnect();
        }
        catch (Exception ex) {
            Log.TEST.error((Object)"Failed to manage users", (Throwable)ex);
        }
    }

    private static void createEditDeleteUser(ContextManager cm) throws ContextException {
        String testUserName = "testUser";
        String testUserPassword = "testUserPwd123";
        Context userContext = ManageUsers.createTestUser(cm, testUserName, testUserPassword);
        ManageUsers.editTestUser(userContext);
        Object usersContext = cm.get("users");
        ManageUsers.deleteTestUser(usersContext, testUserName);
    }

    private static void listUserAccounts(ContextManager cm) throws ContextException {
        String mask = ContextUtils.userContextPath("*");
        List<Context> userContexts = ContextUtils.expandMaskToContexts(mask, cm);
        for (Context userContext : userContexts) {
            DataTable status = userContext.getVariable("status");
            Date creationTime = status.rec().getDate("creationTime");
            Log.TEST.info((Object)("Found user account: " + userContext.toDetailedString() + " created on " + creationTime));
        }
    }

    public static void deleteTestUser(Context usersContext, String userName) throws ContextException {
        usersContext.callFunction("delete", userName);
    }

    public static Context createTestUser(ContextManager cm, String testUserName, String testUserPassword) throws ContextException {
        cm.getRoot().callFunction("register", testUserName, testUserPassword, testUserPassword);
        String userContextPath = ContextUtils.userContextPath(testUserName);
        Object userContext = cm.get(userContextPath);
        userContext.setVariableField("childInfo", "email", "user@test.com", null);
        return userContext;
    }

    public static void editTestUser(Context userContext) throws ContextException {
        DataTable userInfo = userContext.getVariable("childInfo");
        userInfo.rec().setValue("firstname", (Object)"John");
        userInfo.rec().setValue("lastname", (Object)"Doe");
        userContext.setVariable("childInfo", userInfo);
    }
}

