/*
 * Decompiled with CFR 0.152.
 */
package examples.api;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.DefaultContextEventListener;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.protocol.RemoteServer;
import com.tibbo.aggregate.common.protocol.RemoteServerController;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ManageDevices {
    public static void main(String[] args) {
        try {
            Log.start();
            String username = "admin";
            String password = "admin";
            RemoteServer rls = new RemoteServer("localhost", 6460, "admin", "admin");
            RemoteServerController rlc = new RemoteServerController(rls, true);
            rlc.connect();
            rlc.login();
            ContextManager cm = rlc.getContextManager();
            ManageDevices.listDeviceAccounts("admin", cm);
            String deviceName = "virtualDevice";
            Context deviceContext = ManageDevices.createDeviceAccount("admin", "virtualDevice", "Virtual Device", "com.tibbo.linkserver.plugin.device.virtual", cm);
            ManageDevices.awaitDeviceSynchronization(deviceContext);
            ManageDevices.listDeviceSettings(deviceContext);
            ManageDevices.changeDeviceSettings(deviceContext);
            ManageDevices.listenerForDeviceEvents(deviceContext);
            ManageDevices.executeDeviceOperation(deviceContext);
            ManageDevices.deleteDeviceAccount(deviceContext);
            rlc.disconnect();
        }
        catch (Exception ex) {
            Log.TEST.error((Object)"Failed to manage devices", (Throwable)ex);
        }
    }

    public static void executeDeviceOperation(Context deviceContext) throws ContextException {
        deviceContext.callFunction("generateEvent", "event1", 2, "OurTestString", 11223344);
    }

    public static void listenerForDeviceEvents(Context deviceContext) {
        DefaultContextEventListener deviceEventListener = new DefaultContextEventListener(){

            @Override
            public void handle(Event event) {
                Log.TEST.info((Object)("Received device event with data: " + event.getData().toString()));
            }
        };
        deviceContext.addEventListener("event1", deviceEventListener);
    }

    private static void changeDeviceSettings(Context deviceContext) throws ContextException {
        deviceContext.setVariableField("int", "int", 12345, null);
        DataTable table = deviceContext.getVariable("table");
        table.addRecord("Test String", 1234);
        DataRecord record = table.addRecord();
        record.setValue("string", (Object)"Another String");
        record.setValue("int", (Object)5678);
        deviceContext.setVariable("table", table);
    }

    public static void deleteDeviceAccount(Context deviceContext) throws ContextException {
        deviceContext.getParent().callFunction("delete", deviceContext.getName());
    }

    private static void listDeviceSettings(Context deviceContext) throws ContextException {
        List<VariableDefinition> settings = deviceContext.getVariableDefinitions("remote");
        for (VariableDefinition vd : settings) {
            DataTable value = deviceContext.getVariable(vd.getName());
            Log.TEST.info((Object)("Device setting '" + vd.toDetailedString() + "' has value: " + value.toString()));
        }
    }

    private static void awaitDeviceSynchronization(final Context deviceContext) throws ContextException, InterruptedException {
        int statusSynchronized = 21;
        int currentStatus = deviceContext.getVariable("contextStatus").rec().getInt("status");
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultContextEventListener statusChangeListener = new DefaultContextEventListener(){

            @Override
            public void handle(Event event) {
                if (event.getData().rec().getInt("status") == 21) {
                    latch.countDown();
                    deviceContext.removeEventListener("contextStatusChanged", this);
                }
            }
        };
        deviceContext.addEventListener("contextStatusChanged", statusChangeListener);
        if (currentStatus != 21 && !latch.await(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Device didn't synchronize with the server in time");
        }
    }

    public static Context createDeviceAccount(String username, String name, String description, String driverId, ContextManager cm) throws ContextException {
        String devicesContextPath = ContextUtils.devicesContextPath(username);
        Object adminDevicesContext = cm.get(devicesContextPath);
        adminDevicesContext.callFunction("add", driverId, name, description);
        String deviceContextPath = ContextUtils.deviceContextPath(username, name);
        return cm.get(deviceContextPath);
    }

    private static void listDeviceAccounts(String username, ContextManager cm) throws ContextException {
        String mask = ContextUtils.deviceContextPath(username, "*");
        List<Context> deviceContexts = ContextUtils.expandMaskToContexts(mask, cm);
        for (Context deviceContext : deviceContexts) {
            String driverId = deviceContext.getVariable("status").rec().getString("driver");
            VariableDefinition statusVariableDefinition = deviceContext.getVariableDefinition("status");
            TableFormat statusVariableFormat = statusVariableDefinition.getFormat();
            FieldFormat driverFieldFormat = statusVariableFormat.getField("driver");
            Map driverSelectionValues = driverFieldFormat.getSelectionValues();
            String driverDescription = driverSelectionValues.get(driverId);
            Log.TEST.info((Object)("Found device account: " + deviceContext.toDetailedString() + " (" + driverId + "/" + driverDescription + ")"));
        }
    }
}

