/*
 * Decompiled with CFR 0.152.
 */
package examples.api;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.action.ActionExecutionMode;
import com.tibbo.aggregate.common.action.ActionIdentifier;
import com.tibbo.aggregate.common.action.ActionUtils;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.action.GenericActionResponse;
import com.tibbo.aggregate.common.action.ServerActionInput;
import com.tibbo.aggregate.common.action.command.Confirm;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.protocol.RemoteServer;
import com.tibbo.aggregate.common.protocol.RemoteServerController;

public class ExecuteAction {
    public static void main(String[] args) {
        try {
            Log.start();
            RemoteServer rls = new RemoteServer("localhost", 6460, "admin", "admin");
            RemoteServerController rlc = new RemoteServerController(rls, true);
            rlc.connect();
            rlc.login();
            ContextManager cm = rlc.getContextManager();
            ExecuteAction.executeDiscoveryAction(cm);
            rlc.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void executeDiscoveryAction(ContextManager cm) throws ContextException {
        GenericActionCommand cmd;
        Object devicesContext = cm.get(ContextUtils.devicesContextPath("admin"));
        ActionIdentifier actionId = ExecuteAction.getActionIdentifier(devicesContext);
        GenericActionResponse actionResponse = null;
        while ((cmd = ExecuteAction.getGenericActionCommand(devicesContext, actionId, actionResponse)) != null) {
            actionResponse = ExecuteAction.processCommand(cmd);
            if (cmd.isLast()) break;
            actionResponse.setRequestId(cmd.getRequestId());
        }
    }

    public static GenericActionResponse processCommand(GenericActionCommand cmd) {
        Log.CORE.info((Object)("Received action command: " + cmd));
        DataTable parameters = cmd.getParameters();
        if (cmd.getType().equals("editData")) {
            DataTable data = parameters.rec().getDataTable("data");
            if (cmd.getRequestId().getId().equals("editRangesCommand")) {
                DataRecord rec = data.addRecord();
                rec.setValue("startAddress", (Object)"192.168.1.1");
            }
            return new GenericActionResponse(data);
        }
        if (cmd.getType().equals("confirm")) {
            return new GenericActionResponse(new DataRecord(Confirm.RFT_CONFIRM, 1).wrap());
        }
        throw new IllegalArgumentException("Unexpected action command: " + cmd);
    }

    public static GenericActionCommand getGenericActionCommand(Context devicesContext, ActionIdentifier actionId, GenericActionResponse actionResponse) throws ContextException {
        return ActionUtils.stepAction(devicesContext, actionId, actionResponse, null);
    }

    public static ActionIdentifier getActionIdentifier(Context devicesContext) throws ContextException {
        return ActionUtils.initAction(devicesContext, "discovery", new ServerActionInput(), null, new ActionExecutionMode(4), null);
    }
}

