/*
 * Decompiled with CFR 0.152.
 */
package examples.agent;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.agent.Agent;
import com.tibbo.aggregate.common.agent.AgentContext;
import com.tibbo.aggregate.common.agent.HistoricalValue;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.DefaultContextEventListener;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.protocol.RemoteServer;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DemoAgent {
    private static final String V_SETTING = "setting";
    private static final String V_PERIOD = "period";
    private static final String F_OPERATION = "operation";
    private static final String E_EVENT = "event";
    private static final String VF_SETTING_STRING = "string";
    private static final String VF_SETTING_INTEGER = "integer";
    private static final String VF_PERIOD_PERIOD = "period";
    private static final String FIF_OPERATION_LIMIT = "limit";
    private static final String FOF_OPERATION_RESULT = "result";
    private static final String EF_EVENT_DATA = "data";
    public static final TableFormat VFT_SETTING = new TableFormat(1, 100);
    private static final TableFormat VFT_PERIOD;
    public static final TableFormat FIFT_OPERATION;
    private static final TableFormat FOFT_OPERATION;
    private static final TableFormat EFT_EVENT;
    private static DataTable setting;
    private static long period;

    public static void main(String[] args) {
        Log.start();
        DemoAgent.beginDemo();
    }

    private static void beginDemo() {
        Thread eventGenerator = null;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                final Agent agent = DemoAgent.setUpDemoAgent(period);
                agent.connect();
                eventGenerator = new Thread(){

                    @Override
                    public void run() {
                        while (!this.isInterrupted()) {
                            DemoAgent.setNewVariable(agent, period);
                        }
                    }
                };
                DemoAgent.runAgent(eventGenerator, agent);
            }
            catch (DisconnectionException ex) {
                Log.DEVICE_AGENT.error((Object)"Device has disconnected", (Throwable)ex);
            }
            catch (Exception ex) {
                Log.DEVICE_AGENT.error((Object)"Failed to launch agent", (Throwable)ex);
            }
            DemoAgent.pause();
            DemoAgent.interruptThread(eventGenerator);
        }
    }

    public static Agent setUpDemoAgent(Long eventPeriod) {
        RemoteServer rls = new RemoteServer("localhost", 6480, "admin", "admin");
        DemoAgentContext agentContext = new DemoAgentContext(rls, "java", true);
        Agent agent = new Agent(agentContext, false, false, 0);
        DemoAgent.initializeAgentContext(agent.getContext(), eventPeriod);
        return agent;
    }

    public static void setNewVariable(Agent agent, Long period) {
        try {
            Thread.sleep(period);
        }
        catch (InterruptedException ex) {
            return;
        }
        if (agent.getContext().isSynchronized()) {
            SimpleDataTable eventData = new SimpleDataTable(agent.getContext().getEventDefinition(E_EVENT).getFormat(), Float.valueOf((float)(Math.random() * 1000000.0)));
            agent.getContext().fireEvent(E_EVENT, 2, (DataTable)eventData);
            if (Math.random() > 0.1) {
                try {
                    agent.getContext().setVariable(V_SETTING, agent.getContext().getVariable(V_SETTING).rec().getString(VF_SETTING_STRING), Math.random() * 1000.0);
                }
                catch (ContextException ex) {
                    Log.DEVICE_AGENT.error((Object)"Failed to set variable setting", (Throwable)ex);
                }
            }
        }
    }

    private static void runAgent(Thread eventGenerator, Agent agent) throws SyntaxErrorException, DisconnectionException, IOException {
        eventGenerator.setDaemon(true);
        eventGenerator.start();
        while (!Thread.currentThread().isInterrupted()) {
            agent.run();
        }
        agent.disconnect();
    }

    private static void pause() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            System.exit(0);
        }
    }

    private static void interruptThread(Thread eventGenerator) {
        if (eventGenerator != null) {
            eventGenerator.interrupt();
        }
    }

    private static void initializeAgentContext(AgentContext context, Long eventPeriod) {
        VariableDefinition vd = new VariableDefinition(V_SETTING, VFT_SETTING, true, true, "Tabular Setting", "remote");
        vd.setGetter((con, def, caller, request) -> setting);
        vd.setSetter((con, def, caller, request, value) -> {
            setting = value;
            return true;
        });
        context.addVariableDefinition(vd);
        vd = new VariableDefinition("period", VFT_PERIOD, true, true, "Event Generation Period", "remote");
        vd.setGetter((con, def, caller, request) -> new DataRecord(VFT_PERIOD).addLong(eventPeriod).wrap());
        vd.setSetter((con, def, caller, request, value) -> {
            period = value.rec().getLong("period");
            Log.DEVICE_AGENT.info((Object)("Server has changed event generation period to: " + period));
            return true;
        });
        context.addVariableDefinition(vd);
        FunctionDefinition fd = new FunctionDefinition(F_OPERATION, FIFT_OPERATION, FOFT_OPERATION, "Agent Operation", "remote");
        fd.setImplementation((con, def, caller, request, parameters) -> {
            int limit = parameters.rec().getInt(FIF_OPERATION_LIMIT);
            int result = (int)(Math.random() * (double)limit);
            Log.DEVICE_AGENT.info((Object)("Server has executed random number generation operation with limit: " + limit + ", result: " + result));
            return new DataRecord(def.getOutputFormat()).addInt(result).wrap();
        });
        context.addFunctionDefinition(fd);
        EventDefinition ed = new EventDefinition(E_EVENT, EFT_EVENT, "Agent Event", "remote");
        context.addEventDefinition(ed);
        context.addEventListener("eventConfirmed", new DefaultContextEventListener(){

            @Override
            public void handle(Event event) {
                Log.DEVICE_AGENT.info((Object)("Server has confirmed event with ID: " + event.getData().rec().getLong("id")));
            }
        });
    }

    static {
        VFT_SETTING.addField("<string><S><D=String Field>");
        VFT_SETTING.addField("<integer><I><D=Integer Field>");
        VFT_PERIOD = new TableFormat(1, 1, "<period><L><A=5000><D=Event Generation Period><V=<L=100 100000000>><E=period>");
        FIFT_OPERATION = new TableFormat(1, 1, "<limit><I><A=100><D=Limit>");
        FOFT_OPERATION = new TableFormat(1, 1, "<result><I><D=Result>");
        EFT_EVENT = new TableFormat(1, 1, "<data><F><D=Data>");
        setting = new SimpleDataTable(VFT_SETTING, true);
        period = 5000L;
    }

    private static class DemoAgentContext
    extends AgentContext {
        private boolean sentHistory = false;

        public DemoAgentContext(RemoteServer server, String name, boolean eventConfirmation) {
            super(server, name, eventConfirmation);
        }

        @Override
        protected List<HistoricalValue> getHistory() {
            if (this.sentHistory) {
                return Collections.emptyList();
            }
            this.sentHistory = true;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(13, -1);
            SimpleDataTable historicalValue = new SimpleDataTable(VFT_SETTING, "Historical Value", 456);
            HistoricalValue hv = new HistoricalValue(DemoAgent.V_SETTING, cal.getTime(), historicalValue);
            return Collections.singletonList(hv);
        }
    }
}

