/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.runtime.util;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.widget.WGridConstraints;
import com.tibbo.aggregate.common.widget.component.WAbstractComponent;
import com.tibbo.aggregate.common.widget.component.WComponent;
import com.tibbo.aggregate.common.widget.context.WAbstractContext;
import com.tibbo.aggregate.common.widget.context.WComponentContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WidgetComponentApiRendererUtilities {
    public static void setRendererSize(JComponent renderer, WComponent component) {
        int width = component.getWidth();
        int height = component.getHeight();
        if (width <= 0 && height <= 0 || renderer == null) {
            return;
        }
        Dimension dSize = renderer.getPreferredSize();
        dSize.width = width > 0 ? width : dSize.width;
        dSize.height = height > 0 ? height : dSize.height;
        renderer.setPreferredSize(dSize);
        renderer.setMinimumSize(dSize);
    }

    public static void initBasicProperties(WAbstractContext context, WAbstractComponent component, JComponent renderedComponent, ContextManager contextManager) {
        Integer c;
        Font f;
        Border b;
        if (context.getVariableDefinition("enabled") != null) {
            renderedComponent.setEnabled(component.isEnabled());
        }
        if (context.getVariableDefinition("visible") != null) {
            renderedComponent.setVisible(component.isVisible());
        }
        if (context.getVariableDefinition("focusable") != null) {
            renderedComponent.setFocusable(component.isFocusable());
        }
        if (context.getVariableDefinition("background") != null) {
            Color bg = component.getBackground();
            renderedComponent.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        }
        if (context.getVariableDefinition("toolTipText") != null) {
            renderedComponent.setToolTipText(component.getToolTipText());
        }
        if (context.getVariableDefinition("foreground") != null) {
            renderedComponent.setForeground(component.getForeground());
        }
        if (context.getVariableDefinition("opaque") != null) {
            renderedComponent.setOpaque(component.isOpaque());
        }
        if (context.getVariableDefinition("border") != null && (b = component.getBorder()) != null) {
            renderedComponent.setBorder(b);
        }
        if (context.getVariableDefinition("font") != null && (f = component.getFont()) != null) {
            renderedComponent.setFont(f);
        }
        if (context.getVariableDefinition("cursor") != null && (c = component.getCursor()) != null) {
            renderedComponent.setCursor(Cursor.getPredefinedCursor(c));
        }
        if (context.getVariableDefinition("popupMenu") != null) {
            WidgetComponentApiRendererUtilities.setComponentPopupMenu(context, renderedComponent, context.getPath(), contextManager);
        }
    }

    public static void setComponentPopupMenu(WComponentContext context, JComponent renderedComponent, String contextName, ContextManager contextManager) {
        JPopupMenu popupMenu;
        if (!(context.getComponent() instanceof WAbstractComponent)) {
            return;
        }
        WAbstractComponent component = (WAbstractComponent)context.getComponent();
        DataTable popupMenuTable = component.getPopupMenu();
        if (popupMenuTable != null && (popupMenu = WidgetComponentApiRendererUtilities.createPopupMenu(context, popupMenuTable, contextName, contextManager)).getSubElements() != null && popupMenu.getSubElements().length > 0) {
            renderedComponent.setComponentPopupMenu(popupMenu);
        }
    }

    public static void setComponentPopupMenu(WComponentContext context, JComponent renderedComponent, ContextManager contextManager) {
        WidgetComponentApiRendererUtilities.setComponentPopupMenu(context, renderedComponent, context.getPath(), contextManager);
    }

    public static JPopupMenu createPopupMenu(WComponentContext context, String contextName) {
        WAbstractComponent component = (WAbstractComponent)context.getComponent();
        DataTable popupMenuTable = component.getPopupMenu();
        if (popupMenuTable != null) {
            return WidgetComponentApiRendererUtilities.createPopupMenu(context, popupMenuTable, contextName, (ContextManager)null);
        }
        return null;
    }

    public static JPopupMenu createPopupMenu(WComponentContext context, DataTable popupMenuTable, String contextName, ContextManager contextManager) {
        return WidgetComponentApiRendererUtilities.createPopupMenu(context, popupMenuTable, new JPopupMenu(), contextName, true, contextManager);
    }

    public static JPopupMenu createPopupMenu(WComponentContext context, DataTable popupMenuTable, String contextName, Boolean useDefaulListener) {
        return WidgetComponentApiRendererUtilities.createPopupMenu(context, popupMenuTable, new JPopupMenu(), contextName, useDefaulListener, null);
    }

    public static JPopupMenu createPopupMenu(final Context context, final DataTable popupMenuTable, JPopupMenu popupMenu, String contextName, Boolean useDefaulListener, final ContextManager contextManager) {
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
        }
        final LinkedList<JMenuItem> items = WidgetComponentApiRendererUtilities.createMenuItems(context, popupMenuTable, contextName, useDefaulListener);
        for (JMenuItem item : items) {
            popupMenu.add(item);
        }
        if (contextManager != null) {
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    WidgetComponentApiRendererUtilities.processMenuItemsConditions(context, popupMenuTable, items, contextManager);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return popupMenu;
    }

    public static LinkedList<JMenuItem> createMenuItems(Context context, DataTable popupMenuTable, String contextName, Boolean useDefaulListener) {
        LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
        for (DataRecord rec : popupMenuTable) {
            menuItems.add(WidgetComponentApiRendererUtilities.createMenuItem(context, contextName, rec, useDefaulListener));
        }
        return menuItems;
    }

    public static void processMenuItemsConditions(Context context, DataTable popupMenuTable, Collection<JMenuItem> popupMenuItems, ContextManager contextManager) {
        Evaluator evaluator = new Evaluator(contextManager, context, null, contextManager.getCallerController());
        block0: for (DataRecord rec : popupMenuTable) {
            String name = rec.getString("name");
            for (JMenuItem item : popupMenuItems) {
                if (!Objects.equals(name, item.getName())) continue;
                item.setVisible(WidgetComponentApiRendererUtilities.checkCondition(evaluator, rec.getString("condition")));
                continue block0;
            }
        }
    }

    private static Boolean checkCondition(Evaluator evaluator, String condition) {
        if (condition != null && !condition.isEmpty() && evaluator != null) {
            Expression conditionExpression = new Expression(condition);
            try {
                return evaluator.evaluateToBoolean(conditionExpression);
            }
            catch (Exception ex) {
                Log.WIDGETS.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    public static JMenuItem createMenuItem(Context context, String contextName, DataRecord rec, Boolean useDefaulListener) {
        ImageIcon icon;
        String name = rec.getString("name");
        String description = rec.getString("description");
        Data iconData = rec.getData("icon");
        try {
            icon = new ImageIcon(iconData.getData(), description);
        }
        catch (Exception e) {
            icon = null;
        }
        JMenuItem menuItem = new JMenuItem();
        menuItem.setName(name);
        menuItem.setText(description);
        menuItem.setIcon(icon);
        if (useDefaulListener.booleanValue()) {
            menuItem.addActionListener(WidgetComponentApiRendererUtilities.createMenuListener(context, contextName, name, description, icon));
        }
        return menuItem;
    }

    public static void updateMenuListeners(Context context, DataTable popupMenuTable, String contextName, Boolean useDefaulListener, Component[] components) {
        HashMap<String, AbstractAction> listeners = WidgetComponentApiRendererUtilities.createMenuListeners(context, popupMenuTable, contextName, true);
        for (Component c : components) {
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem item = (JMenuItem)c;
            for (ActionListener listener : item.getActionListeners()) {
                item.removeActionListener(listener);
            }
            item.addActionListener(listeners.get(item.getName()));
        }
    }

    public static HashMap<String, AbstractAction> createMenuListeners(Context context, DataTable popupMenuTable, String contextName, Boolean useDefaulListener) {
        HashMap<String, AbstractAction> menuListeners = new HashMap<String, AbstractAction>();
        for (DataRecord rec : popupMenuTable) {
            ImageIcon icon;
            String name = rec.getString("name");
            String description = rec.getString("description");
            Data iconData = rec.getData("icon");
            try {
                icon = new ImageIcon(iconData.getData(), description);
            }
            catch (Exception e) {
                icon = null;
            }
            menuListeners.put(name, WidgetComponentApiRendererUtilities.createMenuListener(context, contextName, name, description, icon));
        }
        return menuListeners;
    }

    public static AbstractAction createMenuListener(final Context context, final String contextName, final String name, String description, Icon icon) {
        return new AbstractAction(description, icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataRecord eventData = new DataRecord(WAbstractContext.EFT_MENU_POPUP, name, contextName);
                context.fireEvent("menuPopup", eventData.wrap());
            }
        };
    }

    public static boolean hasCustomBorder(WComponent component) {
        return ((WAbstractComponent)component).getBorder() != null;
    }

    public static GridBagConstraints convertConstraintsToGridBag(WGridConstraints cs) {
        GridBagConstraints gcs = new GridBagConstraints();
        gcs.gridx = cs.getGridx();
        gcs.gridy = cs.getGridy();
        gcs.gridheight = cs.getGridheight();
        gcs.gridwidth = cs.getGridwidth();
        gcs.anchor = cs.getAnchor();
        gcs.fill = cs.getFill();
        gcs.insets = new Insets(cs.getInsetsTop(), cs.getInsetsLeft(), cs.getInsetsBottom(), cs.getInsetsRight());
        gcs.weightx = cs.getWeightx();
        gcs.weighty = cs.getWeighty();
        return gcs;
    }
}

