/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.runtime.renderers;

import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.widget.Res;
import com.tibbo.aggregate.common.widget.component.WAbstractComponent;
import com.tibbo.aggregate.common.widget.context.WAbstractContext;
import com.tibbo.aggregate.common.widget.context.WComponentContext;
import com.tibbo.aggregate.common.widget.runtime.renderers.AbstractSwingRenderer;
import com.tibbo.aggregate.common.widget.runtime.renderers.RendererSupport;
import com.tibbo.aggregate.common.widget.runtime.util.WidgetComponentApiRendererUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.JComponent;

public class SwingRendererSupport<C extends WAbstractComponent, T extends WAbstractContext<WComponentContext, C>, O extends JComponent>
implements RendererSupport<JComponent> {
    private final AbstractSwingRenderer<C, T, O, SwingRendererSupport> renderer;

    public SwingRendererSupport(AbstractSwingRenderer<C, T, O, SwingRendererSupport> renderer) {
        this.renderer = renderer;
    }

    public AbstractSwingRenderer<C, T, O, SwingRendererSupport> getRenderer() {
        return this.renderer;
    }

    @Override
    public void initView() {
        WidgetComponentApiRendererUtilities.initBasicProperties((WAbstractContext)this.renderer.getComponentContext(), this.renderer.getComponent(), (JComponent)this.renderer.getRender(), this.getRenderer().getEngine().getServerContextManager());
        WidgetComponentApiRendererUtilities.setRendererSize(this.getProduction(), this.renderer.getComponent());
    }

    @Override
    public JComponent getProduction() {
        return this.renderer.getRender();
    }

    @Override
    public void resetRender() {
    }

    @Override
    public void componentPropertyChanged(String property) {
        WAbstractComponent comp = (WAbstractComponent)this.getRenderer().getComponentContext().getComponent();
        if (property.equals("width")) {
            if (comp.getWidth() > 0) {
                Dimension d = this.getProduction().getPreferredSize();
                d.width = comp.getWidth();
                this.getProduction().setPreferredSize(d);
            }
        } else if (property.equals("height")) {
            if (comp.getHeight() > 0) {
                Dimension d = this.getProduction().getPreferredSize();
                d.height = comp.getHeight();
                this.getProduction().setPreferredSize(d);
            }
        } else if (property.equals("border")) {
            ((JComponent)this.getRenderer().getRender()).setBorder(((WAbstractComponent)this.getRenderer().getComponent()).getBorder());
        } else if (property.equals("font")) {
            ((JComponent)this.getRenderer().getRender()).setFont(((WAbstractComponent)this.getRenderer().getComponent()).getFont());
        } else if (property.equals("focusable")) {
            ((Component)this.getRenderer().getRender()).setFocusable(((WAbstractComponent)this.getRenderer().getComponent()).isFocusable());
        } else if (property.equals("cursor")) {
            if (((WAbstractComponent)this.getRenderer().getComponent()).getCursor() != null) {
                ((Component)this.getRenderer().getRender()).setCursor(Cursor.getPredefinedCursor(((WAbstractComponent)this.getRenderer().getComponent()).getCursor()));
            }
        } else if (property.equals("popupMenu")) {
            WidgetComponentApiRendererUtilities.setComponentPopupMenu(this.getRenderer().getComponentContext(), (JComponent)this.getRenderer().getRender(), this.getRenderer().getComponentContext().getPath(), this.getRenderer().getEngine().getServerContextManager());
        } else {
            try {
                AbstractSwingRenderer.synchronizeProperty(property, this.getRenderer().getComponent(), this.getRenderer().getRender());
            }
            catch (ContextException ex) {
                this.getRenderer().getComponentContext().fireExceptionEvent(Res.get().getString("errSettingNewValue") + ": " + ex.getMessage(), ex);
                return;
            }
        }
        this.revalidateAndRepaint();
    }

    public void revalidateAndRepaint() {
        this.getProduction().revalidate();
        this.getProduction().repaint();
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
    }

    public void renderChanged() {
    }
}

