/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.runtime.renderers;

import com.tibbo.aggregate.common.binding.ExtendedBinding;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.widget.component.WAbstractComponent;
import com.tibbo.aggregate.common.widget.component.WComponent;
import com.tibbo.aggregate.common.widget.context.WAbstractContext;
import com.tibbo.aggregate.common.widget.context.WComponentContext;
import com.tibbo.aggregate.common.widget.runtime.SwingWidgetEngine;
import com.tibbo.aggregate.common.widget.runtime.renderers.AbstractSwingRenderer;
import com.tibbo.aggregate.common.widget.runtime.renderers.SwingRendererSupport;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public abstract class DefaultSwingComponentRenderer<C extends WAbstractComponent, T extends WAbstractContext<WComponentContext, C>, O extends JComponent, S extends SwingRendererSupport>
extends AbstractSwingRenderer<C, T, O, S> {
    private final CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireCaretUpdate(e);
        }
    };
    private final FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireFocusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireFocusLost(e);
        }
    };
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireKeyTyped(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireKeyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireKeyReleased(e);
        }
    };
    private final MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireWheelMoved(e);
        }
    };
    private final MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireMouseMoved(e);
        }
    };
    private final MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!((WAbstractComponent)DefaultSwingComponentRenderer.this.getComponent()).isEnabled()) {
                return;
            }
            if (e.getClickCount() == 2) {
                ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireMouseDoubleClicked(e);
                return;
            }
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireMouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!((WAbstractComponent)DefaultSwingComponentRenderer.this.getComponent()).isEnabled()) {
                return;
            }
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!((WAbstractComponent)DefaultSwingComponentRenderer.this.getComponent()).isEnabled()) {
                return;
            }
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireMouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireMouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireMouseExited(e);
        }
    };
    private final ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireResized(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireMoved(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireShown(e);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ((WAbstractContext)DefaultSwingComponentRenderer.this.getComponentContext()).fireHidden(e);
        }
    };
    private final HashMap<String, Registrar> eventToRegistrar = new HashMap();

    public DefaultSwingComponentRenderer(T componentContext, SwingWidgetEngine engine) {
        super(componentContext, engine);
        this.initRegistrars();
    }

    @Override
    public void start() {
        super.start();
        this.addSwingEventListeners();
    }

    @Override
    public void stop() {
        super.stop();
        this.removeSwingEventListeners();
    }

    @Override
    public void componentPropertyChanged(String property) {
        if ("bindings".equals(property)) {
            this.addSwingEventListeners();
        }
        ((SwingRendererSupport)this.getRendererSupport()).componentPropertyChanged(property);
    }

    public JComponent getProduction() {
        return ((SwingRendererSupport)this.getRendererSupport()).getProduction();
    }

    private void addSwingEventListeners() {
        if (this.getRender() != null) {
            Set<Registrar> registrars = this.getRegistrars();
            for (Registrar registrar : registrars) {
                registrar.addListener();
            }
        }
    }

    private void removeSwingEventListeners() {
        if (this.getRender() != null) {
            Set<Registrar> registrars = this.getRegistrars();
            for (Registrar registrar : registrars) {
                registrar.removeListener();
            }
        }
    }

    public Set<Registrar> getRegistrars() {
        HashSet<Registrar> registrars = new HashSet<Registrar>();
        for (ExtendedBinding binding : this.getEngine().getWidget().getBindings()) {
            Registrar e;
            Reference activator = binding.getEvaluationOptions().getActivator();
            if (activator == null || !((WComponent)this.getComponent()).getName().equals(activator.getContext()) || activator.getEntityType() != 4 || (e = this.eventToRegistrar.get(activator.getEntity())) == null) continue;
            registrars.add(e);
        }
        return registrars;
    }

    private void initRegistrars() {
        Registrar componentRegistrar = new Registrar(){

            @Override
            public void addListener() {
                this.removeListener();
                ((Component)DefaultSwingComponentRenderer.this.getRender()).addComponentListener(DefaultSwingComponentRenderer.this.componentListener);
            }

            @Override
            public void removeListener() {
                ((Component)DefaultSwingComponentRenderer.this.getRender()).removeComponentListener(DefaultSwingComponentRenderer.this.componentListener);
            }
        };
        Registrar mouseRegistrar = new Registrar(){

            @Override
            public void addListener() {
                this.removeListener();
                ((Component)DefaultSwingComponentRenderer.this.getRender()).addMouseListener(DefaultSwingComponentRenderer.this.mouseListener);
            }

            @Override
            public void removeListener() {
                ((Component)DefaultSwingComponentRenderer.this.getRender()).removeMouseListener(DefaultSwingComponentRenderer.this.mouseListener);
            }
        };
        Registrar mouseMotionRegistrar = new Registrar(){

            @Override
            public void addListener() {
                this.removeListener();
                ((Component)DefaultSwingComponentRenderer.this.getRender()).addMouseMotionListener(DefaultSwingComponentRenderer.this.mouseMotionListener);
            }

            @Override
            public void removeListener() {
                ((Component)DefaultSwingComponentRenderer.this.getRender()).removeMouseMotionListener(DefaultSwingComponentRenderer.this.mouseMotionListener);
            }
        };
        Registrar mouseWheelRegistrar = new Registrar(){

            @Override
            public void addListener() {
                this.removeListener();
                ((Component)DefaultSwingComponentRenderer.this.getRender()).addMouseWheelListener(DefaultSwingComponentRenderer.this.mouseWheelListener);
            }

            @Override
            public void removeListener() {
                ((Component)DefaultSwingComponentRenderer.this.getRender()).removeMouseWheelListener(DefaultSwingComponentRenderer.this.mouseWheelListener);
            }
        };
        Registrar keyRegistrar = new Registrar(){

            @Override
            public void addListener() {
                this.removeListener();
                ((Component)DefaultSwingComponentRenderer.this.getRender()).addKeyListener(DefaultSwingComponentRenderer.this.keyListener);
            }

            @Override
            public void removeListener() {
                ((Component)DefaultSwingComponentRenderer.this.getRender()).removeKeyListener(DefaultSwingComponentRenderer.this.keyListener);
            }
        };
        Registrar focusRegistrar = new Registrar(){

            @Override
            public void addListener() {
                this.removeListener();
                ((Component)DefaultSwingComponentRenderer.this.getRender()).addFocusListener(DefaultSwingComponentRenderer.this.focusListener);
            }

            @Override
            public void removeListener() {
                ((Component)DefaultSwingComponentRenderer.this.getRender()).removeFocusListener(DefaultSwingComponentRenderer.this.focusListener);
            }
        };
        Registrar caretRegistrar = new Registrar(){

            @Override
            public void addListener() {
                this.removeListener();
                ((JTextComponent)DefaultSwingComponentRenderer.this.getRender()).addCaretListener(DefaultSwingComponentRenderer.this.caretListener);
            }

            @Override
            public void removeListener() {
                ((JTextComponent)DefaultSwingComponentRenderer.this.getRender()).removeCaretListener(DefaultSwingComponentRenderer.this.caretListener);
            }
        };
        this.eventToRegistrar.put("hidden", componentRegistrar);
        this.eventToRegistrar.put("shown", componentRegistrar);
        this.eventToRegistrar.put("resized", componentRegistrar);
        this.eventToRegistrar.put("moved", componentRegistrar);
        this.eventToRegistrar.put("mouseClicked", mouseRegistrar);
        this.eventToRegistrar.put("mouseDoubleClicked", mouseRegistrar);
        this.eventToRegistrar.put("mousePressed", mouseRegistrar);
        this.eventToRegistrar.put("mouseReleased", mouseRegistrar);
        this.eventToRegistrar.put("mouseEntered", mouseRegistrar);
        this.eventToRegistrar.put("mouseExited", mouseRegistrar);
        this.eventToRegistrar.put("mouseMoved", mouseMotionRegistrar);
        this.eventToRegistrar.put("mouseWheelMoved", mouseWheelRegistrar);
        this.eventToRegistrar.put("keyTyped", keyRegistrar);
        this.eventToRegistrar.put("keyPressed", keyRegistrar);
        this.eventToRegistrar.put("keyReleased", keyRegistrar);
        this.eventToRegistrar.put("focusGained", focusRegistrar);
        this.eventToRegistrar.put("focusLost", focusRegistrar);
        this.eventToRegistrar.put("caretUpdate", caretRegistrar);
    }

    static interface Registrar {
        public void addListener();

        public void removeListener();
    }
}

