/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.runtime.renderers;

import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.widget.component.WAbstractComponent;
import com.tibbo.aggregate.common.widget.component.WComponent;
import com.tibbo.aggregate.common.widget.context.WAbstractContext;
import com.tibbo.aggregate.common.widget.context.WComponentContext;
import com.tibbo.aggregate.common.widget.runtime.SwingWidgetEngine;
import com.tibbo.aggregate.common.widget.runtime.renderers.RendererSupport;
import com.tibbo.aggregate.common.widget.runtime.renderers.WidgetComponentRenderer;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractSwingRenderer<C extends WAbstractComponent, T extends WAbstractContext<WComponentContext, C>, O extends JComponent, U extends RendererSupport>
implements WidgetComponentRenderer {
    private U rendererSupport;
    private final SwingWidgetEngine engine;
    private O render;
    private final T componentContext;

    public AbstractSwingRenderer(T componentContext, SwingWidgetEngine engine) {
        this.engine = engine;
        this.componentContext = componentContext;
    }

    public abstract O createRender();

    @Override
    public void start() {
        this.getRendererSupport().start();
    }

    @Override
    public void stop() {
        this.getRendererSupport().stop();
    }

    @Override
    public T getComponentContext() {
        return this.componentContext;
    }

    @Override
    public O getRender() {
        if (this.render == null) {
            this.render = this.createRender();
        }
        return this.render;
    }

    public String getComponentName() {
        return ((WComponent)this.getComponent()).getName();
    }

    public void setRender(O render) {
        this.render = render;
        this.getRendererSupport().resetRender();
    }

    public U getRendererSupport() {
        return this.rendererSupport;
    }

    public void setRendererSupport(U rendererSupport) {
        this.rendererSupport = rendererSupport;
        rendererSupport.initView();
    }

    public SwingWidgetEngine getEngine() {
        return this.engine;
    }

    public C getComponent() {
        return (C)((WAbstractComponent)((WComponentContext)this.componentContext).getComponent());
    }

    public static Color removeAlphaFromColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void synchronizeProperty(String prop, WComponent wComponent, Object jComponent) throws ContextException {
        try {
            if (PropertyUtils.isWriteable((Object)jComponent, (String)prop) && PropertyUtils.isReadable((Object)wComponent, (String)prop)) {
                if (prop.equals("background")) {
                    PropertyUtils.setProperty((Object)jComponent, (String)prop, (Object)AbstractSwingRenderer.removeAlphaFromColor((Color)PropertyUtils.getProperty((Object)wComponent, (String)prop)));
                } else {
                    PropertyUtils.setProperty((Object)jComponent, (String)prop, (Object)PropertyUtils.getProperty((Object)wComponent, (String)prop));
                }
            }
        }
        catch (InvocationTargetException ex) {
            throw new ContextException("Error while setting property '" + prop + "' of component '" + wComponent.getName() + "' to its renderer: " + ex.getCause().getMessage(), ex);
        }
        catch (Exception ex1) {
            throw new ContextException("Error while setting property '" + prop + "' of component: " + wComponent.getName() + " to its renderer: " + ex1.getMessage(), ex1);
        }
    }
}

