/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.engine;

import com.tibbo.aggregate.common.datatable.AggreGateBean;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.validator.LimitsValidator;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;
import com.tibbo.aggregate.common.widget.Res;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class ComponentPinPoint
extends AggreGateBean {
    public static final String STANDARD_NAME = "pin";
    public static final String V_PIN_NAME = "name";
    public static final String V_PIN_TYPE = "type";
    public static final String V_PIN_Y_COMPONENT_COORDINATE = "pinYCoordinate";
    public static final String V_PIN_X_COMPONENT_COORDINATE = "pinXCoordinate";
    public static final int NONE = -1;
    public static final int INPUT = 0;
    public static final int IN_OUT = 1;
    public static final int OUTPUT = 2;
    public static final float DELTA = 0.1f;
    public static final TableFormat VFT_PIN = new TableFormat(true);
    private String name;
    private float pinXCoordinate;
    private float pinYCoordinate;
    private int type;

    public ComponentPinPoint(float pinXCoordinate, float pinYCoordinate) {
        this(pinXCoordinate, pinYCoordinate, STANDARD_NAME, -1);
    }

    public ComponentPinPoint() {
        super(VFT_PIN);
    }

    public ComponentPinPoint(DataRecord data) {
        super(VFT_PIN, data);
    }

    public ComponentPinPoint(float pinXCoordinate, float pinYCoordinate, String name, int type) {
        super(VFT_PIN);
        this.pinXCoordinate = pinXCoordinate;
        this.pinYCoordinate = pinYCoordinate;
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Point getAbsolutePosition(Point componentCoordinate, int width, int height) {
        AffineTransform at = new AffineTransform();
        at.translate(componentCoordinate.x, componentCoordinate.y);
        at.scale(width, height);
        Point2D res = at.transform(new Point2D.Float(this.pinXCoordinate, this.pinYCoordinate), null);
        return new Point((int)res.getX(), (int)res.getY());
    }

    public void setPositionFromAbsolute(Point absolutePosition, int width, int heght) {
        Point2D.Float p = new Point2D.Float((float)absolutePosition.x / (float)width, (float)absolutePosition.y / (float)heght);
        this.setPinXCoordinate(p.x);
        this.setPinYCoordinate(p.y);
    }

    public int getAnchorLocation() {
        double x = this.pinXCoordinate;
        double y = this.pinYCoordinate;
        if (x >= (double)0.1f && x <= (double)0.9f && y <= (double)0.1f) {
            return 11;
        }
        if (x < (double)0.1f && x > y) {
            return 11;
        }
        if (x > (double)0.9f && 1.0 - x < y && y < (double)0.1f) {
            return 11;
        }
        if (x >= (double)0.1f && x <= (double)0.9f && y >= (double)0.9f) {
            return 15;
        }
        if (x < (double)0.1f && x > 1.0 - y) {
            return 15;
        }
        if (x > (double)0.9f && x < y) {
            return 15;
        }
        if (y >= (double)0.1f && y <= (double)0.9f && x <= (double)0.1f) {
            return 17;
        }
        if (y < (double)0.1f && x <= y) {
            return 17;
        }
        if (y > (double)0.9f && 1.0 - y <= x) {
            return 17;
        }
        if (y >= (double)0.1f && y <= (double)0.9f && x >= (double)0.9f) {
            return 13;
        }
        if (y < (double)0.1f && 1.0 - x <= y) {
            return 13;
        }
        if (y > (double)99.9f && y <= x) {
            return 13;
        }
        return 10;
    }

    public String toString() {
        return "ComponentPinPoint{name='" + this.name + '\'' + ", pinXCoordinate=" + this.pinXCoordinate + ", pinYCoordinate=" + this.pinYCoordinate + ", type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentPinPoint that = (ComponentPinPoint)o;
        if (Float.compare(that.pinXCoordinate, this.pinXCoordinate) != 0) {
            return false;
        }
        if (Float.compare(that.pinYCoordinate, this.pinYCoordinate) != 0) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.pinXCoordinate != 0.0f ? Float.floatToIntBits(this.pinXCoordinate) : 0);
        result = 31 * result + (this.pinYCoordinate != 0.0f ? Float.floatToIntBits(this.pinYCoordinate) : 0);
        result = 31 * result + this.type;
        return result;
    }

    public float getPinYCoordinate() {
        return this.pinYCoordinate;
    }

    public void setPinYCoordinate(float pinYCoordinate) {
        this.pinYCoordinate = pinYCoordinate;
    }

    public float getPinXCoordinate() {
        return this.pinXCoordinate;
    }

    public void setPinXCoordinate(float pinXCoordinate) {
        this.pinXCoordinate = pinXCoordinate;
    }

    static {
        FieldFormat<Object> ff = FieldFormat.create(V_PIN_NAME, 'S', Res.get().getString("wPinName"));
        ff.setNullable(true);
        ff.setKeyField(true);
        VFT_PIN.addField(ff);
        ff = FieldFormat.create(V_PIN_TYPE, 'I', Res.get().getString("wPinType")).setDefault(-1);
        ff.addSelectionValue(0, Res.get().getString("wInput"));
        ff.addSelectionValue(2, Res.get().getString("wOutput"));
        ff.addSelectionValue(1, Res.get().getString("wInOut"));
        ff.addSelectionValue(-1, Res.get().getString("wNone"));
        VFT_PIN.addField(ff);
        ff = FieldFormat.create(V_PIN_X_COMPONENT_COORDINATE, 'F', Res.get().getString("wPinXPosition"));
        ff.addValidator(new LimitsValidator(Float.valueOf(0.0f), Float.valueOf(1.0f)));
        VFT_PIN.addField(ff);
        ff = FieldFormat.create(V_PIN_Y_COMPONENT_COORDINATE, 'F', Res.get().getString("wPinYPosition"));
        ff.addValidator(new LimitsValidator(Float.valueOf(0.0f), Float.valueOf(1.0f)));
        VFT_PIN.addField(ff);
        String exp = "{name}==null ? " + (Object)((Object)DefaultFunctions.LONG) + "(" + (Object)((Object)DefaultFunctions.RANDOM) + "()*" + Long.MAX_VALUE + ") : {" + V_PIN_NAME + "}";
        VFT_PIN.addBinding(V_PIN_NAME, exp);
    }
}

