/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.context;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.AbstractContext;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.DefaultRequestController;
import com.tibbo.aggregate.common.context.RequestController;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.context.VariableGetter;
import com.tibbo.aggregate.common.context.VariableSetter;
import com.tibbo.aggregate.common.datatable.AggreGateBean;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableReplication;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.FormatConverter;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.structure.Pinpoint;
import com.tibbo.aggregate.common.util.UserSettings;
import com.tibbo.aggregate.common.util.Util;
import com.tibbo.aggregate.common.widget.WidgetConstants;
import com.tibbo.aggregate.common.widget.component.IComponent;
import com.tibbo.aggregate.common.widget.context.ComponentPropertyChangeListener;
import com.tibbo.aggregate.common.widget.context.MutablePropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class WContext<C extends WContext, T extends IComponent>
extends AbstractContext<C> {
    public static final String GROUP_CONSTRAINTS = ContextUtils.createGroup("default", Cres.get().getString("wConstraints"));
    public static final TableFormat VFT_GRID_WIDTH = new TableFormat(1, 1, "<gridWidth><I><A=1><D=" + Cres.get().getString("containerWidth") + "><V=<L=1 " + Integer.MAX_VALUE + ">>");
    public static final TableFormat VFT_GRID_HEIGHT = new TableFormat(1, 1, "<gridHeight><I><A=1><D=" + Cres.get().getString("containerHeight") + "><V=<L=1 " + Integer.MAX_VALUE + ">>");
    public static final TableFormat VFT_GRIDX = new TableFormat(1, 1, "<gridx><I><F=C><D=" + Cres.get().getString("horizontalPosition") + "><V=<L=0 " + Integer.MAX_VALUE + ">>");
    public static final TableFormat VFT_GRIDY = new TableFormat(1, 1, "<gridy><I><F=C><D=" + Cres.get().getString("verticalPosition") + "><V=<L=0 " + Integer.MAX_VALUE + ">>");
    public static final VariableDefinition GRIDX_VD = new VariableDefinition("gridx", VFT_GRIDX, true, true, Cres.get().getString("horizontalPosition"), GROUP_CONSTRAINTS);
    public static final VariableDefinition GRIDY_VD = new VariableDefinition("gridy", VFT_GRIDY, true, true, Cres.get().getString("verticalPosition"), GROUP_CONSTRAINTS);
    public static final VariableDefinition GRID_WIDTH_VD = new VariableDefinition("gridWidth", VFT_GRID_WIDTH, true, true, Cres.get().getString("containerWidth"), GROUP_CONSTRAINTS);
    public static final VariableDefinition GRID_HEIGHT_VD = new VariableDefinition("gridHeight", VFT_GRID_HEIGHT, true, true, Cres.get().getString("containerHeight"), GROUP_CONSTRAINTS);
    protected final MutablePropertyChangeListener propertyListener;
    private final T component;
    private String defaultPropertyName;
    private VariableGetter customPropsGetter;
    private VariableSetter customPropsSetter;

    public WContext(T component) {
        super(component.getName());
        this.component = component;
        this.setValueCheckingEnabled(false);
        this.propertyListener = this.createPropertyListener();
        component.addPropertyChangeListener(this.propertyListener);
    }

    protected MutablePropertyChangeListener createPropertyListener() {
        return new ComponentPropertyChangeListener(this);
    }

    public T getComponent() {
        return this.component;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.getComponent() != null) {
            this.getComponent().setName(name);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.component.removePropertyChangeListener(this.propertyListener);
    }

    public void setContextName(String name) {
        super.setName(name);
    }

    public void addDefaultVariableDefinition(VariableDefinition vd) {
        this.addVariableDefinition(vd);
        this.defaultPropertyName = vd.getName();
    }

    protected String getPropertyNameByReference(Reference destination) {
        return destination.getEntity() != null ? destination.getEntity() : this.getDefaultPropertyName();
    }

    public String getDefaultPropertyName() {
        return this.defaultPropertyName;
    }

    public void setDefaultPropertyName(String defaultPropertyName) {
        this.defaultPropertyName = defaultPropertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReference(Reference destination, Object value, @Nullable Pinpoint pinpoint, @Nonnull UserSettings userSettings) throws ContextException {
        block8: {
            String property = this.getPropertyNameByReference(destination);
            try {
                T currentComponent = this.getComponent();
                Class propertyClass = this.getPropertyType((IComponent)currentComponent, property);
                if (destination.getRow() == null && destination.getProperty() == null && propertyClass != null && value != null && propertyClass.isAssignableFrom(value.getClass())) {
                    if (value instanceof DataTable) {
                        DataTable dataTableValue = ((DataTable)value).clone();
                        this.setProperty((IComponent)currentComponent, property, dataTableValue);
                    } else {
                        this.setProperty((IComponent)currentComponent, property, value);
                    }
                    break block8;
                }
                this.propertyListener.muteUpdateEvents(property);
                try {
                    this.setVariable(property, destination.getField(), destination.getRow(), value, pinpoint, userSettings);
                }
                finally {
                    this.propertyListener.allowUpdateEvents(property);
                }
            }
            catch (Exception ex) {
                throw new ContextException(ex);
            }
        }
    }

    public void setVariable(String variable, Object value) throws ContextException {
        this.setVariable(variable, null, null, value);
    }

    public void setVariable(String variable, String field, Integer row, Object value) throws ContextException {
        this.setVariable(variable, field, row, value, null, new UserSettings());
    }

    public void setVariable(String variable, String field, Integer row, Object value, @Nullable Pinpoint pinpoint, @Nonnull UserSettings userSettings) throws ContextException {
        this.validateDefinition(variable);
        RequestController request = this.createRequest(pinpoint);
        if (this.shouldReplaceWholeTable(variable, field, row, value)) {
            this.replaceWholeTable(variable, value, request);
            return;
        }
        if (this.shouldUpdateTableField(field, value)) {
            this.updateFieldValue(variable, field, row, value, userSettings, request);
            return;
        }
        this.updateSingleCell(variable, field, row, value, userSettings, request);
    }

    private void validateDefinition(String variable) throws ContextException {
        VariableDefinition vd = this.getVariableDefinition(variable);
        if (vd == null) {
            throw new ContextException(Cres.get().getString("conVarNotAvail") + variable);
        }
    }

    private RequestController createRequest(@Nullable Pinpoint pinpoint) {
        DefaultRequestController rc = new DefaultRequestController();
        rc.assignPinpoint(pinpoint);
        return rc;
    }

    private boolean shouldReplaceWholeTable(String variable, String field, Integer row, Object value) {
        VariableDefinition vd = this.getVariableDefinition(variable);
        return field == null && row == null && value instanceof DataTable && (vd.getFormat() == null || !vd.getFormat().isSingleCell() && !((DataTable)value).getFormat().isSingleCell());
    }

    private boolean shouldUpdateTableField(String field, Object value) {
        return field != null && value instanceof DataTable && !((DataTable)value).getFormat().isSingleCell();
    }

    private void replaceWholeTable(String variable, Object value, RequestController request) throws ContextException {
        DataTable newTable = (DataTable)value;
        DataTable oldTable = this.getVariable(variable);
        if (!Util.equals(newTable, oldTable)) {
            this.setVariable(variable, null, request, newTable);
        }
    }

    private void updateFieldValue(String variable, String field, Integer row, Object value, UserSettings userSettings, RequestController request) throws ContextException {
        DataTable table = this.getVariable(variable);
        int fieldIndex = this.getFieldIndexOrThrow(table, field);
        int recordIdx = row != null ? row : 0;
        this.updateCell(variable, table, fieldIndex, recordIdx, value, userSettings, request);
    }

    private void updateSingleCell(String variable, String field, Integer row, Object value, UserSettings userSettings, RequestController request) throws ContextException {
        DataTable table = this.getVariable(variable);
        Object prepared = this.unwrapSingleCell(value);
        int fieldIndex = field != null ? this.getFieldIndexOrThrow(table, field) : 0;
        int recordIdx = row != null ? row : 0;
        this.updateCell(variable, table, fieldIndex, recordIdx, prepared, userSettings, request);
    }

    private void updateCell(String variable, DataTable table, int fieldIndex, int recordIndex, Object value, UserSettings userSettings, RequestController request) throws ContextException {
        this.validateRecordIndex(table, recordIndex);
        FieldFormat ff = table.getRecord(recordIndex).getFormat(fieldIndex);
        Object newV = this.convertValueToField(ff, value, userSettings);
        Object oldV = table.getRecord(recordIndex).getValue(fieldIndex);
        if (!Util.equals(oldV, newV)) {
            DataTable clone = table.clone();
            clone.getRecord(recordIndex).setValue(fieldIndex, newV);
            this.setVariable(variable, null, request, clone);
        }
    }

    private int getFieldIndexOrThrow(DataTable table, String field) throws ContextException {
        int idx = table.getFormat().getFieldIndex(field);
        if (idx == -1) {
            throw new ContextException(Cres.get().getString("dtFieldNotAvail") + field);
        }
        return idx;
    }

    private void validateRecordIndex(DataTable t, int recIdx) throws ContextException {
        if (t.getRecordCount() <= recIdx) {
            throw new ContextException(Cres.get().getString("dtRecordNotAvail") + recIdx);
        }
    }

    private Object unwrapSingleCell(Object v) {
        return v instanceof DataTable ? ((DataTable)v).rec().getValue(0) : v;
    }

    private Object convertValueToField(FieldFormat ff, Object value, @Nonnull UserSettings userSettings) {
        if (value instanceof Date && ff.getType() == 'S') {
            ZoneId zoneId = userSettings.getZoneIdOrDefault();
            ZonedDateTime zonedDateTime = ((Date)value).toInstant().atZone(zoneId);
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
            if (userSettings.getDateTimePattern() != null) {
                formatter = DateTimeFormatter.ofPattern(userSettings.getDateTimePattern());
            }
            return zonedDateTime.format(formatter);
        }
        return DataTableConversion.convertValueToField(ff, value);
    }

    @Override
    protected boolean setVariableImpl(VariableDefinition def, CallerController caller, RequestController rc, DataTable value) throws ContextException {
        return this.setComponentVariable(def, value);
    }

    protected abstract boolean setComponentVariable(VariableDefinition var1, DataTable var2) throws ContextException;

    protected void setComponentVariableAsProperty(VariableDefinition vd, DataTable value, IComponent component) throws ContextException {
        try {
            Class propertyType = this.getPropertyType(component, vd.getName());
            Object val = List.class.isAssignableFrom(propertyType) ? DataTableConversion.beansFromTable(value, vd.getValueClass(), vd.getFormat(), true) : (Map.class.isAssignableFrom(propertyType) ? this.prepareMapValue(vd, value) : (AggreGateBean.class.isAssignableFrom(propertyType) ? DataTableConversion.createAggreGateBean(value, propertyType) : this.prepareValue(vd, value, component, propertyType)));
            this.setProperty(component, vd.getName(), val);
        }
        catch (InvocationTargetException ex) {
            throw new ContextException("Error setting property '" + vd.getName() + "': " + ex.getCause().getMessage(), ex);
        }
        catch (Exception ex) {
            throw new ContextException("Error setting property '" + vd.getName() + "': " + ex.getMessage(), ex);
        }
    }

    private Object prepareValue(VariableDefinition vd, DataTable value, IComponent component, Class propertyType) throws Exception {
        Object result;
        FormatConverter fc = DataTableConversion.getFormatConverter(propertyType);
        if (fc != null) {
            Object original = this.getProperty(component, vd.getName());
            result = fc.convertToBean(value, original);
        } else {
            result = DataTable.class.isAssignableFrom(propertyType) ? value.clone() : this.processValue(value.rec().getValue(0));
        }
        return result;
    }

    protected Object processValue(Object value) {
        return value;
    }

    private Map prepareMapValue(VariableDefinition vd, DataTable value) throws DataTableException {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (DataRecord rec : value) {
            Object mkey = DataTableConversion.convertValueFromField(rec.getValue(0));
            Object mvalue = rec.getFieldCount() > 2 ? DataTableConversion.beanFromRecord(rec, vd.getValueClass(), vd.getFormat(), true) : DataTableConversion.convertValueFromField(rec.getValue(1), vd.getValueClass());
            result.put(mkey, mvalue);
        }
        return result;
    }

    @Override
    protected DataTable getVariableImpl(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        DataTable dt = this.getComponentVariable(def);
        if (dt == null) {
            Log.WIDGETS.warn((Object)("Variable '" + def.getName() + "' value is null in component: " + this.getName()));
        }
        return dt;
    }

    protected abstract DataTable getComponentVariable(VariableDefinition var1);

    protected DataTable getComponentVariableAsProperty(VariableDefinition vd, IComponent component) {
        String name = vd.getName();
        DataTable result = null;
        try {
            Class propertyType = this.getPropertyType(component, name);
            Object value = this.getProperty(component, name);
            FormatConverter fc = DataTableConversion.getFormatConverter(propertyType);
            if (fc != null) {
                value = fc.convertToTable(value, vd.getFormat());
            }
            if (value != null) {
                if (value instanceof AggreGateBean) {
                    result = ((AggreGateBean)value).toDataTable();
                } else if (value instanceof List) {
                    result = this.prepareTableFromList(vd, (List)value);
                } else if (value instanceof Map) {
                    result = this.prepareTableFromMap(vd, (Map)value);
                } else if (value instanceof DataTable) {
                    result = ((DataTable)value).clone();
                }
            }
            if (result == null) {
                result = vd.getFormat() != null ? new SimpleDataTable(vd.getFormat(), value) : new SimpleDataTable();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error getting property '" + name + "': " + ex.getMessage(), ex);
        }
        result.makeImmutable();
        return result;
    }

    protected Object getProperty(IComponent component, String name) throws Exception {
        return PropertyUtils.getProperty((Object)component, (String)name);
    }

    protected Class getPropertyType(IComponent component, String name) throws Exception {
        return PropertyUtils.getPropertyType((Object)component, (String)name);
    }

    protected void setProperty(IComponent component, String name, Object value) throws Exception {
        PropertyUtils.setProperty((Object)component, (String)name, (Object)value);
    }

    private DataTable prepareTableFromMap(VariableDefinition vd, Map map) throws DataTableException {
        SimpleDataTable res = new SimpleDataTable(vd.getFormat());
        FieldFormat keyFormat = res.getFormat(0);
        if (res.getFieldCount() > 2) {
            LinkedHashSet<String> skipFields = new LinkedHashSet<String>(Arrays.asList(keyFormat.getName()));
            for (Object key : map.keySet()) {
                DataRecord rec = DataTableConversion.beanToRecord(map.get(key), res.getFormat(), true, false, skipFields);
                rec.setValue(0, DataTableConversion.convertValueToField(keyFormat, key));
                res.addRecord(rec);
            }
        } else {
            FieldFormat valueFormat = res.getFormat(1);
            for (Object key : map.keySet()) {
                res.addRecord(DataTableConversion.convertValueToField(keyFormat, key), DataTableConversion.convertValueToField(valueFormat, map.get(key), vd.getValueClass()));
            }
        }
        return res;
    }

    private DataTable prepareTableFromList(VariableDefinition vd, List list) throws DataTableException {
        FormatConverter valueClassFC = DataTableConversion.getFormatConverter(vd.getValueClass());
        if (valueClassFC != null) {
            SimpleDataTable table = new SimpleDataTable(vd.getFormat());
            for (Object bean : list) {
                DataRecord rec = ((DataTable)valueClassFC.convertToTable(bean)).rec();
                try {
                    table.addRecord(rec);
                }
                catch (Exception ex) {
                    DataRecord nr = table.addRecord();
                    DataTableReplication.copyRecord(rec, nr, true, true);
                }
            }
            return table;
        }
        return DataTableConversion.beansToTable(list, vd.getFormat(), true);
    }

    protected abstract void createVariableDefinitions();

    public abstract void componentPropertyChanged(PropertyChangeEvent var1);

    public abstract boolean canFireUpdates(String var1);

    protected VariableGetter getCustomPropsGetter() {
        if (this.customPropsGetter == null) {
            this.customPropsGetter = (context, variableDef, caller, request) -> {
                DataTable customProperty = this.getComponent().getCustomProperty(variableDef.getName());
                if (customProperty == null) {
                    return variableDef.getDefaultValue();
                }
                return customProperty;
            };
        }
        return this.customPropsGetter;
    }

    protected VariableSetter getCustomPropsSetter() {
        if (this.customPropsSetter == null) {
            this.customPropsSetter = (context, variableDef, caller, request, value) -> {
                this.getComponent().setCustomProperty(variableDef.getName(), value);
                return true;
            };
        }
        return this.customPropsSetter;
    }

    public void addCustomPropertyVD(String name, String description, String varHelp, TableFormat format, boolean initCustomProperty) {
        this.addCustomPropertyVDToGroup(name, description, varHelp, format, initCustomProperty, WidgetConstants.GROUP_CUSTOM_PROPERTIES);
    }

    public void recreateCustomProperties(DataTable properties) {
        if (this.getVariableDefinition("customProperties") == null || properties == null) {
            return;
        }
        for (VariableDefinition def : this.getVariableDefinitions()) {
            if (!WidgetConstants.GROUP_CUSTOM_PROPERTIES.equals(def.getGroup())) continue;
            this.removeVariableDefinition(def.getName());
        }
        for (DataRecord rec : properties) {
            String vHelp;
            String vName = rec.getString("name");
            DataTable value = rec.getDataTable("format");
            String vDescription = rec.getString("description");
            if (vDescription == null || vDescription.isEmpty()) {
                vDescription = value.getRecordCount() > 0 ? value.getFormat(0).getDescription() : Util.nameToDescription(vName);
            }
            if ((vHelp = rec.getString("help")) != null && vHelp.isEmpty()) {
                vHelp = null;
            }
            this.addCustomPropertyVD(vName, vDescription, vHelp, value.getFormat(), false);
        }
    }

    public void recreateCustomProperties() {
        if (this.getVariableDefinition("customProperties") == null) {
            return;
        }
        try {
            this.recreateCustomProperties(this.getVariable("customProperties"));
        }
        catch (ContextException e) {
            Log.GUIBUILDER.error((Object)("Failed to recreate custom properties of '" + this.getName() + "' component: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void addCustomPropertyVDToGroup(String name, String description, String varHelp, TableFormat format, boolean initCustomProperty, String group) {
        if (this.getVariableDefinition(name) == null) {
            if (initCustomProperty) {
                this.getComponent().setOrCreateCustomProperty(name, new SimpleDataTable(format, true), description, varHelp);
            }
            VariableDefinition vd = new VariableDefinition(name, format, true, true, description, group);
            vd.setGetter(this.getCustomPropsGetter());
            vd.setSetter(this.getCustomPropsSetter());
            vd.setHelp(varHelp);
            this.addVariableDefinition(vd);
        }
    }
}

