/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.context;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.widget.Res;
import com.tibbo.aggregate.common.widget.WGridConstraints;
import com.tibbo.aggregate.common.widget.WidgetTemplate;
import com.tibbo.aggregate.common.widget.component.WContainer;
import com.tibbo.aggregate.common.widget.context.ContainerContextLayoutHelper;
import com.tibbo.aggregate.common.widget.context.ContextAbsoluteLayoutHelper;
import com.tibbo.aggregate.common.widget.context.ContextGridLayoutHelper;
import com.tibbo.aggregate.common.widget.context.WAbstractContext;
import com.tibbo.aggregate.common.widget.context.WComponentContext;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class WContainerContext<C extends WComponentContext, U extends WContainer>
extends WAbstractContext<C, U> {
    public static final int CONTAINER_DEFAULT_ABSOLUTE_WIDTH = 100;
    public static final int CONTAINER_DEFAULT_ABSOLUTE_HEIGHT = 60;
    public static final int SC_NONE = 0;
    public static final int SC_VERTICAL = 1;
    public static final int SC_HORIZONTAL = 2;
    public static final int SC_BOTH = 3;
    public static ContainerContextLayoutHelper ABSOLUTE_LAYOUT_HELPER = new ContextAbsoluteLayoutHelper();
    public static ContainerContextLayoutHelper GRID_LAYOUT_HELPER = new ContextGridLayoutHelper();
    public static final String GROUP_GRID = ContextUtils.createGroup("default", Res.get().getString("wSnapping"));
    public static final String V_SCROLLING = "scrolling";
    public static final String V_USE_CUSTOM_SCROLL_BARS = "useCustomScrollBars";
    public static final String V_SCROLL_BAR_PROPERTIES = "scrollBarProperties";
    public static final String V_SCROLLING_AUTO = "scrollingAuto";
    public static final String V_LAYOUT = "layout";
    public static final String V_SHOW_GRID = "showGrid";
    public static final String V_SNAP_TO_GRID = "snapToGrid";
    public static final String V_GRID_STEP = "gridStep";
    public static final String V_SCALING = "scaling";
    public static final String V_MAXIMIZE_SCALABLE = "maximizeScalable";
    public static final String V_BUTTON_FOREGROUND = "buttonForeground";
    public static final String V_BUTTON_BACKGROUND = "buttonBackground";
    public static final String V_SLIDER_FOREGROUND = "sliderForeground";
    public static final String V_SLIDER_BACKGROUND = "sliderBackground";
    public static final String V_SCROLL_WIDTH = "scrollWidth";
    private static final TableFormat VFT_SHOW_GRID = new TableFormat(1, 1, "<showGrid><B><A=1>");
    private static final TableFormat VFT_SNAP_TO_GRID = new TableFormat(1, 1, "<snapToGrid><B>");
    private static final TableFormat VFT_GRID_STEP = new TableFormat(1, 1, FieldFormat.create("<gridStep><I><A=10><V=<L=1 2147483647>>").setExtendableSelectionValues(true).setSelectionValues(WContainerContext.gridStepSelectionValues()));
    public static final TableFormat VFT_SCROLLING_AUTO = new TableFormat(1, 1, "<scrollingAuto><B>");
    private static final TableFormat VFT_SCROLLING = new TableFormat(1, 1);
    private static final TableFormat VFT_USE_CUSTOM_SCROLL_BARS = new TableFormat(1, 1);
    public static final TableFormat VFT_SCROLL_BAR_PROPERTIES;
    private static final TableFormat VFT_LAYOUT;
    private static final TableFormat VFT_SCALING;
    private static final TableFormat VFT_MAXIMIZE_SCALABLE;
    public static final VariableDefinition SHOW_GRID_VD;
    public static final VariableDefinition SNAP_TO_GRID_VD;
    public static final VariableDefinition GRID_STEP_VD;
    public static final VariableDefinition SCROLLING_VD;
    public static final VariableDefinition LAYOUT_VD;
    private static final VariableDefinition SCROLLING_AUTO_VD;
    public static final VariableDefinition MAXIMIZE_SCALABLE_VD;
    public static final VariableDefinition SCALING_VD;
    private static final VariableDefinition VD_USE_CUSTOM_SCROLL_BARS;
    private static final VariableDefinition VD_SCROLL_BAR_PROPERTIES;

    private static Map<Object, String> gridStepSelectionValues() {
        return new HashMap<Object, String>(){
            {
                this.put(5, null);
                this.put(10, null);
            }
        };
    }

    public WContainerContext(U component, WidgetTemplate widget) {
        super(component, widget);
    }

    @Override
    protected void createVariableDefinitions() {
        this.addVariableDefinition(LAYOUT_VD);
        super.createVariableDefinitions();
        this.removeVariableDefinition("foreground");
        this.removeVariableDefinition("font");
        this.removeVariableDefinition("enabled");
        this.removeVariableDefinition("focusable");
        TableFormat fvf = VFT_FOCUSABLE.clone();
        fvf.getField("focusable").setDefault(false);
        this.addVariableDefinition(new VariableDefinition("focusable", fvf, true, true, Res.get().getString("wFocusable"), "default"));
        this.addVariableDefinition(SHOW_GRID_VD);
        this.addVariableDefinition(GRID_STEP_VD);
        this.addVariableDefinition(SNAP_TO_GRID_VD);
        this.addVariableDefinition(SCROLLING_VD);
        this.addVariableDefinition(SCROLLING_AUTO_VD);
        this.addVariableDefinition(VD_USE_CUSTOM_SCROLL_BARS);
        this.addVariableDefinition(VD_SCROLL_BAR_PROPERTIES);
        this.addVariableDefinition(SCALING_VD);
        this.addVariableDefinition(MAXIMIZE_SCALABLE_VD);
    }

    public static boolean isInterference(WGridConstraints childCs, WGridConstraints conCs) {
        int lastCol = conCs.getGridx() + conCs.getGridwidth() - 1;
        int lastRow = conCs.getGridy() + conCs.getGridheight() - 1;
        int lastCol2 = childCs.getGridx() + childCs.getGridwidth() - 1;
        int lastRow2 = childCs.getGridy() + childCs.getGridheight() - 1;
        boolean onx = childCs.getGridx() >= conCs.getGridx() && childCs.getGridx() <= lastCol;
        onx |= lastCol2 >= conCs.getGridx() && lastCol2 <= lastCol;
        boolean ony = childCs.getGridy() >= conCs.getGridy() && childCs.getGridy() <= lastRow;
        ony |= lastRow2 >= conCs.getGridy() && lastRow2 <= lastRow;
        return (onx |= childCs.getGridx() <= conCs.getGridx() && lastCol2 >= lastCol) && (ony |= childCs.getGridy() <= conCs.getGridy() && lastRow2 >= lastRow);
    }

    @Override
    public void editAcceptedChildVariables(WComponentContext child) {
        super.editAcceptedChildVariables(child);
        child.resetConstraintsVD(((WContainer)this.getComponent()).getLayout());
    }

    public static ContainerContextLayoutHelper getLayoutHelper(int layout) {
        if (layout == 2) {
            return ABSOLUTE_LAYOUT_HELPER;
        }
        return GRID_LAYOUT_HELPER;
    }

    static {
        VFT_USE_CUSTOM_SCROLL_BARS.addField(FieldFormat.create(V_USE_CUSTOM_SCROLL_BARS, 'B', Cres.get().getString("wUseCustomScrollBars")).setDefault(false));
        String ref = "scrollBarProperties$buttonForeground#enabled";
        String exp = "{useCustomScrollBars}";
        VFT_USE_CUSTOM_SCROLL_BARS.addBinding(ref, exp);
        ref = "scrollBarProperties$buttonBackground#enabled";
        exp = "{useCustomScrollBars}";
        VFT_USE_CUSTOM_SCROLL_BARS.addBinding(ref, exp);
        ref = "scrollBarProperties$sliderForeground#enabled";
        exp = "{useCustomScrollBars}";
        VFT_USE_CUSTOM_SCROLL_BARS.addBinding(ref, exp);
        ref = "scrollBarProperties$sliderBackground#enabled";
        exp = "{useCustomScrollBars}";
        VFT_USE_CUSTOM_SCROLL_BARS.addBinding(ref, exp);
        ref = "scrollBarProperties$scrollWidth#enabled";
        exp = "{useCustomScrollBars}";
        VFT_USE_CUSTOM_SCROLL_BARS.addBinding(ref, exp);
        VFT_SCROLL_BAR_PROPERTIES = new TableFormat(1, 1);
        VFT_SCROLL_BAR_PROPERTIES.addField(FieldFormat.create(V_BUTTON_FOREGROUND, 'C', Cres.get().getString("wButtonForeground")).setDefault(new Color(160, 160, 160)));
        VFT_SCROLL_BAR_PROPERTIES.addField(FieldFormat.create(V_BUTTON_BACKGROUND, 'C', Cres.get().getString("wButtonBackground")).setDefault(new Color(105, 105, 105)));
        VFT_SCROLL_BAR_PROPERTIES.addField(FieldFormat.create(V_SLIDER_FOREGROUND, 'C', Cres.get().getString("wSliderForeground")).setDefault(Color.GRAY));
        VFT_SCROLL_BAR_PROPERTIES.addField(FieldFormat.create(V_SLIDER_BACKGROUND, 'C', Cres.get().getString("wSliderBackground")).setDefault(Color.WHITE));
        VFT_SCROLL_BAR_PROPERTIES.addField(FieldFormat.create(V_SCROLL_WIDTH, 'I', Cres.get().getString("width")).setNullable(true).setDefault(null));
        VFT_LAYOUT = new TableFormat(1, 1);
        VFT_SCALING = new TableFormat(1, 1);
        FieldFormat ff = FieldFormat.create("<scrolling><I>");
        LinkedHashMap<Integer, String> scValues = new LinkedHashMap<Integer, String>();
        scValues.put(0, Cres.get().getString("none"));
        scValues.put(1, Cres.get().getString("wVertical"));
        scValues.put(2, Cres.get().getString("wHorizontal"));
        scValues.put(3, Cres.get().getString("wBothHorVert"));
        ff.setSelectionValues(scValues);
        VFT_SCROLLING.addField(ff);
        String ref2 = "scrollingAuto$scrollingAuto#enabled";
        String exp2 = "{scrolling} != 0";
        VFT_SCROLLING.addBinding(ref2, exp2);
        ff = FieldFormat.create("<layout><I><A=1>");
        LinkedHashMap<Integer, String> layouts = new LinkedHashMap<Integer, String>();
        layouts.put(1, Cres.get().getString("wGridLayout"));
        layouts.put(2, Cres.get().getString("wAbsoluteLayout"));
        ff.setSelectionValues(layouts);
        VFT_LAYOUT.addField(ff);
        Reference reference1 = new Reference();
        reference1.setEntity(V_SCROLLING);
        reference1.setField(V_SCROLLING);
        reference1.setProperty("enabled");
        Reference reference2 = new Reference();
        reference2.setEntity(V_SCROLLING_AUTO);
        reference2.setField(V_SCROLLING_AUTO);
        reference2.setProperty("enabled");
        Expression expression = new Expression("{layout}==1?true:false");
        VFT_LAYOUT.addBinding(new Binding(reference1, expression));
        VFT_LAYOUT.addBinding(new Binding(reference2, expression));
        ref2 = "showGrid$#enabled";
        exp2 = "{layout} == 2";
        VFT_LAYOUT.addBinding(ref2, exp2);
        ref2 = "gridStep$#enabled";
        VFT_LAYOUT.addBinding(ref2, exp2);
        ref2 = "snapToGrid$#enabled";
        VFT_LAYOUT.addBinding(ref2, exp2);
        ff = FieldFormat.create("<scaling><I><A=0>");
        ff.setSelectionValues(scValues);
        VFT_SCALING.addField(ff);
        ref2 = "scaling$#enabled";
        exp2 = "{layout} == 2";
        VFT_LAYOUT.addBinding(ref2, exp2);
        ref2 = "maximizeScalable$#enabled";
        exp2 = "{layout} == 2";
        VFT_LAYOUT.addBinding(ref2, exp2);
        VFT_MAXIMIZE_SCALABLE = new TableFormat(1, 1, "<maximizeScalable><B><A=0>");
        SHOW_GRID_VD = new VariableDefinition(V_SHOW_GRID, VFT_SHOW_GRID, true, true, Res.get().getString("wShowGrid"), GROUP_GRID);
        SNAP_TO_GRID_VD = new VariableDefinition(V_SNAP_TO_GRID, VFT_SNAP_TO_GRID, true, true, Res.get().getString("wSnapToGrid"), GROUP_GRID);
        GRID_STEP_VD = new VariableDefinition(V_GRID_STEP, VFT_GRID_STEP, true, true, Res.get().getString("wGridStep"), GROUP_GRID);
        SCROLLING_VD = new VariableDefinition(V_SCROLLING, VFT_SCROLLING, true, true, Cres.get().getString("wScrolling"), "default");
        LAYOUT_VD = new VariableDefinition(V_LAYOUT, VFT_LAYOUT, true, true, Cres.get().getString("wLayout"), "default");
        SCROLLING_AUTO_VD = new VariableDefinition(V_SCROLLING_AUTO, VFT_SCROLLING_AUTO, true, true, Cres.get().getString("wScrollingAuto"), "default");
        MAXIMIZE_SCALABLE_VD = new VariableDefinition(V_MAXIMIZE_SCALABLE, VFT_MAXIMIZE_SCALABLE, true, true, Cres.get().getString("wMaximizeScalable"), "default");
        SCALING_VD = new VariableDefinition(V_SCALING, VFT_SCALING, true, true, Cres.get().getString("wScaling"), "default");
        LAYOUT_VD.setIndex(400);
        VD_USE_CUSTOM_SCROLL_BARS = new VariableDefinition(V_USE_CUSTOM_SCROLL_BARS, VFT_USE_CUSTOM_SCROLL_BARS, true, true, Cres.get().getString("wUseCustomScrollBars"), "default");
        VD_SCROLL_BAR_PROPERTIES = new VariableDefinition(V_SCROLL_BAR_PROPERTIES, VFT_SCROLL_BAR_PROPERTIES, true, true, Cres.get().getString("wScrollBarProperties"), "default");
    }
}

