/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.context;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Bindings;
import com.tibbo.aggregate.common.binding.ExtendedBinding;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.EventData;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.context.VariableStatus;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.util.ThreadUtils;
import com.tibbo.aggregate.common.widget.Res;
import com.tibbo.aggregate.common.widget.WBindingUtils;
import com.tibbo.aggregate.common.widget.WConstraints;
import com.tibbo.aggregate.common.widget.WidgetApiUtils;
import com.tibbo.aggregate.common.widget.WidgetConstants;
import com.tibbo.aggregate.common.widget.WidgetTemplate;
import com.tibbo.aggregate.common.widget.component.WComponent;
import com.tibbo.aggregate.common.widget.component.WContainer;
import com.tibbo.aggregate.common.widget.context.WContainerContext;
import com.tibbo.aggregate.common.widget.context.WContext;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WComponentContext<C extends WComponentContext, T extends WComponent>
extends WContext<C, T> {
    public static final VariableStatus STATUS_BOUND = new VariableStatus("vs_bound", Res.get().getString("gbBound"));
    public static final VariableStatus STATUS_EMPTY = new VariableStatus(null, null);
    protected static String GROUP_CONSTRAINTS = ContextUtils.createGroup("default", Cres.get().getString("wConstraints"));
    protected static String GROUP_BINDINGS = ContextUtils.createGroup("default", Cres.get().getString("wBindings"));
    public static final String E_COMPONENT_ERROR = "componentError";
    public static final String EF_COMPONENT = "component";
    public static final String EF_ERROR = "error";
    public static final String EF_ERROR_STACK = "errorStack";
    public static final TableFormat VFT_WEIGHTY = new TableFormat(1, 1, "<weighty><F><A=1.0>");
    public static final TableFormat VFT_WEIGHTX = new TableFormat(1, 1, "<weightx><F><A=1.0>");
    public static final TableFormat VFT_FILL = new TableFormat(1, 1);
    public static final TableFormat VFT_INSETS_RIGHT;
    public static final TableFormat VFT_INSETS_LEFT;
    public static final TableFormat VFT_INSETS_BOTTOM;
    public static final TableFormat VFT_INSETS_TOP;
    public static final TableFormat VFT_HEIGHT;
    public static final TableFormat VFT_WIDTH;
    public static final TableFormat VFT_ZORDER;
    public static final TableFormat VFT_XCOORDINATE;
    public static final TableFormat VFT_YCOORDINATE;
    public static final TableFormat VFT_ANCHOR;
    public static final VariableDefinition WEIGHTY_VD;
    public static final VariableDefinition WEIGHTX_VD;
    public static final VariableDefinition ANCHOR_VD;
    public static final VariableDefinition FILL_VD;
    public static final VariableDefinition INSETS_RIGHT_VD;
    public static final VariableDefinition INSETS_LEFT_VD;
    public static final VariableDefinition INSETS_BOTTOM_VD;
    public static final VariableDefinition INSETS_TOP_VD;
    public static final VariableDefinition HEIGHT_VD;
    public static final VariableDefinition WIDTH_VD;
    public static final VariableDefinition ZORDER_VD;
    public static final VariableDefinition XCOORDINATE_VD;
    public static final VariableDefinition YCOORDINATE_VD;
    public static final TableFormat VFT_ALL_BINDINGS;
    public static VariableDefinition BINDINGS_VD;
    public static final TableFormat EFT_COMPONENT_ERROR;
    private final WidgetTemplate widget;

    public WComponentContext(T component, WidgetTemplate widget) {
        super(component);
        this.widget = widget;
        if (!((WComponent)component).getKey().equals("empty")) {
            this.createVariableDefinitions();
        }
    }

    @Override
    public T getComponent() {
        return (T)((WComponent)super.getComponent());
    }

    public String resizeTo(Rectangle resizeRectangle) throws ContextException {
        int width = resizeRectangle.width;
        int height = resizeRectangle.height;
        StringBuilder sb = new StringBuilder();
        if (((WComponent)this.getComponent()).getWidth() != width && this.getVariableDefinition("width") != null) {
            this.setVariable("width", (Object)width);
            sb.append("width");
        }
        if (((WComponent)this.getComponent()).getHeight() != height && this.getVariableDefinition("height") != null) {
            this.setVariable("height", (Object)height);
            sb.append(sb.length() == 0 ? "" : ", ").append("height");
        }
        return sb.toString();
    }

    public String resizeTo(Rectangle resizeRectangle, Boolean ignoreTurning) throws ContextException {
        return this.resizeTo(resizeRectangle);
    }

    @Override
    public void componentPropertyChanged(PropertyChangeEvent evt) {
        WContainer parentContainer = this.getParentContainer();
        if (parentContainer != null) {
            parentContainer.childPropertyChanged(evt);
        }
    }

    @Override
    public boolean canFireUpdates(String prop) {
        boolean canFireUpdates = this.getEventDefinition("updated") != null;
        VariableDefinition vd = this.getVariableDefinition(prop);
        return canFireUpdates && vd != null;
    }

    public WidgetTemplate getWidget() {
        return this.widget;
    }

    @Override
    public void setupMyself() throws ContextException {
        this.setPermissionCheckingEnabled(false);
        super.setupMyself();
    }

    public static void setNewConstraints(WConstraints cs, String prop, WConstraints oldcs, WComponent component, WidgetTemplate widget) throws ContextException {
        if (cs.equals(oldcs)) {
            return;
        }
        WContainer container = WidgetApiUtils.getComponentParent(component, widget);
        try {
            container.add(component, cs);
        }
        catch (Exception ex) {
            container.add(component, oldcs);
            throw new ContextException(ex);
        }
        component.firePropertyChange(prop, cs, oldcs);
    }

    @Override
    protected boolean setComponentVariable(VariableDefinition vd, DataTable value) throws ContextException {
        if (vd.getName().equals("bindings")) {
            try {
                ContextManager contextManager = this.getContextManager();
                List<ExtendedBinding> bs = Bindings.bindingsFromDataTable(value, contextManager != null ? contextManager.getExecutorService() : null);
                if (WBindingUtils.getBindingsRelatedToComponent(bs, ((WComponent)this.getComponent()).getName()).size() < bs.size()) {
                    throw new ContextException(MessageFormat.format(Res.get().getString("wErrorNotRelatedToComponent"), ((WComponent)this.getComponent()).getName()));
                }
                this.widget.changeBindingSet(WBindingUtils.getBindingsRelatedToComponent(this.widget.getBindings(), ((WComponent)this.getComponent()).getName()), bs, true);
            }
            catch (SyntaxErrorException ex) {
                throw new ContextException(MessageFormat.format(Res.get().getString("wPropertyUpdateFailure"), ((WComponent)this.getComponent()).getName(), "bindings", ((WComponent)this.getComponent()).getName()) + ":" + ex.getMessage(), ex);
            }
        } else {
            this.setComponentVariableAsProperty(vd, value, this.getComponent());
        }
        return true;
    }

    @Override
    protected DataTable getComponentVariable(VariableDefinition vd) {
        if (vd == null) {
            return null;
        }
        WContainer container = this.getParentContainer();
        if (container == null && WidgetConstants.CONSTRAINTS_PROPERTIES_LIST.contains(vd.getName())) {
            throw new IllegalStateException("Component '" + this.getName() + "' has no parent container. Property '" + vd.getName() + "' should not be requested before component get its parent container.");
        }
        if (vd.getName().equals("bindings")) {
            try {
                return Bindings.bindingsToDataTable(WBindingUtils.getBindingsRelatedToComponent(this.widget.getBindings(), ((WComponent)this.getComponent()).getName()));
            }
            catch (SyntaxErrorException ex1) {
                Log.WIDGETS.error((Object)("Failed to get property 'bindings of component: " + ((WComponent)this.getComponent()).getName()), (Throwable)ex1);
                return null;
            }
        }
        return this.getComponentVariableAsProperty(vd, this.getComponent());
    }

    public void removeAllVariableDefinitions() {
        for (VariableDefinition vd : this.getVariableDefinitions()) {
            this.removeVariableDefinition(vd.getName());
        }
    }

    @Override
    protected void createVariableDefinitions() {
        this.addVariableDefinition(WIDTH_VD);
        this.addVariableDefinition(HEIGHT_VD);
        if (!((WComponent)this.getComponent()).getKey().equals("root")) {
            WContainer parent = this.getParentContainer();
            int layout = 1;
            if (parent != null) {
                layout = parent.getLayout();
            }
            this.resetConstraintsVD(layout);
        }
        this.addVariableDefinition(BINDINGS_VD);
        this.addEventDefinition(new EventDefinition(E_COMPONENT_ERROR, EFT_COMPONENT_ERROR, Res.get().getString("wComponentError"), "default"));
    }

    public void resetConstraintsVD(int layout) {
        for (VariableDefinition vd : this.getVariableDefinitions()) {
            if (!WidgetConstants.CONSTRAINTS_PROPERTIES_LIST.contains(vd.getName())) continue;
            this.removeVariableDefinition(vd.getName());
        }
        WContainerContext.getLayoutHelper(layout).createConstraintsVariables(this, this.widget);
    }

    private static Map<Integer, String> createAnchorSelectionValues() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(10, WidgetConstants.ANCHOR_CENTER_TITLE);
        map.put(11, WidgetConstants.ANCHOR_NORTH_TITLE);
        map.put(13, WidgetConstants.ANCHOR_EAST_TITLE);
        map.put(15, WidgetConstants.ANCHOR_SOUTH_TITLE);
        map.put(17, WidgetConstants.ANCHOR_WEST_TITLE);
        map.put(18, WidgetConstants.ANCHOR_NORTHWEST_TITLE);
        map.put(12, WidgetConstants.ANCHOR_NORTHEAST_TITLE);
        map.put(14, WidgetConstants.ANCHOR_SOUTHEAST_TITLE);
        map.put(16, WidgetConstants.ANCHOR_SOUTHWEST_TITLE);
        return map;
    }

    private static Map<Object, String> createFillSelectionValues() {
        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
        map.put(0, Cres.get().getString("none"));
        map.put(3, Cres.get().getString("wVertical"));
        map.put(2, Cres.get().getString("wHorizontal"));
        map.put(1, Cres.get().getString("wBothHorVert"));
        return map;
    }

    public static DataTable getSingleFieldDT(VariableDefinition vd, String field, Object value) {
        SimpleDataTable dt = new SimpleDataTable(vd.getFormat());
        DataRecord dr = dt.addRecord();
        Object converted = DataTableConversion.convertValueToField(dr.getFormat(field), value);
        dr.setValue(field, converted);
        return dt;
    }

    public DataTable getVariableDefaultValue(VariableDefinition vd) {
        return new SimpleDataTable(vd.getFormat());
    }

    public WContainer getParentContainer() {
        return WidgetApiUtils.getComponentParent((WComponent)this.getComponent(), this.getWidget());
    }

    public void editAcceptedChildVariables(WComponentContext child) {
    }

    public boolean shouldInformRendererAboutChange(PropertyChangeEvent event, List<WComponentContext> childContexts) {
        VariableDefinition vd = this.getVariableDefinition(event.getPropertyName());
        return vd != null && !"system".equals(vd.getGroup());
    }

    public void fireExceptionEvent(String message, Exception exception) {
        Log.WIDGETS.warn((Object)message, (Throwable)exception);
        DataRecord data = new DataRecord(EFT_COMPONENT_ERROR);
        data.setValue(EF_COMPONENT, (Object)this.getName());
        if (!StringUtils.isEmpty(message)) {
            data.setValue(EF_ERROR, (Object)message);
        }
        if (exception != null) {
            data.setValue(EF_ERROR_STACK, (Object)ThreadUtils.createStackTraceTable(exception.getStackTrace()));
        }
        this.fireEvent(E_COMPONENT_ERROR, data.wrap());
    }

    public boolean saveHiddenVariables() {
        return false;
    }

    @Override
    protected void fireVariableAdded(VariableDefinition def) {
        EventData ed = this.getEventData("variableAdded");
        if (ed != null && ed.hasListeners()) {
            this.fireEvent(ed.getDefinition().getName(), new SimpleDataTable(this.varDefToDataRecord(def, null)));
        }
    }

    @Override
    protected void fireFunctionAdded(FunctionDefinition def) {
        EventData ed = this.getEventData("functionAdded");
        if (ed != null && ed.hasListeners()) {
            this.fireEvent(ed.getDefinition().getName(), new SimpleDataTable(this.funcDefToDataRecord(def, null)));
        }
    }

    @Override
    protected void fireEventAdded(EventDefinition def) {
        EventData ed = this.getEventData("eventAdded");
        if (ed != null && ed.hasListeners()) {
            this.fireEvent(ed.getDefinition().getName(), new SimpleDataTable(this.evtDefToDataRecord(def, null)));
        }
    }

    static {
        FieldFormat ff = FieldFormat.create("<fill><I>");
        ff.setSelectionValues(WComponentContext.createFillSelectionValues());
        VFT_FILL.addField(ff);
        VFT_INSETS_RIGHT = new TableFormat(1, 1, "<insetsRight><I><V=<L=0 2147483647>>");
        VFT_INSETS_LEFT = new TableFormat(1, 1, "<insetsLeft><I><V=<L=0 2147483647>>");
        VFT_INSETS_BOTTOM = new TableFormat(1, 1, "<insetsBottom><I><V=<L=0 2147483647>>");
        VFT_INSETS_TOP = new TableFormat(1, 1, "<insetsTop><I><V=<L=0 2147483647>>");
        VFT_HEIGHT = new TableFormat(1, 1, "<height><I> <V=<L=0 2147483647>>");
        VFT_WIDTH = new TableFormat(1, 1, "<width><I> <V=<L=0 2147483647>>");
        VFT_ZORDER = new TableFormat(1, 1, "<zOrder><I><D=" + Cres.get().getString("wZOrder") + "><V=<L=0 " + Integer.MAX_VALUE + ">>");
        VFT_XCOORDINATE = new TableFormat(1, 1, "<xCoordinate><I><D=" + Cres.get().getString("wXCoordinate") + "><V=<L=0 " + Integer.MAX_VALUE + ">>");
        VFT_YCOORDINATE = new TableFormat(1, 1, "<yCoordinate><I><D=" + Cres.get().getString("wYCoordinate") + "><V=<L=0 " + Integer.MAX_VALUE + ">>");
        VFT_ANCHOR = new TableFormat(1, 1);
        WEIGHTY_VD = new VariableDefinition("weighty", VFT_WEIGHTY, true, true, Cres.get().getString("wWeightY"), GROUP_CONSTRAINTS);
        WEIGHTX_VD = new VariableDefinition("weightx", VFT_WEIGHTX, true, true, Cres.get().getString("wWeightX"), GROUP_CONSTRAINTS);
        FILL_VD = new VariableDefinition("fill", VFT_FILL, true, true, Cres.get().getString("fill"), GROUP_CONSTRAINTS);
        INSETS_RIGHT_VD = new VariableDefinition("insetsRight", VFT_INSETS_RIGHT, true, true, Cres.get().getString("wRightMargin"), GROUP_CONSTRAINTS);
        INSETS_LEFT_VD = new VariableDefinition("insetsLeft", VFT_INSETS_LEFT, true, true, Cres.get().getString("wLeftMargin"), GROUP_CONSTRAINTS);
        INSETS_BOTTOM_VD = new VariableDefinition("insetsBottom", VFT_INSETS_BOTTOM, true, true, Cres.get().getString("wBottomMargin"), GROUP_CONSTRAINTS);
        INSETS_TOP_VD = new VariableDefinition("insetsTop", VFT_INSETS_TOP, true, true, Cres.get().getString("wTopMargin"), GROUP_CONSTRAINTS);
        HEIGHT_VD = new VariableDefinition("height", VFT_HEIGHT, true, true, Cres.get().getString("height"), GROUP_CONSTRAINTS);
        WIDTH_VD = new VariableDefinition("width", VFT_WIDTH, true, true, Cres.get().getString("width"), GROUP_CONSTRAINTS);
        ZORDER_VD = new VariableDefinition("zOrder", VFT_ZORDER, true, true, Cres.get().getString("wZOrder"), GROUP_CONSTRAINTS);
        XCOORDINATE_VD = new VariableDefinition("xCoordinate", VFT_XCOORDINATE, true, true, Cres.get().getString("wXCoordinate"), GROUP_CONSTRAINTS);
        YCOORDINATE_VD = new VariableDefinition("yCoordinate", VFT_YCOORDINATE, true, true, Cres.get().getString("wYCoordinate"), GROUP_CONSTRAINTS);
        ff = FieldFormat.create("<anchor><I>");
        ff.setSelectionValues(WComponentContext.createAnchorSelectionValues());
        VFT_ANCHOR.addField(ff);
        VFT_ALL_BINDINGS = Bindings.FORMAT.clone();
        VFT_ALL_BINDINGS.setReorderable(true);
        GRIDX_VD.setIndex(200);
        GRIDY_VD.setIndex(200);
        GRID_WIDTH_VD.setIndex(200);
        GRID_HEIGHT_VD.setIndex(200);
        ANCHOR_VD = new VariableDefinition("anchor", VFT_ANCHOR, true, true, Cres.get().getString("wAnchor"), GROUP_CONSTRAINTS);
        ANCHOR_VD.setIndex(200);
        INSETS_TOP_VD.setIndex(200);
        INSETS_LEFT_VD.setIndex(200);
        INSETS_BOTTOM_VD.setIndex(200);
        INSETS_RIGHT_VD.setIndex(200);
        FILL_VD.setIndex(200);
        WEIGHTX_VD.setIndex(200);
        WEIGHTY_VD.setIndex(200);
        XCOORDINATE_VD.setIndex(200);
        YCOORDINATE_VD.setIndex(200);
        ZORDER_VD.setIndex(200);
        BINDINGS_VD = new VariableDefinition("bindings", Bindings.FORMAT, true, true, Cres.get().getString("bindings"), GROUP_BINDINGS);
        BINDINGS_VD.setHelpId("ls_widgets_bindings");
        EFT_COMPONENT_ERROR = new TableFormat(1, 1);
        EFT_COMPONENT_ERROR.addField(FieldFormat.create("<component><S><D=" + Cres.get().getString(EF_COMPONENT) + ">"));
        EFT_COMPONENT_ERROR.addField(FieldFormat.create("<error><S><D=" + Cres.get().getString(EF_ERROR) + "><E=" + "textarea" + ">"));
        EFT_COMPONENT_ERROR.addField(FieldFormat.create("<errorStack><T><D=" + Cres.get().getString("stack") + ">"));
    }
}

