/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.context;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.AbstractContext;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.DefaultContextManager;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.RequestController;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.context.VariableSetter;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.validator.TableKeyFieldsValidator;
import com.tibbo.aggregate.common.widget.Res;
import com.tibbo.aggregate.common.widget.WidgetConstants;
import com.tibbo.aggregate.common.widget.WidgetTemplate;
import com.tibbo.aggregate.common.widget.chart.converters.FCBorder;
import com.tibbo.aggregate.common.widget.chart.converters.FCFont;
import com.tibbo.aggregate.common.widget.component.WAbstractComponent;
import com.tibbo.aggregate.common.widget.context.WComponentContext;
import com.tibbo.aggregate.common.widget.engine.ComponentPinPoint;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.CaretEvent;

public class WAbstractContext<C extends WComponentContext, T extends WAbstractComponent>
extends WComponentContext<C, T> {
    public static final int ONSCREEN_KEYBOARD_NONE = 0;
    public static final int ONSCREEN_KEYBOARD_SINGLE_CLICK = 1;
    public static final int ONSCREEN_KEYBOARD_DOUBLE_CLICK = 2;
    public static final String V_ONSCREEN_KEYBOARD = "onscreenKeyboard";
    public static final String E_HIDDEN = "hidden";
    public static final String E_SHOWN = "shown";
    public static final String E_RESIZED = "resized";
    public static final String E_MOVED = "moved";
    public static final String E_MOUSE_CLICKED = "mouseClicked";
    public static final String E_MOUSE_DOUBLE_CLICKED = "mouseDoubleClicked";
    public static final String E_MOUSE_PRESSED = "mousePressed";
    public static final String E_MOUSE_RELEASED = "mouseReleased";
    public static final String E_MOUSE_ENTERED = "mouseEntered";
    public static final String E_MOUSE_EXITED = "mouseExited";
    public static final String E_MOUSE_OPEN_CHANGE = "mouseOpenChange";
    public static final String E_MOUSE_MOVED = "mouseMoved";
    public static final String E_MOUSE_WHEEL_MOVED = "mouseWheelMoved";
    public static final String E_KEY_TYPED = "keyTyped";
    public static final String E_KEY_PRESSED = "keyPressed";
    public static final String E_KEY_RELEASED = "keyReleased";
    public static final String E_FOCUS_GAINED = "focusGained";
    public static final String E_FOCUS_LOST = "focusLost";
    public static final String E_CARET_UPDATE = "caretUpdate";
    public static final String E_MENU_POPUP = "menuPopup";
    public static final String EF_ID = "id";
    public static final String EF_X_ON_SCREEN = "xOnScreen";
    public static final String EF_Y_ON_SCREEN = "yOnScreen";
    public static final String EF_ALT_DOWN = "altDown";
    public static final String EF_ALT_GRAPH_DOWN = "altGraphDown";
    public static final String EF_BUTTON = "button";
    public static final String EF_CLICK_COUNT = "clickCount";
    public static final String EF_CONTROL_DOWN = "controlDown";
    public static final String EF_META_DOWN = "metaDown";
    public static final String EF_MODIFIERS = "modifiers";
    public static final String EF_MODIFIERS_EX = "modifiersEx";
    public static final String EF_POPUP_TRIGGER = "popupTrigger";
    public static final String EF_SHIFT_DOWN = "shiftDown";
    public static final String EF_WHEN = "when";
    public static final String EF_X = "x";
    public static final String EF_Y = "y";
    public static final String EF_WIDTH = "width";
    public static final String EF_HEIGHT = "height";
    public static final String EF_SCROLL_AMOUNT = "scrollAmount";
    public static final String EF_SCROLL_TYPE = "scrollType";
    public static final String EF_WHEEL_ROTATION = "wheelRotation";
    public static final String EF_ACTION_KEY = "actionKey";
    public static final String EF_KEY_CHAR = "keyChar";
    public static final String EF_KEY_CODE = "keyCode";
    public static final String EF_KEY_LOCATION = "keyLocation";
    public static final String EF_TEMPORARY = "temporary";
    public static final String EF_DOT = "dot";
    public static final String EF_MARK = "mark";
    public static final String EF_ITEM = "item";
    public static final String EF_CONTEXT = "context";
    public static final TableFormat VFT_ENABLED = new TableFormat(1, 1, "<enabled><B><A=1>");
    public static final TableFormat VFT_VISIBLE = new TableFormat(1, 1, "<visible><B><A=1>");
    public static final TableFormat VFT_FOREGROUND = new TableFormat(1, 1, "<foreground><C><D=" + Cres.get().getString("wForeground") + "><A=" + Color.BLACK.getRGB() + ">");
    public static final TableFormat VFT_BACKGROUND = new TableFormat(1, 1, "<background><C><D=" + Cres.get().getString("background") + "><A=" + Color.WHITE.getRGB() + "><F=N>");
    public static final TableFormat VFT_TOOLTIP = new TableFormat(1, 1, "<toolTipText><S><F=N>");
    public static final TableFormat VFT_OPAQUE = new TableFormat(1, 1, "<opaque><B>");
    public static final TableFormat VFT_CURSOR;
    public static final TableFormat VFT_ONSCREEN_KEYBOARD;
    public static final TableFormat VFT_FOCUSABLE;
    public static final TableFormat EFT_EVENT;
    public static final TableFormat EFT_COMPONENT;
    public static final TableFormat EFT_RESIZED;
    public static final TableFormat EFT_INPUT_EVENT;
    public static final TableFormat EFT_MOUSE;
    public static final TableFormat EFT_MOUSE_WHEEL;
    public static final TableFormat EFT_KEY;
    public static final TableFormat EFT_FOCUS;
    public static final TableFormat EFT_CARET_UPDATE;
    public static final TableFormat EFT_MENU_POPUP;
    public static VariableDefinition ENABLED_VD;
    public static VariableDefinition VISIBLE_VD;
    public static VariableDefinition FOREGROUND_VD;
    public static VariableDefinition BACKGROUND_VD;
    public static VariableDefinition BORDER_VD;
    public static VariableDefinition OPAQUE_VD;
    public static VariableDefinition TOOLTIP_VD;
    public static VariableDefinition CURSOR_VD;
    public static VariableDefinition FONT_VD;
    public static VariableDefinition POPUP_MENU_VD;
    public static final VariableDefinition ONSCREEN_KEYBOARD_VD;
    public static VariableDefinition FOCUSABLE_VD;
    public static VariableDefinition PIN_POINTS_VD;
    public static final EventDefinition ED_HIDDEN;
    public static final EventDefinition ED_SHOWN;
    public static final EventDefinition ED_MOVED;
    public static final EventDefinition ED_RESIZED;
    public static final EventDefinition ED_MOUSE_CLICKED;
    public static final EventDefinition ED_MOUSE_DOUBLE_CLICKED;
    public static final EventDefinition ED_MOUSE_PRESSED;
    public static final EventDefinition ED_MOUSE_RELEASED;
    public static final EventDefinition ED_MOUSE_ENTERED;
    public static final EventDefinition ED_MOUSE_EXITED;
    public static final EventDefinition ED_MOUSE_MOVED;
    public static final EventDefinition ED_MOUSE_WHEEL_MOVED;
    public static final EventDefinition ED_KEY_PRESSED;
    public static final EventDefinition ED_KEY_RELEASED;
    public static final EventDefinition ED_KEY_TYPED;
    public static final EventDefinition ED_FOCUS_GAINED;
    public static final EventDefinition ED_FOCUS_LOST;
    public static final EventDefinition ED_CARET_UPDATE;
    public static final EventDefinition ED_MENU_POPUP;

    private static Map<Integer, String> cursorSelectionValues() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(0, Cres.get().getString("wCursorDefault"));
        m.put(1, Cres.get().getString("wCursorCrosshair"));
        m.put(2, Cres.get().getString("wCursorText"));
        m.put(3, Cres.get().getString("wCursorWait"));
        m.put(4, Cres.get().getString("wCursorSWResize"));
        m.put(5, Cres.get().getString("wCursorSEResize"));
        m.put(6, Cres.get().getString("wCursorNWResize"));
        m.put(7, Cres.get().getString("wCursorNEResize"));
        m.put(8, Cres.get().getString("wCursorNResize"));
        m.put(9, Cres.get().getString("wCursorSResize"));
        m.put(10, Cres.get().getString("wCursorWResize"));
        m.put(11, Cres.get().getString("wCursorEResize"));
        m.put(12, Cres.get().getString("wCursorHand"));
        m.put(13, Cres.get().getString("wCursorMove"));
        return m;
    }

    public static TableFormat createMapFormat(FieldFormat keyFormat, FieldFormat valueFormat) {
        TableFormat res = new TableFormat(true).addField(keyFormat).addField(valueFormat);
        res.addTableValidator(new TableKeyFieldsValidator());
        return res;
    }

    public static TableFormat createPlainMapFormat(FieldFormat keyFieldFormat, TableFormat beanTableFormat) {
        TableFormat result = new TableFormat(true).addField(keyFieldFormat).addFields(beanTableFormat.getFields().toArray(new FieldFormat[beanTableFormat.getFieldCount()]));
        result.addTableValidator(new TableKeyFieldsValidator());
        return result;
    }

    public static TableFormat createListFormat(TableFormat rf) {
        TableFormat res = rf.clone();
        res.resetAllowedRecords();
        res.setReorderable(true);
        return res;
    }

    private static Map<Integer, String> onscreenKeyboardSelectionValues() {
        return new HashMap<Integer, String>(){
            {
                this.put(0, Res.get().getString("wNone"));
                this.put(1, Res.get().getString("wSingleClick"));
                this.put(2, Res.get().getString("wDoubleClick"));
            }
        };
    }

    public WAbstractContext(T component, WidgetTemplate widget) {
        super(component, widget);
        this.recreateCustomProperties();
    }

    @Override
    public void setupMyself() throws ContextException {
        super.setupMyself();
        this.enableVariableStatuses(true);
        this.addEventDefinition(ED_HIDDEN);
        this.addEventDefinition(ED_SHOWN);
        this.addEventDefinition(ED_MOVED);
        this.addEventDefinition(ED_RESIZED);
        this.addEventDefinition(ED_MOUSE_CLICKED);
        this.addEventDefinition(ED_MOUSE_DOUBLE_CLICKED);
        this.addEventDefinition(ED_MOUSE_PRESSED);
        this.addEventDefinition(ED_MOUSE_RELEASED);
        this.addEventDefinition(ED_MOUSE_ENTERED);
        this.addEventDefinition(ED_MOUSE_EXITED);
        this.addEventDefinition(ED_MOUSE_MOVED);
        this.addEventDefinition(ED_MOUSE_WHEEL_MOVED);
        this.addEventDefinition(ED_KEY_PRESSED);
        this.addEventDefinition(ED_KEY_RELEASED);
        this.addEventDefinition(ED_KEY_TYPED);
        this.addEventDefinition(ED_FOCUS_GAINED);
        this.addEventDefinition(ED_FOCUS_LOST);
        this.addEventDefinition(ED_MENU_POPUP);
    }

    @Override
    protected void createVariableDefinitions() {
        super.createVariableDefinitions();
        this.addVariableDefinition(ENABLED_VD);
        this.addVariableDefinition(VISIBLE_VD);
        this.addVariableDefinition(FOREGROUND_VD);
        this.addVariableDefinition(OPAQUE_VD);
        this.addVariableDefinition(BACKGROUND_VD);
        this.addVariableDefinition(BORDER_VD);
        this.addVariableDefinition(FONT_VD);
        this.addVariableDefinition(CURSOR_VD);
        this.addVariableDefinition(TOOLTIP_VD);
        this.addVariableDefinition(FOCUSABLE_VD);
        this.addVariableDefinition(PIN_POINTS_VD);
        POPUP_MENU_VD.setSetter(new VariableSetter(){

            @Override
            public boolean set(Context con, VariableDefinition def, CallerController caller, RequestController request, DataTable value) throws ContextException {
                AbstractContext emptyContext = new AbstractContext(((WComponentContext)WAbstractContext.this.getRoot()).getName()){};
                DefaultContextManager<1> contextManager = new DefaultContextManager<1>(emptyContext, false);
                CallerController cc = contextManager.getCallerController();
                List<VariableDefinition> definitionsList = emptyContext.getVariableDefinitions(cc);
                ArrayList<String> reservedNames = new ArrayList<String>();
                for (VariableDefinition definition : definitionsList) {
                    reservedNames.add(definition.getName());
                }
                for (DataRecord rec : value) {
                    if (!reservedNames.contains(rec.getString("name"))) continue;
                    throw new ContextException(MessageFormat.format(Res.get().getString("wReservedNameError"), rec.getString("name"), reservedNames));
                }
                if (con instanceof WComponentContext) {
                    ((WAbstractComponent)((WComponentContext)con).getComponent()).setPopupMenu(value);
                } else {
                    ((WAbstractComponent)WAbstractContext.this.getComponent()).setPopupMenu(value);
                }
                return true;
            }
        });
        this.addVariableDefinition(POPUP_MENU_VD);
        this.addVariableDefinition(new VariableDefinition("customProperties", WidgetConstants.CUSTOM_PROPERTIES_FORMAT, true, true, Res.get().getString("wCustomProperties"), "system"));
    }

    @Override
    public DataTable getVariableDefaultValue(VariableDefinition vd) {
        if (vd.getName().equals("border")) {
            return FCBorder.createDefaultTable();
        }
        return super.getVariableDefaultValue(vd);
    }

    @Override
    public void componentPropertyChanged(PropertyChangeEvent evt) {
        super.componentPropertyChanged(evt);
        if (evt.getPropertyName().equals("customProperties")) {
            this.recreateCustomProperties();
        }
    }

    public VariableDefinition addComponentPropertyDefinition(String name, String description, TableFormat format) {
        return this.addComponentPropertyDefinition(name, description, format, null, false);
    }

    public VariableDefinition addComponentPropertyDefinition(String name, String description, TableFormat format, Class valueClass) {
        return this.addComponentPropertyDefinition(name, description, format, valueClass, false);
    }

    public VariableDefinition addComponentPropertyDefinition(String name, String description, TableFormat format, Class valueClass, boolean defaultProperty) {
        return this.addComponentPropertyDefinition(name, description, format, valueClass, defaultProperty, "default");
    }

    public VariableDefinition addComponentPropertyDefinition(String name, String description, TableFormat format, Class valueClass, boolean defaultProperty, String group) {
        VariableDefinition vd = new VariableDefinition(name, format, true, true, description, group);
        if (valueClass != null) {
            vd.setValueClass(valueClass);
        }
        if (defaultProperty) {
            this.addDefaultVariableDefinition(vd);
        } else {
            this.addVariableDefinition(vd);
        }
        return vd;
    }

    public Event fireHidden(ComponentEvent e) {
        return this.fireComponentEvent(E_HIDDEN, e);
    }

    public Event fireShown(ComponentEvent e) {
        return this.fireComponentEvent(E_SHOWN, e);
    }

    public Event fireResized(ComponentEvent e) {
        return this.fireComponentEvent(E_RESIZED, e);
    }

    public Event fireMoved(ComponentEvent e) {
        return this.fireComponentEvent(E_MOVED, e);
    }

    public Event fireMouseClicked(MouseEvent e) {
        return this.fireMouseEvent(E_MOUSE_CLICKED, e);
    }

    public Event fireMouseDoubleClicked(MouseEvent e) {
        return this.fireMouseEvent(E_MOUSE_DOUBLE_CLICKED, e);
    }

    public Event fireMousePressed(MouseEvent e) {
        return this.fireMouseEvent(E_MOUSE_PRESSED, e);
    }

    public Event fireMouseReleased(MouseEvent e) {
        return this.fireMouseEvent(E_MOUSE_RELEASED, e);
    }

    public Event fireMouseEntered(MouseEvent e) {
        return this.fireMouseEvent(E_MOUSE_ENTERED, e);
    }

    public Event fireMouseExited(MouseEvent e) {
        return this.fireMouseEvent(E_MOUSE_EXITED, e);
    }

    public Event fireMouseMoved(MouseEvent e) {
        return this.fireMouseEvent(E_MOUSE_MOVED, e);
    }

    public Event fireWheelMoved(MouseWheelEvent e) {
        return this.fireMouseWheelEvent(E_MOUSE_WHEEL_MOVED, e);
    }

    public Event fireKeyTyped(KeyEvent e) {
        return this.fireKeyEvent(E_KEY_TYPED, e);
    }

    public Event fireKeyPressed(KeyEvent e) {
        return this.fireKeyEvent(E_KEY_PRESSED, e);
    }

    public Event fireKeyReleased(KeyEvent e) {
        return this.fireKeyEvent(E_KEY_RELEASED, e);
    }

    public Event fireFocusGained(FocusEvent e) {
        DataRecord eventData = this.createAWTEventData(e, EFT_FOCUS);
        this.fillFocusEvent(e, eventData);
        return this.fireEvent(E_FOCUS_GAINED, eventData.wrap());
    }

    public Event fireCaretUpdate(CaretEvent e) {
        boolean caretUpdateIsDefined;
        Event result = null;
        boolean bl = caretUpdateIsDefined = this.getEventDefinition(E_CARET_UPDATE) != null;
        if (caretUpdateIsDefined) {
            DataRecord eventData = new DataRecord(EFT_CARET_UPDATE);
            eventData.setValue(EF_DOT, (Object)e.getDot());
            eventData.setValue(EF_MARK, (Object)e.getMark());
            result = this.fireEvent(E_CARET_UPDATE, eventData.wrap());
        }
        return result;
    }

    public Event fireFocusLost(FocusEvent e) {
        DataRecord eventData = this.createAWTEventData(e, EFT_FOCUS);
        this.fillFocusEvent(e, eventData);
        return this.fireEvent(E_FOCUS_LOST, eventData.wrap());
    }

    protected DataRecord createAWTEventData(AWTEvent e, TableFormat eventDataFormat) {
        DataRecord eventData = new DataRecord(eventDataFormat);
        eventData.setValue(EF_ID, (Object)e.getID());
        return eventData;
    }

    protected void fillMouseEvent(MouseEvent e, DataRecord eventData) {
        this.fillInputEvent(e, eventData);
        eventData.setValue(EF_X, (Object)e.getX());
        eventData.setValue(EF_Y, (Object)e.getY());
        eventData.setValue(EF_X_ON_SCREEN, (Object)e.getXOnScreen());
        eventData.setValue(EF_Y_ON_SCREEN, (Object)e.getYOnScreen());
        eventData.setValue(EF_BUTTON, (Object)e.getButton());
        eventData.setValue(EF_CLICK_COUNT, (Object)e.getClickCount());
        eventData.setValue(EF_MODIFIERS_EX, (Object)e.getModifiersEx());
        eventData.setValue(EF_POPUP_TRIGGER, (Object)e.isPopupTrigger());
    }

    protected void fillInputEvent(InputEvent e, DataRecord eventData) {
        eventData.setValue(EF_WHEN, (Object)new Date(e.getWhen()));
        eventData.setValue(EF_MODIFIERS, (Object)e.getModifiers());
        eventData.setValue(EF_ALT_DOWN, (Object)e.isAltDown());
        eventData.setValue(EF_ALT_GRAPH_DOWN, (Object)e.isAltGraphDown());
        eventData.setValue(EF_CONTROL_DOWN, (Object)e.isControlDown());
        eventData.setValue(EF_SHIFT_DOWN, (Object)e.isShiftDown());
        eventData.setValue(EF_META_DOWN, (Object)e.isMetaDown());
    }

    private void fillFocusEvent(FocusEvent e, DataRecord eventData) {
        eventData.setValue(EF_TEMPORARY, (Object)e.isTemporary());
    }

    private Event fireComponentEvent(String name, ComponentEvent e) {
        DataRecord eventData = this.createAWTEventData(e, EFT_RESIZED);
        if (e.getSource() instanceof Component) {
            Rectangle bounds = ((Component)e.getSource()).getBounds();
            eventData.setValue(EF_WIDTH, (Object)bounds.width);
            eventData.setValue(EF_HEIGHT, (Object)bounds.height);
        }
        return this.fireEvent(name, eventData.wrap());
    }

    protected Event fireMouseEvent(String name, MouseEvent e) {
        DataRecord eventData = this.createAWTEventData(e, EFT_MOUSE);
        this.fillMouseEvent(e, eventData);
        return this.fireEvent(name, eventData.wrap());
    }

    private Event fireMouseWheelEvent(String name, MouseWheelEvent e) {
        DataRecord eventData = this.createAWTEventData(e, EFT_MOUSE_WHEEL);
        this.fillMouseEvent(e, eventData);
        eventData.setValue(EF_SCROLL_AMOUNT, (Object)e.getScrollAmount());
        eventData.setValue(EF_SCROLL_TYPE, (Object)e.getScrollType());
        eventData.setValue(EF_WHEEL_ROTATION, (Object)e.getWheelRotation());
        return this.fireEvent(name, eventData.wrap());
    }

    private Event fireKeyEvent(String name, KeyEvent e) {
        DataRecord eventData = this.createAWTEventData(e, EFT_KEY);
        this.fillInputEvent(e, eventData);
        eventData.setValue(EF_ACTION_KEY, (Object)e.isActionKey());
        eventData.setValue(EF_KEY_CHAR, (Object)String.valueOf(e.getKeyChar()));
        eventData.setValue(EF_KEY_CODE, (Object)e.getKeyCode());
        eventData.setValue(EF_KEY_LOCATION, (Object)e.getKeyLocation());
        return this.fireEvent(name, eventData.wrap());
    }

    public Point getComponentPosition() {
        Point coordinate;
        try {
            DataTable xCoordinate = this.getVariable("xCoordinate");
            DataTable yCoordinate = this.getVariable("yCoordinate");
            coordinate = new Point(xCoordinate.rec().getInt("xCoordinate"), yCoordinate.rec().getInt("yCoordinate"));
        }
        catch (ContextException ex) {
            coordinate = new Point();
        }
        return coordinate;
    }

    static {
        String ref = "background$background#enabled";
        String exp = "{opaque}";
        VFT_OPAQUE.addBinding(ref, exp);
        VFT_CURSOR = new TableFormat(1, 1, FieldFormat.create("<cursor><I><F=N>").setSelectionValues(WAbstractContext.cursorSelectionValues()));
        VFT_ONSCREEN_KEYBOARD = new TableFormat(1, 1, FieldFormat.create("<onscreenKeyboard><I>").setSelectionValues(WAbstractContext.onscreenKeyboardSelectionValues()));
        VFT_FOCUSABLE = new TableFormat(1, 1, "<focusable><B><A=true>");
        EFT_EVENT = new TableFormat(1, 1);
        EFT_EVENT.addField('I', EF_ID, Cres.get().getString(EF_ID));
        EFT_COMPONENT = EFT_EVENT.clone();
        EFT_RESIZED = EFT_COMPONENT.clone();
        EFT_RESIZED.addField('I', EF_WIDTH, Cres.get().getString(EF_WIDTH));
        EFT_RESIZED.addField('I', EF_HEIGHT, Cres.get().getString(EF_HEIGHT));
        EFT_INPUT_EVENT = EFT_EVENT.clone();
        EFT_INPUT_EVENT.addField('D', EF_WHEN, Res.get().getString("wWhen"));
        EFT_INPUT_EVENT.addField('I', EF_MODIFIERS, Res.get().getString("wModifiers"));
        EFT_INPUT_EVENT.addField('B', EF_ALT_DOWN, Res.get().getString("wAltDown"));
        EFT_INPUT_EVENT.addField('B', EF_ALT_GRAPH_DOWN, Res.get().getString("wAltGraphDown"));
        EFT_INPUT_EVENT.addField('B', EF_CONTROL_DOWN, Res.get().getString("wControlDown"));
        EFT_INPUT_EVENT.addField('B', EF_SHIFT_DOWN, Res.get().getString("wShiftDown"));
        EFT_INPUT_EVENT.addField('B', EF_META_DOWN, Res.get().getString("wMetaDown"));
        EFT_MOUSE = EFT_INPUT_EVENT.clone();
        EFT_MOUSE.addField('I', EF_X, Res.get().getString("wX"));
        EFT_MOUSE.addField('I', EF_Y, Res.get().getString("wY"));
        EFT_MOUSE.addField('I', EF_X_ON_SCREEN, Res.get().getString("wXOnScreen"));
        EFT_MOUSE.addField('I', EF_Y_ON_SCREEN, Res.get().getString("wYOnScreen"));
        EFT_MOUSE.addField('I', EF_BUTTON, Res.get().getString("wButton"));
        EFT_MOUSE.addField('I', EF_CLICK_COUNT, Res.get().getString("wClickCount"));
        EFT_MOUSE.addField('I', EF_MODIFIERS_EX, Res.get().getString("wModifiersEx"));
        EFT_MOUSE.addField('B', EF_POPUP_TRIGGER, Res.get().getString("wPopupTrigger"));
        EFT_MOUSE_WHEEL = EFT_MOUSE.clone();
        EFT_MOUSE_WHEEL.addField('I', EF_SCROLL_AMOUNT, Res.get().getString("wScrollAmount"));
        EFT_MOUSE_WHEEL.addField('I', EF_SCROLL_TYPE, Res.get().getString("wScrollType"));
        EFT_MOUSE_WHEEL.addField('I', EF_WHEEL_ROTATION, Res.get().getString("wWheelRotation"));
        EFT_KEY = EFT_INPUT_EVENT.clone();
        EFT_KEY.addField('B', EF_ACTION_KEY, Res.get().getString("wActionKey"));
        EFT_KEY.addField('S', EF_KEY_CHAR, Res.get().getString("wKeyChar"));
        EFT_KEY.addField('I', EF_KEY_CODE, Res.get().getString("wKeyCode"));
        EFT_KEY.addField('I', EF_KEY_LOCATION, Res.get().getString("wKeyLocation"));
        EFT_FOCUS = EFT_EVENT.clone();
        EFT_FOCUS.addField('B', EF_TEMPORARY, Res.get().getString("wTemporary"));
        EFT_CARET_UPDATE = new TableFormat(1, 1);
        EFT_CARET_UPDATE.addField('I', EF_DOT, Res.get().getString("wDot"));
        EFT_CARET_UPDATE.addField('I', EF_MARK, Res.get().getString("wMark"));
        EFT_MENU_POPUP = new TableFormat(1, 1);
        EFT_MENU_POPUP.addField('S', EF_ITEM, Res.get().getString("wItem"));
        EFT_MENU_POPUP.addField('S', EF_CONTEXT, Res.get().getString("wContext"), (Object)"", true);
        ENABLED_VD = new VariableDefinition("enabled", VFT_ENABLED, true, true, Cres.get().getString("enabled"), "default");
        VISIBLE_VD = new VariableDefinition("visible", VFT_VISIBLE, true, true, Cres.get().getString("visible"), "default");
        FOREGROUND_VD = new VariableDefinition("foreground", VFT_FOREGROUND, true, true, Cres.get().getString("wForeground"), "default");
        BACKGROUND_VD = new VariableDefinition("background", VFT_BACKGROUND, true, true, Cres.get().getString("background"), "default");
        BORDER_VD = new VariableDefinition("border", FCBorder.VFT_BORDER, true, true, Cres.get().getString("border"), "default");
        OPAQUE_VD = new VariableDefinition("opaque", VFT_OPAQUE, true, true, Cres.get().getString("opaque"), "default");
        TOOLTIP_VD = new VariableDefinition("toolTipText", VFT_TOOLTIP, true, true, Cres.get().getString("tooltip"), "default");
        CURSOR_VD = new VariableDefinition("cursor", VFT_CURSOR, true, true, Cres.get().getString("cursor"), "default");
        FONT_VD = new VariableDefinition("font", FCFont.FORMAT, true, true, Cres.get().getString("font"), "default");
        POPUP_MENU_VD = new VariableDefinition("popupMenu", WAbstractComponent.VFT_POPUP_MENU, true, true, Res.get().getString("wPopupMenu"), "default");
        ONSCREEN_KEYBOARD_VD = new VariableDefinition(V_ONSCREEN_KEYBOARD, VFT_ONSCREEN_KEYBOARD, true, true, Res.get().getString("wOnscreenKeyboard"), "default");
        FOCUSABLE_VD = new VariableDefinition("focusable", VFT_FOCUSABLE, true, true, Res.get().getString("wFocusable"), "default");
        PIN_POINTS_VD = new VariableDefinition("pinPoints", WAbstractContext.createListFormat(ComponentPinPoint.VFT_PIN), true, true, Res.get().getString("wPinPoints"), "default");
        BORDER_VD.setHelpId("ls_widgets_border");
        FONT_VD.setHelpId("ls_widgets_font");
        PIN_POINTS_VD.setValueClass(ComponentPinPoint.class);
        ED_HIDDEN = new EventDefinition(E_HIDDEN, EFT_COMPONENT, Res.get().getString("wHidden"));
        ED_SHOWN = new EventDefinition(E_SHOWN, EFT_COMPONENT, Res.get().getString("wShown"));
        ED_MOVED = new EventDefinition(E_MOVED, EFT_COMPONENT, Res.get().getString("wMoved"));
        ED_RESIZED = new EventDefinition(E_RESIZED, EFT_RESIZED, Res.get().getString("wResized"));
        ED_MOUSE_CLICKED = new EventDefinition(E_MOUSE_CLICKED, EFT_MOUSE, Res.get().getString("wMouseClicked"));
        ED_MOUSE_DOUBLE_CLICKED = new EventDefinition(E_MOUSE_DOUBLE_CLICKED, EFT_MOUSE, Res.get().getString("wMouseDoubleClicked"));
        ED_MOUSE_PRESSED = new EventDefinition(E_MOUSE_PRESSED, EFT_MOUSE, Res.get().getString("wMousePressed"));
        ED_MOUSE_RELEASED = new EventDefinition(E_MOUSE_RELEASED, EFT_MOUSE, Res.get().getString("wMouseReleased"));
        ED_MOUSE_ENTERED = new EventDefinition(E_MOUSE_ENTERED, EFT_MOUSE, Res.get().getString("wMouseEntered"));
        ED_MOUSE_EXITED = new EventDefinition(E_MOUSE_EXITED, EFT_MOUSE, Res.get().getString("wMouseExited"));
        ED_MOUSE_MOVED = new EventDefinition(E_MOUSE_MOVED, EFT_MOUSE, Res.get().getString("wMouseMoved"));
        ED_MOUSE_WHEEL_MOVED = new EventDefinition(E_MOUSE_WHEEL_MOVED, EFT_MOUSE_WHEEL, Res.get().getString("wMouseWheelMoved"));
        ED_KEY_PRESSED = new EventDefinition(E_KEY_PRESSED, EFT_KEY, Res.get().getString("wKeyPressed"));
        ED_KEY_RELEASED = new EventDefinition(E_KEY_RELEASED, EFT_KEY, Res.get().getString("wKeyReleased"));
        ED_KEY_TYPED = new EventDefinition(E_KEY_TYPED, EFT_KEY, Res.get().getString("wKeyTyped"));
        ED_FOCUS_GAINED = new EventDefinition(E_FOCUS_GAINED, EFT_FOCUS, Res.get().getString("wFocusGained"));
        ED_FOCUS_LOST = new EventDefinition(E_FOCUS_LOST, EFT_FOCUS, Res.get().getString("wFocusLost"));
        ED_CARET_UPDATE = new EventDefinition(E_CARET_UPDATE, EFT_CARET_UPDATE, Res.get().getString("wCaretUpdate"));
        ED_MENU_POPUP = new EventDefinition(E_MENU_POPUP, EFT_MENU_POPUP, Res.get().getString("wMenuPopup"));
    }
}

