/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.context;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.event.FireEventRequestController;
import com.tibbo.aggregate.common.widget.context.MutablePropertyChangeListener;
import com.tibbo.aggregate.common.widget.context.WContext;
import java.beans.PropertyChangeEvent;

public abstract class AbstractComponentPropertyChangeListener
implements MutablePropertyChangeListener {
    private final WContext wContext;

    public AbstractComponentPropertyChangeListener(WContext wContext) {
        this.wContext = wContext;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.wContext.componentPropertyChanged(evt);
        String prop = evt.getPropertyName();
        if (this.wContext.canFireUpdates(prop) && this.allowToFireUpdateEvent(prop)) {
            try {
                this.wContext.fireEvent("updated", new FireEventRequestController(this.wContext), prop, this.wContext.getVariable(prop));
            }
            catch (ContextException ex) {
                Log.WIDGETS.error((Object)("Failed to fire event 'updated' for property '" + prop + "' in component: " + this.wContext.getComponent().getName() + " :" + ex.getMessage()), (Throwable)ex);
            }
        }
        if (evt.getPropertyName().equals("name")) {
            this.wContext.setContextName((String)evt.getNewValue());
        }
    }

    protected abstract boolean allowToFireUpdateEvent(String var1);
}

