/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.component;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.widget.WConstraints;
import com.tibbo.aggregate.common.widget.WGridConstraints;
import com.tibbo.aggregate.common.widget.WidgetApiUtils;
import com.tibbo.aggregate.common.widget.WidgetConstants;
import com.tibbo.aggregate.common.widget.component.WAbstractComponent;
import com.tibbo.aggregate.common.widget.component.WComponent;
import com.tibbo.aggregate.common.widget.context.WContainerContext;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class WContainer
extends WAbstractComponent {
    private int scrolling;
    private boolean scrollingAuto;
    private int layout = 1;
    private boolean showGrid = true;
    private boolean snapToGrid = false;
    private int gridStep = 10;
    private int scaling;
    private boolean maximizeScalable = false;
    private boolean useCustomScrollBars = false;
    private DataTable scrollBarProperties;
    public static final String V_CHILDREN = "children";
    private Map<WComponent, WConstraints> children = new LinkedHashMap<WComponent, WConstraints>();

    public WContainer(String name, String key, Class contextType, String description, String iconId, String helpId) {
        super(name, key, contextType, description, iconId, helpId);
        this.setBackground(Color.WHITE);
        this.setFocusable(false);
        this.scrollBarProperties = new DataRecord(WContainerContext.VFT_SCROLL_BAR_PROPERTIES).wrap();
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        int oldLayout = this.layout;
        this.layout = layout;
        this.firePropertyChange("layout", oldLayout, layout);
    }

    public int getScrolling() {
        return this.scrolling;
    }

    public void setScrolling(int scrolling) {
        int oldScrolling = this.scrolling;
        this.scrolling = scrolling;
        this.firePropertyChange("scrolling", oldScrolling, scrolling);
    }

    public int getScaling() {
        return this.scaling;
    }

    public void setScaling(int scaling) {
        int oldScaling = this.scaling;
        this.scaling = scaling;
        this.firePropertyChange("scaling", oldScaling, scaling);
    }

    public boolean getMaximizeScalable() {
        return this.maximizeScalable;
    }

    public void setMaximizeScalable(boolean maximizeScalable) {
        boolean oldMaximizeScalable = this.maximizeScalable;
        this.maximizeScalable = maximizeScalable;
        this.firePropertyChange("maximize", oldMaximizeScalable, maximizeScalable);
    }

    public boolean isScrollingAuto() {
        return this.scrollingAuto;
    }

    public void setScrollingAuto(boolean scrollingAuto) {
        boolean oldSA = this.scrollingAuto;
        this.scrollingAuto = scrollingAuto;
        this.firePropertyChange("scrollingAuto", oldSA, scrollingAuto);
    }

    public List<WComponent> getChildren() {
        return new LinkedList<WComponent>(this.children.keySet());
    }

    public void add(WComponent aComponent) {
        this.add(aComponent, WidgetApiUtils.getComponentDefaultConstraints(this, this.getLayout()));
    }

    public void add(WComponent component, WConstraints cs) {
        this.setComponentConstrains(component, cs);
        component.setParent(this);
        this.fireCollectionElementAddedEvent(V_CHILDREN, component, 0);
    }

    public void setComponentConstrains(WComponent component, WConstraints cs) {
        if (component == null) {
            throw new IllegalArgumentException("Null values are not supported");
        }
        this.children.put(component, cs);
    }

    public void remove(WComponent component) {
        if (component == null) {
            return;
        }
        WConstraints cs = this.children.get(component);
        WConstraints removedComponent = this.children.remove(component);
        if (removedComponent != null) {
            component.setParent(null);
            this.fireCollectionElementRemovedEvent(V_CHILDREN, new ComponentWithConstraints(component, cs), 0);
        }
    }

    public WConstraints getChildConstraints(WComponent child) {
        return this.children.get(child);
    }

    public void childPropertyChanged(PropertyChangeEvent evt) {
    }

    public void prepareToAcceptChild(WComponent component) {
    }

    public WComponent getChildWithGridPosition(int x, int y) {
        for (Map.Entry<WComponent, WConstraints> entry : this.children.entrySet()) {
            WGridConstraints gridConstraints;
            WConstraints componentConstraints = entry.getValue();
            if (!(componentConstraints instanceof WGridConstraints) || (gridConstraints = (WGridConstraints)componentConstraints).getGridx() != x || gridConstraints.getGridy() != y) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.firePropertyChange("showGrid", this.showGrid, this.showGrid);
    }

    public int getGridStep() {
        return this.gridStep;
    }

    public void setGridStep(int gridStep) {
        this.gridStep = gridStep;
        this.firePropertyChange("gridStep", this.gridStep, this.gridStep);
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
        this.firePropertyChange("snapToGrid", this.snapToGrid, this.snapToGrid);
    }

    @Override
    public WidgetConstants.ComponentGroup getComponentGroup() {
        return WidgetConstants.ComponentGroup.CONTAINER;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public WGridConstraints getDefaultGridConstrains() {
        WGridConstraints result = new WGridConstraints(0, 0, true, true);
        result.setGridheight(1);
        result.setGridwidth(1);
        result.setWeightx(1.0);
        result.setWeighty(1.0);
        return result;
    }

    @Override
    public WContainer clone() {
        WContainer clone = (WContainer)super.clone();
        clone.children = new LinkedHashMap<WComponent, WConstraints>();
        for (WComponent child : this.children.keySet()) {
            WConstraints ncs = null;
            WConstraints constraints = this.children.get(child);
            if (constraints != null) {
                ncs = constraints.clone();
            }
            WComponent childClone = child.clone();
            childClone.setParent(clone);
            clone.children.put(childClone, ncs);
        }
        return clone;
    }

    public boolean isAcceptedChildComponentKey(String key) {
        return true;
    }

    public boolean isUseCustomScrollBars() {
        return this.useCustomScrollBars;
    }

    public void setUseCustomScrollBars(boolean useCustomScrollBars) {
        boolean old = this.useCustomScrollBars;
        this.useCustomScrollBars = useCustomScrollBars;
        this.firePropertyChange("useCustomScrollBars", old, this.useCustomScrollBars);
    }

    public DataTable getScrollBarProperties() {
        return this.scrollBarProperties;
    }

    public void setScrollBarProperties(DataTable scrollBarProperties) {
        DataTable old = this.scrollBarProperties;
        this.scrollBarProperties = scrollBarProperties;
        this.firePropertyChange("scrollBarProperties", old, this.scrollBarProperties);
    }

    public static class ComponentWithConstraints {
        private WComponent component;
        private WConstraints constraints;

        public WComponent getComponent() {
            return this.component;
        }

        public void setComponent(WComponent component) {
            this.component = component;
        }

        public WConstraints getConstraints() {
            return this.constraints;
        }

        public void setConstraints(WConstraints constraints) {
            this.constraints = constraints;
        }

        public ComponentWithConstraints(WComponent component, WConstraints constraints) {
            this.component = component;
            this.constraints = constraints;
        }
    }
}

