/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.component;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.util.PublicCloneable;
import com.tibbo.aggregate.common.util.Util;
import com.tibbo.aggregate.common.widget.WGridConstraints;
import com.tibbo.aggregate.common.widget.WPropertyChangeSupport;
import com.tibbo.aggregate.common.widget.WidgetConstants;
import com.tibbo.aggregate.common.widget.component.IComponent;
import com.tibbo.aggregate.common.widget.component.WContainer;
import java.awt.Point;
import java.beans.PropertyChangeListener;

public abstract class WComponent
implements Cloneable,
PublicCloneable,
IComponent {
    private String key;
    private final Class contextType;
    private WPropertyChangeSupport changeSupport;
    private int width;
    private int height;
    private String name;
    private final String description;
    private final String iconId;
    public static final String V_NAME = "name";
    public static final String V_HEIGHT = "height";
    public static final String V_WIDTH = "width";
    public static final String V_CUSTOM_PROPERTIES = "customProperties";
    private boolean headless = false;
    private final String helpId;
    private WContainer parent;
    private DataTable customProperties;

    public WComponent(String name, String key, Class contextType, String description, String iconId, String helpId) {
        this.name = name;
        this.key = key;
        this.contextType = contextType;
        this.description = description;
        this.iconId = iconId;
        this.helpId = helpId;
        this.customProperties = new SimpleDataTable(WidgetConstants.CUSTOM_PROPERTIES_FORMAT);
    }

    public abstract boolean shouldSkipPropertyEncoding(String var1);

    public String getDescription() {
        return this.description;
    }

    public String getIconId() {
        return this.iconId;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public Class getContextType() {
        return this.contextType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(V_NAME, oldName, name);
    }

    public WContainer getParent() {
        return this.parent;
    }

    public void setParent(WContainer parent) {
        this.parent = parent;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        WPropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null || Util.equals(oldValue, newValue)) {
            return;
        }
        changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void fireCollectionElementAddedEvent(String propertyName, Object addedValue, int addedIndex) {
        WPropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null) {
            return;
        }
        changeSupport.fireCollectionElementAddedEvent(propertyName, addedValue, addedIndex);
    }

    public void fireCollectionElementRemovedEvent(String propertyName, Object removedValue, int removedIndex) {
        WPropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null) {
            return;
        }
        changeSupport.fireCollectionElementRemovedEvent(propertyName, removedValue, removedIndex);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WPropertyChangeSupport(this);
        }
        for (PropertyChangeListener changeListener : this.changeSupport.getPropertyChangeListeners()) {
            if (!changeListener.equals(listener)) continue;
            return;
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        return "Widget Component: '" + this.name + "' (" + super.toString() + ")";
    }

    public void setWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Wrong value for width: " + Integer.toString(width));
        }
        int oldWidth = this.width;
        this.width = width;
        this.firePropertyChange(V_WIDTH, oldWidth, width);
    }

    public void setHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Wrong value for height: " + Integer.toString(height));
        }
        int oldHeight = this.height;
        this.height = height;
        this.firePropertyChange(V_HEIGHT, oldHeight, height);
    }

    public void setSize(Point size) {
        this.setWidth(size.x);
        this.setHeight(size.y);
    }

    public void setSizeFiringHeightChange(int w, int h) {
        this.width = w;
        this.setHeight(h);
    }

    public boolean isResizeProportionally() {
        return false;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    protected void setKey(String key) {
        this.key = key;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isDependentContainer() {
        return false;
    }

    public boolean isDependentContainerHolder() {
        return false;
    }

    public boolean isBasic() {
        return true;
    }

    @Override
    public WComponent clone() {
        try {
            WComponent clone = (WComponent)super.clone();
            clone.changeSupport = null;
            if (this.customProperties != null) {
                clone.customProperties = this.customProperties.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public void setHeadless(boolean v) {
        this.headless = v;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public String treeSortProperty() {
        return V_NAME;
    }

    public boolean greaterThan(WComponent other) {
        return other != null && this.getName().compareToIgnoreCase(other.getName()) > 0;
    }

    public WidgetConstants.ComponentGroup getComponentGroup() {
        return WidgetConstants.ComponentGroup.CONTENT;
    }

    public WGridConstraints getDefaultGridConstrains() {
        WGridConstraints result = new WGridConstraints();
        result.setFill(0);
        result.setGridx(0);
        result.setGridy(0);
        result.setGridheight(1);
        result.setGridwidth(1);
        result.setWeightx(1.0);
        result.setWeighty(1.0);
        return result;
    }

    @Override
    public Object getProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataTable getCustomProperty(String name) {
        DataRecord rec = this.customProperties.select(V_NAME, name);
        if (rec != null) {
            return rec.getDataTable("format").clone();
        }
        return null;
    }

    @Override
    public void setCustomProperty(String name, DataTable newDataTable) {
        DataRecord rec = this.customProperties.select(V_NAME, name);
        if (rec != null) {
            DataTable o = rec.getDataTable("format");
            rec.setValue("format", (Object)newDataTable);
            this.firePropertyChange(name, o, newDataTable);
        }
    }

    @Override
    public boolean hasCustomProperty(String name) {
        return this.getCustomProperties().select(V_NAME, name) != null;
    }

    @Override
    public void setOrCreateCustomProperty(String name, DataTable newDataTable, String description, String help) {
        DataRecord rec = this.customProperties.select(V_NAME, name);
        if (rec != null) {
            this.setCustomProperty(name, newDataTable);
        } else {
            if (description == null) {
                description = name;
            }
            this.customProperties.addRecord(name, newDataTable, description, help);
            this.firePropertyChange(name, null, newDataTable);
        }
    }

    @Override
    public DataTable removeCustomProperty(String name) {
        DataRecord rec = this.customProperties.select(V_NAME, name);
        if (rec != null) {
            this.customProperties.removeRecords(rec);
        }
        return rec.getDataTable("format");
    }

    @Override
    public DataTable getCustomProperties() {
        return this.customProperties;
    }

    @Override
    public void setCustomProperties(DataTable value) {
        DataTable old = this.customProperties;
        this.customProperties = value;
        this.firePropertyChange(V_CUSTOM_PROPERTIES, old, value);
    }
}

