/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.component;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.validator.TableKeyFieldsValidator;
import com.tibbo.aggregate.common.resource.ResourceManager;
import com.tibbo.aggregate.common.widget.chart.converters.FCBorder;
import com.tibbo.aggregate.common.widget.chart.converters.FCFont;
import com.tibbo.aggregate.common.widget.component.WComponent;
import com.tibbo.aggregate.common.widget.engine.ComponentPinPoint;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public abstract class WAbstractComponent
extends WComponent {
    public static final String V_FONT = "font";
    public static final String V_CURSOR = "cursor";
    public static final String V_BORDER = "border";
    public static final String V_OPAQUE = "opaque";
    public static final String V_BACKGROUND = "background";
    public static final String V_FOREGROUND = "foreground";
    public static final String V_TOOLTIP = "toolTipText";
    public static final String V_ENABLED = "enabled";
    public static final String V_VISIBLE = "visible";
    public static final String V_POPUP_MENU = "popupMenu";
    public static final String V_FOCUSABLE = "focusable";
    public static final String V_PIN_POINTS = "pinPoints";
    public static final String V_POPUP_MENU_NAME = "name";
    public static final String V_POPUP_MENU_DESCRIPTION = "description";
    public static final String V_POPUP_MENU_ICON = "icon";
    public static final String V_POPUP_MENU_CONDITION = "condition";
    public static final TableFormat VFT_POPUP_MENU = new TableFormat(true);
    private boolean enabled = true;
    private boolean visible = true;
    private String toolTipText;
    private Color foreground = Color.BLACK;
    private Color background = Color.WHITE;
    private boolean opaque;
    private Border border;
    private Font font;
    private Integer cursor;
    private DataTable popupMenu;
    private boolean focusable = true;
    private List<ComponentPinPoint> pinPoints;

    public WAbstractComponent(String name, String key, Class contextType, String description, String iconId, String helpId) {
        super(name, key, contextType, description, iconId, helpId);
        this.setBackground(Color.WHITE);
        this.setBorder(null);
        this.popupMenu = new SimpleDataTable(VFT_POPUP_MENU);
        this.pinPoints = new ArrayList<ComponentPinPoint>();
    }

    public WAbstractComponent(String name, String key, Class contextType, String description, String iconId, ImageIcon icon, String helpId) {
        this(name, key, contextType, description, iconId, helpId);
        ResourceManager.putIconToCache(iconId + "." + "png", icon);
    }

    @Override
    public WAbstractComponent clone() {
        WAbstractComponent clone = (WAbstractComponent)super.clone();
        if (this.border != null) {
            clone.border = new FCBorder().clone(this.border, true);
        }
        if (this.font != null) {
            clone.font = new FCFont().clone(this.font, true);
        }
        return clone;
    }

    @Override
    public boolean shouldSkipPropertyEncoding(String name) {
        return this.getCustomProperty(name) != null || name.equals("bindings");
    }

    public Color getBackground() {
        return this.background;
    }

    public Border getBorder() {
        return this.border;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public Font getFont() {
        return this.font;
    }

    public Integer getCursor() {
        return this.cursor;
    }

    public void setCursor(Integer cursor) {
        Integer o = this.cursor;
        this.cursor = cursor;
        this.firePropertyChange(V_CURSOR, o, cursor);
    }

    public void setToolTipText(String toolTipText) {
        String oldTT = this.toolTipText;
        this.toolTipText = toolTipText;
        this.firePropertyChange(V_TOOLTIP, oldTT, toolTipText);
    }

    public void setOpaque(boolean opaque) {
        boolean oldOpaque = this.opaque;
        this.opaque = opaque;
        this.firePropertyChange(V_OPAQUE, oldOpaque, opaque);
    }

    public void setForeground(Color foreground) {
        Color oldForeground = this.foreground;
        this.foreground = foreground;
        this.firePropertyChange(V_FOREGROUND, oldForeground, foreground);
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange(V_ENABLED, oldEnabled, enabled);
    }

    public void setBorder(Border border) {
        Border oldBorder = this.border;
        this.border = border;
        this.firePropertyChange(V_BORDER, oldBorder, border);
    }

    public void setBackground(Color background) {
        Color oldBackground = this.background;
        this.background = background;
        this.firePropertyChange(V_BACKGROUND, oldBackground, background);
    }

    public void setFont(Font font) {
        Font oldFont = this.font;
        this.font = font;
        this.firePropertyChange(V_FONT, oldFont, font);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.firePropertyChange(V_VISIBLE, oldVisible, visible);
    }

    public DataTable getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(DataTable popupMenu) {
        DataTable o = this.popupMenu;
        this.popupMenu = popupMenu;
        this.firePropertyChange(V_POPUP_MENU, o, popupMenu);
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean newValue) {
        boolean oldValue = this.focusable;
        this.focusable = newValue;
        this.firePropertyChange(V_FOCUSABLE, oldValue, newValue);
    }

    public List<ComponentPinPoint> getPinPoints() {
        return this.pinPoints;
    }

    public void setPinPoints(List<ComponentPinPoint> pinPoints) {
        List<ComponentPinPoint> o = this.pinPoints;
        this.pinPoints = pinPoints;
        this.firePropertyChange(V_PIN_POINTS, o, pinPoints);
    }

    public ComponentPinPoint getComponentPinPoint(String name) {
        for (ComponentPinPoint pin : this.getPinPoints()) {
            if (!pin.getName().equals(name)) continue;
            return pin;
        }
        return null;
    }

    static {
        VFT_POPUP_MENU.addField(FieldFormat.create(V_POPUP_MENU_NAME, 'S', Cres.get().getString(V_POPUP_MENU_NAME)).setKeyField(true));
        VFT_POPUP_MENU.addField(FieldFormat.create(V_POPUP_MENU_DESCRIPTION, 'S', Cres.get().getString(V_POPUP_MENU_DESCRIPTION)));
        VFT_POPUP_MENU.addField(FieldFormat.create(V_POPUP_MENU_ICON, 'A', Cres.get().getString(V_POPUP_MENU_ICON), null, true).setEditor("image"));
        FieldFormat<Object> ff = FieldFormat.create(V_POPUP_MENU_CONDITION, 'S', Cres.get().getString(V_POPUP_MENU_CONDITION), null, true).setEditor("expression");
        VFT_POPUP_MENU.addField(ff);
        VFT_POPUP_MENU.addTableValidator(new TableKeyFieldsValidator());
    }
}

