/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.chart.converters;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.AbstractFormatConverter;
import com.tibbo.aggregate.common.expression.Expression;
import java.awt.Font;

public class FCFont
extends AbstractFormatConverter<Font> {
    public static final String FONT_ARIAL = "Arial";
    public static final TableFormat FORMAT = new TableFormat(1, 1);
    public static final String VF_FONT_NAME = "name";
    public static final String VF_FONT_SIZE = "size";
    public static final String VF_FONT_CUSTOM = "custom";
    public static final String VF_FONT_BOLD = "bold";
    public static final String VF_FONT_ITALIC = "italic";

    public FCFont() {
        super(Font.class, FORMAT);
    }

    @Override
    public Font convertToBean(Object value, Font originalValue) {
        return FCFont.createFont((DataTable)value);
    }

    @Override
    public Object convertToTable(Font value, TableFormat format) {
        return FCFont.createTable(value);
    }

    public static Font createFont(DataTable source) {
        try {
            int style;
            DataRecord rec = source.rec();
            if (!rec.getBoolean(VF_FONT_CUSTOM).booleanValue()) {
                return null;
            }
            String name = rec.getString(VF_FONT_NAME);
            int n = style = rec.getBoolean(VF_FONT_BOLD) != false ? 1 : 0;
            if (rec.getBoolean(VF_FONT_ITALIC).booleanValue()) {
                style |= 2;
            }
            return new Font(name, style, rec.getInt(VF_FONT_SIZE));
        }
        catch (Exception ex) {
            Log.WIDGETS.error((Object)"Error creating font", (Throwable)ex);
            return null;
        }
    }

    public static DataTable createTable(Font font) {
        DataRecord rec = new DataRecord(FORMAT);
        if (font != null) {
            rec.setValue(VF_FONT_CUSTOM, (Object)true);
            rec.setValue(VF_FONT_NAME, (Object)font.getName());
            rec.setValue(VF_FONT_SIZE, (Object)font.getSize());
            rec.setValue(VF_FONT_BOLD, (Object)font.isBold());
            rec.setValue(VF_FONT_ITALIC, (Object)font.isItalic());
        }
        return rec.wrap();
    }

    static {
        FORMAT.setNamingExpression(new Expression("{name} + ', ' + {size}"));
        FORMAT.addField(FieldFormat.create("<custom><B><D=" + Cres.get().getString("wCustomFont") + ">"));
        FieldFormat ff = FieldFormat.create("<name><S><F=N><A=Arial><D=" + Cres.get().getString(VF_FONT_NAME) + "><E=" + "font" + ">");
        FORMAT.addField(ff);
        FORMAT.addField(FieldFormat.create("<size><I><A=10><D=" + Cres.get().getString(VF_FONT_SIZE) + ">"));
        FORMAT.addField(FieldFormat.create("<bold><B><D=" + Cres.get().getString(VF_FONT_BOLD) + ">"));
        FORMAT.addField(FieldFormat.create("<italic><B><D=" + Cres.get().getString(VF_FONT_ITALIC) + ">"));
        FORMAT.addBinding("name#enabled", "{custom}");
        FORMAT.addBinding("size#enabled", "{custom}");
        FORMAT.addBinding("bold#enabled", "{custom}");
        FORMAT.addBinding("italic#enabled", "{custom}");
    }
}

