/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget.chart.converters;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.AbstractFormatConverter;
import java.awt.Color;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public class FCBorder
extends AbstractFormatConverter<Border> {
    public static final String BORDER_NONE = "none";
    public static final String BORDER_EMPTY = "empty";
    public static final String BORDER_LINE = "line";
    public static final String BORDER_LOWERED = "lowered";
    public static final String BORDER_RAISED = "raised";
    public static final String BORDER_ETCHED = "etched";
    public static final String VF_BORDER_PRIMARY_COLOR = "color";
    public static final String VF_BORDER_SECONDARY_COLOR = "scolor";
    public static final String VF_BORDER_POSITION = "pos";
    public static final String VF_BORDER_TYPE = "type";
    public static final String VF_BORDER_TOP = "top";
    public static final String VF_BORDER_LEFT = "left";
    public static final String VF_BORDER_BOTTOM = "bottom";
    public static final String VF_BORDER_RIGHT = "right";
    public static final String VF_BORDER_TITLE = "title";
    public static final String VF_BORDER_TITLE_COLOR = "tcolor";
    public static final String VF_BORDER_JUSTIFICATION = "justification";
    public static final String BORDER_POSITION_INNER = "Inner";
    public static final String BORDER_POSITION_OUTER = "Outer";
    public static final TableFormat VFT_BORDER = new TableFormat(2, 2);

    public FCBorder() {
        super(Border.class, VFT_BORDER);
    }

    @Override
    public Border convertToBean(Object value, Border originalValue) {
        return FCBorder.createBorder((DataTable)value);
    }

    @Override
    public Object convertToTable(Border value, TableFormat format) {
        return FCBorder.createTable(value);
    }

    public static DataTable createDefaultTable() {
        SimpleDataTable table = new SimpleDataTable(VFT_BORDER, true);
        table.getRecord(0).setValue(VF_BORDER_POSITION, (Object)BORDER_POSITION_INNER);
        table.getRecord(1).setValue(VF_BORDER_POSITION, (Object)BORDER_POSITION_OUTER);
        return table;
    }

    private static Border createBorderPart(DataRecord source) {
        String type = source.getString(VF_BORDER_TYPE);
        int top = source.getInt(VF_BORDER_TOP);
        int left = source.getInt(VF_BORDER_LEFT);
        int bottom = source.getInt(VF_BORDER_BOTTOM);
        int right = source.getInt(VF_BORDER_RIGHT);
        Color color = source.getColor(VF_BORDER_PRIMARY_COLOR);
        Color scolor = source.getColor(VF_BORDER_SECONDARY_COLOR);
        String title = source.getString(VF_BORDER_TITLE);
        Color tcolor = source.getColor(VF_BORDER_TITLE_COLOR);
        int justification = source.getInt(VF_BORDER_JUSTIFICATION);
        Border border = null;
        if (type.equals(BORDER_EMPTY)) {
            border = BorderFactory.createEmptyBorder(top, left, bottom, right);
        } else if (type.equals(BORDER_LINE)) {
            border = BorderFactory.createMatteBorder(top, left, bottom, right, color);
        } else if (type.equals(BORDER_LOWERED)) {
            border = BorderFactory.createBevelBorder(1, scolor, color);
        } else if (type.equals(BORDER_RAISED)) {
            border = BorderFactory.createBevelBorder(0, scolor, color);
        } else if (type.equals(BORDER_ETCHED)) {
            border = BorderFactory.createEtchedBorder(0, color, scolor);
        }
        if (border != null && title.length() > 0) {
            border = BorderFactory.createTitledBorder(border, title, justification, 0, null, tcolor);
        }
        return border;
    }

    public static Border createBorder(DataTable source) {
        Border inner = FCBorder.createBorderPart(source.getRecord(0));
        Border outer = FCBorder.createBorderPart(source.getRecord(1));
        return inner == null && outer == null ? null : BorderFactory.createCompoundBorder(outer, inner);
    }

    public static DataTable createTable(Border border) {
        DataTable res = FCBorder.createDefaultTable();
        if (border != null) {
            DataRecord inner = res.getRecord(0);
            DataRecord outer = res.getRecord(1);
            CompoundBorder compoundBorder = (CompoundBorder)border;
            FCBorder.fill(inner, compoundBorder.getInsideBorder());
            FCBorder.fill(outer, compoundBorder.getOutsideBorder());
        }
        return res;
    }

    private static void fill(DataRecord rec, Border border) {
        if (border instanceof TitledBorder) {
            TitledBorder b = (TitledBorder)border;
            rec.setValue(VF_BORDER_TITLE, (Object)b.getTitle());
            rec.setValue(VF_BORDER_TITLE_COLOR, (Object)b.getTitleColor());
            rec.setValue(VF_BORDER_JUSTIFICATION, (Object)b.getTitleJustification());
            FCBorder.fill(rec, b.getBorder());
        } else if (border instanceof EmptyBorder) {
            EmptyBorder b = (EmptyBorder)border;
            rec.setValue(VF_BORDER_TYPE, (Object)BORDER_EMPTY);
            rec.setValue(VF_BORDER_TOP, (Object)b.getBorderInsets().top);
            rec.setValue(VF_BORDER_LEFT, (Object)b.getBorderInsets().left);
            rec.setValue(VF_BORDER_BOTTOM, (Object)b.getBorderInsets().bottom);
            rec.setValue(VF_BORDER_RIGHT, (Object)b.getBorderInsets().right);
            if (border instanceof MatteBorder) {
                MatteBorder mb = (MatteBorder)border;
                rec.setValue(VF_BORDER_TYPE, (Object)BORDER_LINE);
                rec.setValue(VF_BORDER_PRIMARY_COLOR, (Object)mb.getMatteColor());
            }
        } else if (border instanceof BevelBorder) {
            BevelBorder b = (BevelBorder)border;
            rec.setValue(VF_BORDER_TYPE, (Object)(b.getBevelType() == 1 ? BORDER_LOWERED : BORDER_RAISED));
            rec.setValue(VF_BORDER_SECONDARY_COLOR, (Object)b.getHighlightInnerColor());
            rec.setValue(VF_BORDER_PRIMARY_COLOR, (Object)b.getShadowOuterColor());
        } else if (border instanceof EtchedBorder) {
            EtchedBorder b = (EtchedBorder)border;
            rec.setValue(VF_BORDER_TYPE, (Object)BORDER_ETCHED);
            rec.setValue(VF_BORDER_SECONDARY_COLOR, (Object)b.getShadowColor());
            rec.setValue(VF_BORDER_PRIMARY_COLOR, (Object)b.getHighlightColor());
        }
    }

    static {
        FieldFormat posF = FieldFormat.create("<pos><S><F=R><D=" + Cres.get().getString("position") + ">");
        LinkedHashMap<String, String> posVals = new LinkedHashMap<String, String>();
        posVals.put(BORDER_POSITION_INNER, Cres.get().getString("wInner"));
        posVals.put(BORDER_POSITION_OUTER, Cres.get().getString("wOuter"));
        posF.setSelectionValues(posVals);
        VFT_BORDER.addField(posF);
        VFT_BORDER.addField(FieldFormat.create("<type><S><A=none><D=" + Cres.get().getString(VF_BORDER_TYPE) + "><S=<" + Cres.get().getString("default") + "=" + BORDER_NONE + "><" + Cres.get().getString(BORDER_EMPTY) + "=" + BORDER_EMPTY + "><" + Cres.get().getString(BORDER_LINE) + "=" + BORDER_LINE + "><" + Cres.get().getString("wLowered") + "=" + BORDER_LOWERED + "><" + Cres.get().getString("wRaised") + "=" + BORDER_RAISED + "><" + Cres.get().getString("wEtched") + "=" + BORDER_ETCHED + ">>"));
        VFT_BORDER.addField(FieldFormat.create("<top><I><D=" + Cres.get().getString("wTop") + "><A=1>"));
        VFT_BORDER.addField(FieldFormat.create("<left><I><D=" + Cres.get().getString("wLeft") + "><A=1>"));
        VFT_BORDER.addField(FieldFormat.create("<bottom><I><D=" + Cres.get().getString("wBottom") + "><A=1>"));
        VFT_BORDER.addField(FieldFormat.create("<right><I><D=" + Cres.get().getString("wRight") + "><A=1>"));
        FieldFormat ff = FieldFormat.create("<color><C><D=" + Cres.get().getString("wPrimaryColor") + ">");
        ff.setDefault(Color.GRAY);
        VFT_BORDER.addField(ff);
        ff = FieldFormat.create("<scolor><C><D=" + Cres.get().getString("wSecondaryColor") + ">");
        ff.setDefault(Color.WHITE);
        VFT_BORDER.addField(ff);
        VFT_BORDER.addField(FieldFormat.create("<title><S><D=" + Cres.get().getString(VF_BORDER_TITLE) + ">"));
        ff = FieldFormat.create("<tcolor><C><D=" + Cres.get().getString("wTitleColor") + ">");
        ff.setDefault(Color.BLACK);
        VFT_BORDER.addField(ff);
        VFT_BORDER.addField(FieldFormat.create("<justification><I><A=1><D=" + Cres.get().getString("wTitleJustification") + "><S=<" + Cres.get().getString("wLeft") + "=" + 1 + "><" + Cres.get().getString("center") + "=" + 2 + "><" + Cres.get().getString("wRight") + "=" + 3 + ">>"));
        String ref1 = "top#enabled";
        String exp1 = "{type} == 'empty' || {type} == 'line'";
        VFT_BORDER.addBinding(ref1, exp1);
        String ref2 = "left#enabled";
        String exp2 = "{type} == 'empty' || {type} == 'line'";
        VFT_BORDER.addBinding(ref2, exp2);
        String ref3 = "bottom#enabled";
        String exp3 = "{type} == 'empty' || {type} == 'line'";
        VFT_BORDER.addBinding(ref3, exp3);
        String ref4 = "right#enabled";
        String exp4 = "{type} == 'empty' || {type} == 'line'";
        VFT_BORDER.addBinding(ref4, exp4);
        String ref5 = "color#enabled";
        String exp5 = "{type} == 'line' || {type} == 'lowered' || {type} == 'raised' || {type} == 'etched'";
        VFT_BORDER.addBinding(ref5, exp5);
        String ref6 = "scolor#enabled";
        String exp6 = "{type} == 'lowered' || {type} == 'raised' || {type} == 'etched'";
        VFT_BORDER.addBinding(ref6, exp6);
        String ref7 = "title#enabled";
        String exp7 = "{type} != 'none'";
        VFT_BORDER.addBinding(ref7, exp7);
        VFT_BORDER.addBinding("tcolor#enabled", "{title} != ''");
        VFT_BORDER.addBinding("justification#enabled", "{title} != ''");
    }
}

