/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget;

import com.tibbo.aggregate.common.widget.CollectionElementAddedEvent;
import com.tibbo.aggregate.common.widget.CollectionElementRemovedEvent;
import com.tibbo.aggregate.common.widget.DynamicObservablePropertyChangeEvent;
import com.tibbo.aggregate.common.widget.ListenersMonitor;
import java.beans.PropertyChangeSupport;

public class WPropertyChangeSupport
extends PropertyChangeSupport {
    private Object sourceBean;
    private static final ListenersMonitor listenersMonitor = new ListenersMonitor();

    public WPropertyChangeSupport(Object sourceBean) {
        super(sourceBean);
        this.sourceBean = sourceBean;
    }

    public void fireCollectionElementAddedEvent(String propertyName, Object addedValue, int addedIndex) {
        this.firePropertyChange(new CollectionElementAddedEvent(this.sourceBean, propertyName, addedValue, addedIndex));
    }

    public void fireCollectionElementRemovedEvent(String propertyName, Object removedValue, int removedIndex) {
        this.firePropertyChange(new CollectionElementRemovedEvent(this.sourceBean, propertyName, removedValue, removedIndex));
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    public void fireDynamicObservablePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(new DynamicObservablePropertyChangeEvent(this.sourceBean, propertyName, oldValue, newValue));
    }

    public static ListenersMonitor getListenersMonitor() {
        return listenersMonitor;
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }
}

