/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget;

import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.BindingUtils;
import com.tibbo.aggregate.common.binding.EvaluationOptions;
import com.tibbo.aggregate.common.binding.ExtendedBinding;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.util.Util;
import com.tibbo.aggregate.common.widget.component.WComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class WBindingUtils {
    public static final String SUBMIT_EVENT = "submit";
    public static final String LOGOUT_EVENT = "logout";

    public static List<ExtendedBinding> getBindingsRelatedToComponent(List<ExtendedBinding> bindings, String compName) throws SyntaxErrorException {
        return WBindingUtils.getBindingsRelatedToEntity(bindings, compName, null);
    }

    public static List<ExtendedBinding> getBindingsRelatedToEntity(List<ExtendedBinding> bindings, String componentName, String entity) throws SyntaxErrorException {
        List<ExtendedBinding> result = WBindingUtils.getBindingsWithComponent(bindings, componentName, entity);
        boolean acceptAllEntities = StringUtils.isEmpty(entity);
        for (ExtendedBinding binding : bindings) {
            boolean acceptEntity;
            Reference activator = binding.getEvaluationOptions().getActivator();
            if (activator == null) continue;
            boolean bl = acceptEntity = acceptAllEntities || Util.equals(activator.getEntity(), entity);
            if (!Util.equals(activator.getContext(), componentName) || !acceptEntity) continue;
            WBindingUtils.addIfNotExist(result, binding);
        }
        return result;
    }

    protected static void addIfNotExist(List<ExtendedBinding> result, ExtendedBinding binding) {
        if (!result.contains(binding)) {
            result.add(binding);
        }
    }

    public static List<ExtendedBinding> getBindingsWithComponent(List<ExtendedBinding> bindings, String compName, String entity) throws SyntaxErrorException {
        LinkedList<ExtendedBinding> result = new LinkedList<ExtendedBinding>();
        boolean acceptAllEntities = StringUtils.isEmpty(entity);
        for (ExtendedBinding binding : bindings) {
            ArrayList<Reference> componentEntityReferences = new ArrayList<Reference>();
            for (Reference ref : binding.getAllReferences()) {
                boolean entityAccepted = acceptAllEntities || Util.equals(ref.getEntity(), entity);
                if (!entityAccepted || !Util.equals(ref.getContext(), compName)) continue;
                componentEntityReferences.add(ref);
            }
            if (componentEntityReferences.isEmpty()) continue;
            WBindingUtils.addIfNotExist(result, binding);
        }
        return result;
    }

    public static ExtendedBinding findBindingById(long id, List<ExtendedBinding> bindings) {
        for (ExtendedBinding bg : bindings) {
            if (!bg.getBinding().getId().equals(id)) continue;
            return bg;
        }
        return null;
    }

    public static Set<String> getComponentsRelatedToBinding(ExtendedBinding binding) {
        HashSet<String> list = new HashSet<String>();
        try {
            for (Reference ref : binding.getAllReferences()) {
                if (!"form".equals(ref.getSchema()) || ref.getContext() == null) continue;
                list.add(ref.getContext());
            }
        }
        catch (SyntaxErrorException ex) {
            throw new IllegalArgumentException("" + ex.getMessage(), ex);
        }
        return list;
    }

    public static HashMap<String, Set<String>> getPropertiesRelatedToBinding(ExtendedBinding b) throws SyntaxErrorException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Reference ref : b.getAllReferences()) {
            boolean componentPropertyRef = "form".equals(ref.getSchema()) && ref.getEntity() != null && 1 == ref.getEntityType();
            if (!componentPropertyRef) continue;
            if (!result.containsKey(ref.getContext())) {
                result.put(ref.getContext(), new HashSet());
            }
            result.get(ref.getContext()).add(ref.getEntity());
        }
        return result;
    }

    public static boolean compareEOptions(EvaluationOptions one, EvaluationOptions another) {
        if (one == null && another == null) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return WBindingUtils.compareReferences(one.getActivator(), another.getActivator()) && one.getPattern() == another.getPattern() && one.getPeriod() == another.getPeriod();
    }

    public static boolean compareReferences(Reference one, Reference another) {
        boolean bothAreNulls = one == null && another == null;
        boolean bothAreNotNulls = one != null && another != null;
        return bothAreNulls || bothAreNotNulls && one.getImage().equals(another.getImage());
    }

    public static List<ExtendedBinding> getFunctionBindings(Reference functionRef, List<ExtendedBinding> bindings) throws SyntaxErrorException {
        LinkedList<ExtendedBinding> list = new LinkedList<ExtendedBinding>();
        for (ExtendedBinding bg : bindings) {
            if (BindingUtils.isFunctionBinding(bg.getBinding(), functionRef) == null) continue;
            WBindingUtils.addIfNotExist(list, bg);
        }
        return list;
    }

    public static Reference getReferenceForComponentProperty(WComponent comp, String property) {
        Reference ref = new Reference();
        ref.setSchema("form");
        ref.setContext(comp.getName());
        ref.setEntity(property);
        return ref;
    }

    public static Reference getSubmitReference() {
        Reference ref = new Reference();
        ref.setSchema("form");
        ref.setContext("");
        ref.setEntity(SUBMIT_EVENT);
        ref.setEntityType(4);
        return ref;
    }

    public static Reference getResetReference() {
        Reference ref = new Reference();
        ref.setSchema("form");
        ref.setContext("");
        ref.setEntity(LOGOUT_EVENT);
        ref.setEntityType(4);
        return ref;
    }

    public static List<ExtendedBinding> findScriptExecuteBindings(String script, List<ExtendedBinding> bindings) {
        LinkedList<ExtendedBinding> bs = new LinkedList<ExtendedBinding>();
        for (ExtendedBinding b : bindings) {
            if (!"form".equals(b.getBinding().getTarget().getSchema()) || b.getBinding().getTarget().getEntityType() != 2 || !b.getBinding().getTarget().getEntity().equals(script)) continue;
            WBindingUtils.addIfNotExist(bs, b);
        }
        return bs;
    }

    public static ExtendedBinding getDuplicateIDBinding(List<ExtendedBinding> bindings, Binding bg) {
        for (ExtendedBinding b : bindings) {
            if (!b.getBinding().getId().equals(bg.getId())) continue;
            return b;
        }
        return null;
    }
}

