/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.widget;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.widget.component.WComponent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ListenersMonitor {
    private final Map<WComponent, List<PropertyChangeListener>> listenersMap = new LinkedHashMap<WComponent, List<PropertyChangeListener>>();
    private String attentionOn = null;
    private final Map<PropertyChangeListener, String> places = new LinkedHashMap<PropertyChangeListener, String>();

    public void listenerAdded(WComponent component, PropertyChangeListener listener, String place) {
        this.ensureComponentList(component);
        this.listenersMap.get(component).add(listener);
        this.places.put(listener, place);
        if (this.attentionOn == null || this.attentionOn.equals(component.getName())) {
            Log.GUIBUILDER.debug((Object)("+ component '" + component.getName() + "'(" + component.hashCode() + ") got listener: " + listener.hashCode()));
        }
    }

    public String getAttentionOn() {
        return this.attentionOn;
    }

    public void setAttentionOn(String attentionOn) {
        this.attentionOn = attentionOn;
    }

    public void ensureComponentList(WComponent component) {
        if (!this.listenersMap.containsKey(component)) {
            this.listenersMap.put(component, new LinkedList());
        }
    }

    public void listenerRemoved(WComponent component, PropertyChangeListener listener) {
        if (!this.listenersMap.containsKey(component)) {
            throw new IllegalStateException("Unknown component '" + component.getName() + "' in listeners monitor");
        }
        this.listenersMap.get(component).remove(listener);
        if (this.attentionOn == null || this.attentionOn.equals(component.getName())) {
            Log.GUIBUILDER.debug((Object)("- component '" + component.getName() + "'(" + component.hashCode() + ") removed listener: " + listener.hashCode()));
        }
    }

    public void reportRemained() {
        for (WComponent c : this.listenersMap.keySet()) {
            List<PropertyChangeListener> list = this.listenersMap.get(c);
            if (list.size() > 0) {
                Log.GUIBUILDER.warn((Object)("Component '" + c.getName() + "'(" + c.hashCode() + ") has " + list.size() + " listeners remained"));
            }
            for (PropertyChangeListener item : list) {
                Log.GUIBUILDER.warn((Object)("-- listener " + item.hashCode() + " from: " + this.places.get(item)));
            }
        }
    }
}

