/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.view;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.view.ViewFilterProcessResult;
import com.tibbo.aggregate.common.view.ViewFilterProcessor;
import java.util.Iterator;

public class ViewFilterWalker {
    private final ViewFilterProcessor processor;

    public ViewFilterWalker(ViewFilterProcessor processor) {
        this.processor = processor;
    }

    public ViewFilterProcessResult walk(DataTable filterTable) {
        ViewFilterProcessResult result = ViewFilterProcessResult.OK;
        if (filterTable != null) {
            Iterator<DataRecord> iterator = filterTable.iterator();
            while (iterator.hasNext()) {
                DataRecord filter = iterator.next();
                ViewFilterProcessResult innerResult = this.processor.processResult(this.walkRecord(filter));
                if (innerResult == ViewFilterProcessResult.ERROR) {
                    iterator.remove();
                    if (filterTable.getRecordCount() != 0) continue;
                    return ViewFilterProcessResult.ERROR;
                }
                if (innerResult != ViewFilterProcessResult.HAS_TO_PROCESS_FULLY) continue;
                result = ViewFilterProcessResult.HAS_TO_PROCESS_FULLY;
            }
        }
        return result;
    }

    private ViewFilterProcessResult walkRecord(DataRecord filter) {
        if (filter.getInt("type") == 1) {
            return this.walk(filter.getDataTable("nested"));
        }
        return this.processor.processRecord(filter);
    }
}

