/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.AggreGateBean;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.validator.ValidatorHelper;
import java.awt.Dimension;

public class WindowLocation
extends AggreGateBean {
    public static final String FIELD_STATE = "state";
    public static final String FIELD_SIDE = "side";
    public static final String FIELD_INDEX = "index";
    public static final String FIELD_WIDTH = "width";
    public static final String FIELD_HEIGHT = "height";
    public static final String FIELD_RESIZABLE = "resizable";
    public static final String FIELD_CLOSABLE = "closable";
    public static final String FIELD_MOVABLE = "movable";
    public static final String FIELD_FLOATABLE = "floatable";
    public static final String FIELD_MAXIMIZABLE = "maximizable";
    public static final String FIELD_AUTOHIDABLE = "autohidable";
    public static final String FIELD_SHOW_TITLE_BAR = "showTitleBar";
    public static final String FIELD_KEY = "key";
    public static final String FIELD_ELEMENT_INDEX = "elementIndex";
    public static final int STATE_DOCKED = 0;
    public static final int STATE_FLOATING = 1;
    public static final int STATE_SIDE_BAR = 2;
    public static final int SIDE_TOP = 0;
    public static final int SIDE_LEFT = 1;
    public static final int SIDE_BOTTOM = 2;
    public static final int SIDE_RIGHT = 3;
    public static TableFormat FORMAT = new TableFormat(1, 1);
    private int state;
    private int side;
    private int index;
    private Integer width;
    private Integer height;
    private boolean resizable;
    private boolean closable;
    private boolean movable;
    private boolean floatable;
    private boolean maximizable;
    private boolean autohidable;
    private boolean showTitleBar;
    private String key;
    private Integer elementIndex;

    public WindowLocation() {
        super(FORMAT);
    }

    public WindowLocation(int state) {
        this();
        this.state = state;
    }

    public WindowLocation(Dimension size) {
        this();
        this.state = 1;
        this.width = size.width;
        this.height = size.height;
    }

    public WindowLocation(int side, int index) {
        this();
        this.state = 0;
        this.side = side;
        this.index = index;
    }

    public WindowLocation(int side, int index, Dimension size) {
        this(0, side, index, size);
    }

    public WindowLocation(int column, Dimension size) {
        this(0, 0, column, size);
    }

    public WindowLocation(int state, int side, int index) {
        this();
        this.state = state;
        this.side = side;
        this.index = index;
    }

    public WindowLocation(int state, int side, int index, Dimension size) {
        this();
        this.state = state;
        this.side = side;
        this.index = index;
        if (size != null) {
            this.width = size.width;
            this.height = size.height;
        }
    }

    public WindowLocation(DataRecord data) {
        super(FORMAT, data);
    }

    public void applyDefaultSize(Dimension defaultSize) {
        if (this.getWidth() == null || this.getWidth() == 0) {
            this.setWidth(defaultSize.width);
        }
        if (this.getHeight() == null || this.getHeight() == 0) {
            this.setHeight(defaultSize.height);
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int side) {
        this.side = side;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    public void setFloatable(boolean floatable) {
        this.floatable = floatable;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public void setMaximizable(boolean maximizable) {
        this.maximizable = maximizable;
    }

    public boolean isAutohidable() {
        return this.autohidable;
    }

    public void setAutohidable(boolean autohidable) {
        this.autohidable = autohidable;
    }

    public boolean isShowTitleBar() {
        return this.showTitleBar;
    }

    public void setShowTitleBar(boolean showTitleBar) {
        this.showTitleBar = showTitleBar;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getElementIndex() {
        return this.elementIndex;
    }

    public void setElementIndex(Integer elementIndex) {
        this.elementIndex = elementIndex;
    }

    public String toString() {
        return "Window Location [state=" + this.state + ", side=" + this.side + ", index=" + this.index + ", width=" + this.width + ", height=" + this.height + "]";
    }

    static {
        FieldFormat ff = FieldFormat.create("<state><I><A=0><D=" + Cres.get().getString(FIELD_STATE) + ">");
        ff.addSelectionValue(0, Cres.get().getString("clStateDocked"));
        ff.addSelectionValue(1, Cres.get().getString("clStateFloating"));
        ff.addSelectionValue(2, Cres.get().getString("clStateSideBar"));
        FORMAT.addField(ff);
        ff = FieldFormat.create("<side><I><A=0><D=" + Cres.get().getString(FIELD_SIDE) + ">");
        ff.addSelectionValue(0, Cres.get().getString("clSideTop"));
        ff.addSelectionValue(1, Cres.get().getString("clSideLeft"));
        ff.addSelectionValue(2, Cres.get().getString("clSideBottom"));
        ff.addSelectionValue(3, Cres.get().getString("clSideRight"));
        FORMAT.addField(ff);
        FORMAT.addField(FieldFormat.create("<index><I><D=" + Cres.get().getString(FIELD_INDEX) + ">"));
        ff = FieldFormat.create("<width><I><F=N><D=" + Cres.get().getString(FIELD_WIDTH) + ">");
        ff.addValidator(ValidatorHelper.NON_ZERO_LENGTH_VALIDATOR);
        FORMAT.addField(ff);
        ff = FieldFormat.create("<height><I><F=N><D=" + Cres.get().getString(FIELD_HEIGHT) + ">");
        ff.addValidator(ValidatorHelper.NON_ZERO_LENGTH_VALIDATOR);
        FORMAT.addField(ff);
        FORMAT.addField(FieldFormat.create("<resizable><B><A=1><D=" + Cres.get().getString("clWindowResizable") + ">"));
        FORMAT.addField(FieldFormat.create("<closable><B><A=1><D=" + Cres.get().getString("clWindowClosable") + ">"));
        FORMAT.addField(FieldFormat.create("<movable><B><A=1><D=" + Cres.get().getString("clWindowMovable") + ">"));
        FORMAT.addField(FieldFormat.create("<floatable><B><A=1><D=" + Cres.get().getString("clWindowFloatable") + ">"));
        FORMAT.addField(FieldFormat.create("<maximizable><B><A=1><D=" + Cres.get().getString("clWindowMaximizable") + ">"));
        FORMAT.addField(FieldFormat.create("<autohidable><B><A=1><D=" + Cres.get().getString("clWindowAutohidable") + ">"));
        FORMAT.addField(FieldFormat.create("<showTitleBar><B><A=1><D=" + Cres.get().getString("clWindowShowTitleBar") + ">"));
        FORMAT.addField(FieldFormat.create("<key><S><F=A><D=" + Cres.get().getString(FIELD_KEY) + ">"));
        FORMAT.addField(FieldFormat.create("<elementIndex><I><F=A>").setNullable(true).setDefault(null).setHidden(true));
        FORMAT.addBinding("side#enabled", "{state} != 1");
        FORMAT.addBinding("floatable#enabled", "{movable} && {state} != 1");
        FORMAT.addBinding("maximizable#enabled", "{movable}");
        FORMAT.addBinding("autohidable#enabled", "{movable}");
        String state = "{state#svdesc}";
        String side = "({state} != 1 ? (', ' + {side#svdesc}) : '')";
        String index = "({state} != 1 ? (' (' + {index} + ')') : '')";
        FORMAT.setNamingExpression(state + "+" + side + "+" + index);
    }
}

