/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.resource.ResourceManager;
import com.tibbo.aggregate.common.util.DateUtils;
import com.tibbo.aggregate.common.util.ExtendedNumber;
import com.tibbo.aggregate.common.util.StringUtils;
import java.awt.Image;
import java.awt.SystemTray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Util {
    private static final String NULL = "NULL";

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static Throwable getCause(Throwable th, Class<InterruptedException> throwableClass) {
        Throwable cause = th;
        do {
            if (cause == null || !throwableClass.isAssignableFrom(cause.getClass())) continue;
            return cause;
        } while ((cause = cause.getCause()) != null);
        return null;
    }

    public static Throwable getRootCause(Throwable th) {
        Throwable cur = th;
        while (cur.getCause() != null) {
            cur = cur.getCause();
        }
        return cur;
    }

    public static byte[] readStream(InputStream is) throws IOException {
        int numRead;
        byte[] buf = new byte[is.available()];
        ByteArrayOutputStream os = new ByteArrayOutputStream(is.available());
        while ((numRead = is.read(buf)) > 0) {
            os.write(buf, 0, numRead);
        }
        return os.toByteArray();
    }

    public static String convertToString(Object value, boolean validate, boolean allowNull) {
        if (value == null) {
            if (allowNull) {
                return null;
            }
            if (validate) {
                throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToString") + Util.getObjectDescription(value));
            }
            return new String();
        }
        return value.toString();
    }

    public static Number convertToNumber(Object value, boolean validate, boolean allowNull) {
        if (value == null) {
            if (allowNull) {
                return null;
            }
            if (validate) {
                throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToNumber") + Util.getObjectDescription(value));
            }
            return 0;
        }
        if (value instanceof DataTable) {
            DataTable table = (DataTable)value;
            if (table.getRecordCount() == 0 || table.getFieldCount() == 0) {
                if (validate) {
                    throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToNumber") + table);
                }
                return 0;
            }
            return Util.convertToNumber(table.get(), validate, allowNull);
        }
        if (value instanceof ExtendedNumber) {
            Number number2 = ((ExtendedNumber)value).getNumber();
            return Util.convertToNumber(number2, validate, allowNull);
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        try {
            return Long.valueOf(value.toString());
        }
        catch (NumberFormatException number2) {
            try {
                return Double.valueOf(value.toString());
            }
            catch (NumberFormatException number2) {
                Boolean aBoolean = Util.convertToBoolean(value, false, true);
                if (aBoolean != null) {
                    return aBoolean != false ? 1 : 0;
                }
                if (NULL.equals(value.toString().toUpperCase())) {
                    return allowNull ? null : Integer.valueOf(0);
                }
                if (validate) {
                    throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToNumber") + Util.getObjectDescription(value));
                }
                return allowNull ? null : Integer.valueOf(0);
            }
        }
    }

    public static Date convertToDate(Object value, boolean validate, boolean allowNull) {
        if (value == null) {
            if (allowNull) {
                return null;
            }
            if (validate) {
                throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToDate") + Util.getObjectDescription(value));
            }
            return new Date();
        }
        if (value instanceof DataTable) {
            DataTable table = (DataTable)value;
            if (table.getRecordCount() == 0 || table.getFieldCount() == 0) {
                if (validate) {
                    throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToDate") + table);
                }
                return new Date();
            }
            return Util.convertToDate(table.get(), validate, allowNull);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            return DateUtils.parseSmart(value.toString());
        }
        catch (ParseException ex) {
            if (validate) {
                throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToDate") + Util.getObjectDescription(value));
            }
            return allowNull ? null : new Date();
        }
    }

    public static Boolean convertToBoolean(Object value, boolean validate, boolean allowNull) {
        if (value == null) {
            if (allowNull) {
                return null;
            }
            if (validate) {
                throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToBoolean") + Util.getObjectDescription(value));
            }
            return false;
        }
        if (value instanceof DataTable) {
            DataTable table = (DataTable)value;
            if (table.getRecordCount() == 0 || table.getFieldCount() == 0) {
                if (validate) {
                    throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToBoolean") + table);
                }
                return false;
            }
            return Util.convertToBoolean(table.get(), validate, allowNull);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("1")) {
                return true;
            }
            if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("0")) {
                return false;
            }
        }
        if (validate) {
            throw new IllegalArgumentException(Cres.get().getString("utCannotConvertToBoolean") + Util.getObjectDescription(value));
        }
        return allowNull ? null : Boolean.valueOf(false);
    }

    public static boolean isFloatingPoint(Number n) {
        return n instanceof Float || n instanceof Double;
    }

    public static String getObjectDescription(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString() + " (" + o.getClass().getName() + ")";
    }

    public static Class getListElementType(Type listType) {
        ParameterizedType pt;
        Type t;
        if (listType instanceof ParameterizedType && (t = (pt = (ParameterizedType)listType).getActualTypeArguments()[0]) != null && t instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    public static Class getMapKeyType(Type mapType) {
        ParameterizedType pt;
        Type t;
        if (mapType instanceof ParameterizedType && (t = (pt = (ParameterizedType)mapType).getActualTypeArguments()[0]) != null && t instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    public static int parseVersion(String version) {
        int major = Integer.parseInt(version.substring(0, 1));
        int minor = Integer.parseInt(version.substring(2, 4));
        int build = Integer.parseInt(version.substring(5, 7));
        return major * 10000 + minor * 100 + build;
    }

    public static String nameToDescription(String name) {
        StringBuilder sb = new StringBuilder();
        boolean prevWasUpper = false;
        boolean nextToUpper = false;
        for (int i = 0; i < name.length(); ++i) {
            Character c = Character.valueOf(name.charAt(i));
            if (Character.isUpperCase(c.charValue())) {
                if (!prevWasUpper && i != 0) {
                    sb.append(" ");
                }
                prevWasUpper = true;
            } else {
                prevWasUpper = false;
            }
            if (i == 0 || nextToUpper) {
                c = Character.valueOf(Character.toUpperCase(c.charValue()));
                nextToUpper = false;
            }
            if (c.charValue() == '_') {
                sb.append(" ");
                nextToUpper = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String descriptionToName(String value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (ContextUtils.isValidContextNameChar(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static String getTrayIconId(String prefix) {
        Integer width;
        List<Integer> sizes = Arrays.asList(16, 24, 32, 48, 64, 128);
        if (SystemTray.isSupported() && sizes.contains(width = Integer.valueOf(SystemTray.getSystemTray().getTrayIconSize().width))) {
            return prefix + "_" + width;
        }
        return prefix + "_" + 16;
    }

    public static List<Image> getIconImages(String prefix, List<Integer> sizes) {
        LinkedList<Image> res = new LinkedList<Image>();
        for (Integer size : sizes) {
            res.add(ResourceManager.getImageIcon(prefix + "_" + size).getImage());
        }
        return res;
    }

    public static <K, V extends Comparable> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return ((Comparable)e1.getValue()).compareTo(e2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static void logWithSourceCodeLine(Logger logger, Level level, Object o) {
        if (o == null || StringUtils.isEmpty(o.toString())) {
            return;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int sourceLoggerStackPosition = 2;
        String sourceLoggerStack = "";
        if (stackTrace.length > sourceLoggerStackPosition + 1) {
            sourceLoggerStack = stackTrace[sourceLoggerStackPosition].toString();
        }
        logger.log((Priority)level, (Object)(o.toString() + ": " + sourceLoggerStack));
    }

    public static String getChosenValueRepresentation(Map<Object, String> sectionValues, Object selectedValue) {
        String ov = sectionValues.get(selectedValue);
        return ov != null ? ov : (selectedValue != null ? selectedValue.toString() : Cres.get().getString("notSelected"));
    }
}

