/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.action.EntityRelatedActionDescriptor;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.device.RemoteDeviceErrorException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.util.DateUtils;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;

public class UserSettings
implements Cloneable {
    private String datePattern;
    private String timePattern;
    private String timeZone;
    private int weekStartDay = 2;
    private List<EntityRelatedActionDescriptor> variableActions;
    private List<EntityRelatedActionDescriptor> eventActions;
    private final AtomicBoolean initialized = new AtomicBoolean();

    public UserSettings() {
    }

    public UserSettings(Evaluator evaluator) {
        if (evaluator != null) {
            try {
                this.fill(evaluator.getDefaultResolver().getContextManager(), evaluator.getDefaultResolver().getCallerController());
                this.initialized.set(true);
            }
            catch (ContextException | RemoteDeviceErrorException e) {
                Log.CONTEXT.warn((Object)"Unable to fill user settings data", (Throwable)e);
            }
        }
    }

    public UserSettings(ContextManager cm, CallerController callerController) {
        this();
        try {
            this.fill(cm, callerController);
            this.initialized.set(true);
        }
        catch (ContextException | RemoteDeviceErrorException e) {
            Log.CONTEXT.warn((Object)"Unable to fill user settings data", (Throwable)e);
        }
    }

    public SimpleDateFormat createDateFormatter() {
        return this.createDateFormatter(this.getDateTimePattern(), null);
    }

    public SimpleDateFormat createDateFormatter(String pattern, String timezone) {
        String tz;
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.ENGLISH);
        String string = tz = timezone != null ? timezone : this.timeZone;
        if (tz != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(tz));
        }
        return sdf;
    }

    public ZoneId getZoneIdOrDefault() {
        if (this.timeZone != null) {
            return ZoneId.of(this.timeZone);
        }
        return ZoneId.systemDefault();
    }

    public String getDatePattern() {
        return this.datePattern != null ? this.datePattern : "dd.MM.yyyy";
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getTimePattern() {
        return this.timePattern != null ? this.timePattern : "HH:mm:ss";
    }

    public void setTimePattern(String timePattern) {
        this.timePattern = timePattern;
    }

    public String getDateTimePattern() {
        return DateUtils.getDateTimePattern(this.getDatePattern(), this.getTimePattern());
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public int getWeekStartDay() {
        return this.weekStartDay;
    }

    public void setWeekStartDay(int weekStartDay) {
        this.weekStartDay = weekStartDay;
    }

    public List<EntityRelatedActionDescriptor> getVariableActions() {
        return this.variableActions;
    }

    public void setVariableActions(List<EntityRelatedActionDescriptor> variableActions) {
        this.variableActions = variableActions;
    }

    public List<EntityRelatedActionDescriptor> getEventActions() {
        return this.eventActions;
    }

    public void setEventActions(List<EntityRelatedActionDescriptor> eventActions) {
        this.eventActions = eventActions;
    }

    public UserSettings clone() {
        try {
            UserSettings clone = (UserSettings)super.clone();
            if (this.variableActions != null) {
                clone.variableActions = new ArrayList<EntityRelatedActionDescriptor>(this.variableActions);
            }
            if (this.eventActions != null) {
                clone.eventActions = new ArrayList<EntityRelatedActionDescriptor>(this.eventActions);
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void fill(ContextManager cm, CallerController callerController) throws ContextException, RemoteDeviceErrorException {
        if (cm == null || callerController == null) {
            return;
        }
        this.fillBasicProperties(cm, callerController);
        this.fillActions(cm, callerController);
    }

    public void fillBasicProperties(ContextManager cm, CallerController callerController) throws ContextException {
        if (callerController == null) {
            return;
        }
        Object userContext = cm.get(ContextUtils.userContextPath(callerController.getUsername()), callerController);
        if (userContext == null || userContext.getVariableDefinition("childInfo") == null) {
            return;
        }
        DataRecord userInfo = userContext.getVariable("childInfo", callerController).rec();
        this.setDatePattern(userInfo.getString("datepattern"));
        this.setTimePattern(userInfo.getString("timepattern"));
        this.setTimeZone(userInfo.getString("timezone"));
        if (userInfo.getFormat().hasField("weekStart")) {
            this.setWeekStartDay(userInfo.getInt("weekStart"));
        }
    }

    public void fillActions(ContextManager cm, CallerController callerController) {
        try {
            Object utilities = cm.get("utilities", callerController);
            if (utilities != null) {
                DataTable variableActions = utilities.callFunction("variableActions", callerController);
                this.setVariableActions(DataTableConversion.beansFromTable(variableActions, EntityRelatedActionDescriptor.class, EntityRelatedActionDescriptor.FORMAT, false));
                DataTable eventActions = utilities.callFunction("eventActions", callerController);
                this.setEventActions(DataTableConversion.beansFromTable(eventActions, EntityRelatedActionDescriptor.class, EntityRelatedActionDescriptor.FORMAT, false));
            }
        }
        catch (Exception ex) {
            Log.CLIENTS.error((Object)"Error retrieving entity-related actions", (Throwable)ex);
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }
}

