/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.TimeHelper;
import com.tibbo.aggregate.common.util.TimeUnit;
import java.util.LinkedList;
import java.util.List;

public class TimeUnitsManager {
    private int minUnit = 0;
    private int maxUnit = Integer.MAX_VALUE;
    private final List<TimeUnit> units = new LinkedList<TimeUnit>();

    public TimeUnitsManager() {
    }

    public TimeUnitsManager(String editorOptions) {
        if (editorOptions != null && editorOptions.length() > 0) {
            this.parseEditorOptions(editorOptions);
        }
        this.selectUnits();
    }

    public TimeUnitsManager(int minUnit, int maxUnit) {
        this.minUnit = minUnit;
        this.maxUnit = maxUnit;
        this.selectUnits();
    }

    private void selectUnits() {
        for (TimeUnit unit : TimeHelper.getUnits()) {
            if (unit.getUnit() < this.minUnit || unit.getUnit() > this.maxUnit) continue;
            this.units.add(unit);
        }
    }

    private void parseEditorOptions(String editorOptions) {
        List<String> parts = StringUtils.split(editorOptions, ' ');
        if (parts.size() > 0) {
            this.minUnit = Integer.parseInt(parts.get(0));
        }
        if (parts.size() > 1) {
            this.maxUnit = Integer.parseInt(parts.get(1));
        }
    }

    public int getMinUnit() {
        return this.minUnit;
    }

    public List<TimeUnit> getUnits() {
        return this.units;
    }

    public void setMinUnit(int minUnit) {
        this.minUnit = minUnit;
    }

    public int getMaxUnit() {
        return this.maxUnit;
    }

    public void setMaxUnit(int maxUnit) {
        this.maxUnit = maxUnit;
    }

    public TimeUnit selectUnitByPeriod(long newPeriod) {
        TimeUnit selectedUnit = TimeHelper.getTimeUnit(this.getMinUnit());
        for (TimeUnit unit : TimeHelper.getReversedUnits()) {
            if (unit.getUnit() < this.getMinUnit() || unit.getUnit() > this.getMaxUnit() || unit.isSecondary() || newPeriod < unit.getLength() || newPeriod % unit.getLength() != 0L) continue;
            selectedUnit = unit;
            break;
        }
        return selectedUnit;
    }

    public TimeUnit getUnitByDescription(String description) {
        for (TimeUnit tu : this.getUnits()) {
            if (!tu.getDescription().equals(description)) continue;
            return tu;
        }
        return null;
    }

    public String createTimeString(long period) {
        StringBuffer result = new StringBuffer();
        int pass = 0;
        for (TimeUnit unit : TimeHelper.getReversedUnits()) {
            boolean addZero;
            if (unit.getUnit() > this.getMaxUnit() || unit.isSecondary()) continue;
            long count = period / unit.getLength();
            boolean bl = addZero = result.length() == 0 && unit.getUnit() == this.getMinUnit();
            if (count > 0L || addZero) {
                result.append((pass > 0 ? " " : "") + count + " " + unit.getDescription());
                period -= count * unit.getLength();
            }
            if (unit.getUnit() <= this.getMinUnit()) break;
            ++pass;
        }
        return result.toString().trim();
    }
}

