/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.util.TimeUnit;
import com.tibbo.aggregate.common.util.Util;
import java.text.MessageFormat;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class TimeHelper {
    public static final long SECOND_IN_MS = 1000L;
    public static final long MINUTE_IN_MS = 60000L;
    public static final long HOUR_IN_MS = 3600000L;
    public static final long DAY_IN_MS = 86400000L;
    public static final long WEEK_IN_MS = 604800000L;
    public static final long MONTH_IN_MS = 2592000000L;
    public static final long QUARTER_IN_MS = 7862400000L;
    public static final long YEAR_IN_MS = 31536000000L;
    public static final long MINUTE_IN_SECONDS = 60L;
    public static final long HOUR_IN_SECONDS = 3600L;
    public static final long DAY_IN_SECONDS = 86400L;
    public static final long WEEK_IN_SECONDS = 604800L;
    public static final long MONTH_IN_SECONDS = 2592000L;
    public static final long QUARTER_IN_SECONDS = 7862400L;
    public static final long YEAR_IN_SECONDS = 31536000L;
    public static final int MILLISECOND = 0;
    public static final int SECOND = 1;
    public static final int MINUTE = 2;
    public static final int HOUR = 3;
    public static final int DAY = 4;
    public static final int WEEK = 5;
    public static final int MONTH = 6;
    public static final int QUARTER = 7;
    public static final int YEAR = 8;
    public static final String NAME_MILLISECOND = "millisecond";
    public static final String NAME_MS = "ms";
    public static final String NAME_SECOND = "second";
    public static final String NAME_SEC = "sec";
    public static final String NAME_S = "s";
    public static final String NAME_MINUTE = "minute";
    public static final String NAME_MIN = "min";
    public static final String NAME_M = "m";
    public static final String NAME_HOUR = "hour";
    public static final String NAME_HR = "hr";
    public static final String NAME_H = "h";
    public static final String NAME_DAY = "day";
    public static final String NAME_D = "d";
    public static final String NAME_WEEK = "week";
    public static final String NAME_W = "w";
    public static final String NAME_MONTH = "month";
    public static final String NAME_YEAR = "year";
    public static final String NAME_Y = "y";
    public static final TimeUnit MILLISECOND_UNIT = new TimeUnit(0, 1L, Cres.get().getString("tuMilliseconds"), 14, false, ChronoUnit.MILLIS);
    public static final TimeUnit SECOND_UNIT = new TimeUnit(1, 1000L, Cres.get().getString("tuSeconds"), 13, false, ChronoUnit.SECONDS);
    public static final TimeUnit MINUTE_UNIT = new TimeUnit(2, 60000L, Cres.get().getString("tuMinutes"), 12, false, ChronoUnit.MINUTES);
    public static final TimeUnit HOUR_UNIT = new TimeUnit(3, 3600000L, Cres.get().getString("tuHours"), 11, false, ChronoUnit.HOURS);
    public static final TimeUnit DAY_UNIT = new TimeUnit(4, 86400000L, Cres.get().getString("tuDays"), 5, false, ChronoUnit.DAYS);
    public static final TimeUnit WEEK_UNIT = new TimeUnit(5, 604800000L, Cres.get().getString("tuWeeks"), 3, true, ChronoUnit.WEEKS);
    public static final TimeUnit MONTH_UNIT = new TimeUnit(6, 2592000000L, Cres.get().getString("tuMonths"), 2, false, ChronoUnit.MONTHS);
    public static final TimeUnit QUARTER_UNIT = new TimeUnit(7, 7862400000L, Cres.get().getString("tuQuarters"), null, true);
    public static final TimeUnit YEAR_UNIT = new TimeUnit(8, 31536000000L, Cres.get().getString("tuYears"), 1, false, ChronoUnit.YEARS);
    private static final Map<Object, String> SELECTION_VALUES = new LinkedHashMap<Object, String>();
    private static final List<TimeUnit> UNITS;
    private static List<TimeUnit> REVERSED_UNITS;
    private static Map<String, TimeUnit> NAMED_UNITS;

    public static Map<Object, String> getSelectionValues() {
        return SELECTION_VALUES;
    }

    public static List<TimeUnit> getUnits() {
        return UNITS;
    }

    public static List<TimeUnit> getReversedUnits() {
        return REVERSED_UNITS;
    }

    public static String getUnitDescription(int unit) {
        return SELECTION_VALUES.get(unit);
    }

    public static String getUnitDescriptionPlural(int unit) {
        return TimeHelper.getTimeUnit(unit).getDescription();
    }

    public static TimeUnit getTimeUnit(int unit) {
        for (TimeUnit tu : UNITS) {
            if (tu.getUnit() != unit) continue;
            return tu;
        }
        throw new IllegalStateException("Unknown time unit: " + unit);
    }

    public static TimeUnit getTimeUnit(String name) {
        TimeUnit unit = NAMED_UNITS.get(name);
        if (unit != null) {
            return unit;
        }
        Number num = Util.convertToNumber(name, true, false);
        return TimeHelper.getTimeUnit(num.intValue());
    }

    public static long convertToMillis(long period, int unit) {
        switch (unit) {
            case 0: {
                return period;
            }
            case 1: {
                return period * 1000L;
            }
            case 2: {
                return period * 60000L;
            }
            case 3: {
                return period * 3600000L;
            }
            case 4: {
                return period * 86400000L;
            }
            case 5: {
                return period * 604800000L;
            }
            case 6: {
                return period * 2592000000L;
            }
            case 7: {
                return period * 7862400000L;
            }
            case 8: {
                return period * 31536000000L;
            }
        }
        throw new IllegalStateException("Unknown time unit: " + unit);
    }

    public static String getForSeconds(Long milliseconds) {
        return TimeHelper.getForSeconds(milliseconds, Cres.get());
    }

    public static String getForSeconds(Long milliseconds, ResourceBundle bundle) {
        String Seconds = Cres.get().getString("forSeconds");
        String Second = Cres.get().getString("forSecond");
        String SecondsTwo = Cres.get().getString("forSecondsOne");
        String SecondsOne = Cres.get().getString("forSecondsTwo");
        if (milliseconds == null) {
            return "0" + bundle.getString("forSeconds");
        }
        long seconds = milliseconds / 1000L;
        String forSeconds = seconds == 1L ? bundle.getString("forSecond") : (seconds % 10L == 1L && seconds % 100L != 11L ? bundle.getString("forSecondsOne") : (seconds % 10L == 2L && seconds % 100L != 12L || seconds % 10L == 3L && seconds % 100L != 13L || seconds % 10L == 4L && seconds % 100L != 14L ? bundle.getString("forSecondsTwo") : bundle.getString("forSeconds")));
        return MessageFormat.format("{0} {1}", seconds, forSeconds);
    }

    static {
        NAMED_UNITS = new HashMap<String, TimeUnit>();
        SELECTION_VALUES.put(0, Cres.get().getString("tuMillisecond"));
        SELECTION_VALUES.put(1, Cres.get().getString("tuSecond"));
        SELECTION_VALUES.put(2, Cres.get().getString("tuMinute"));
        SELECTION_VALUES.put(3, Cres.get().getString("tuHour"));
        SELECTION_VALUES.put(4, Cres.get().getString("tuDay"));
        SELECTION_VALUES.put(5, Cres.get().getString("tuWeek"));
        SELECTION_VALUES.put(6, Cres.get().getString("tuMonth"));
        SELECTION_VALUES.put(7, Cres.get().getString("tuQuarter"));
        SELECTION_VALUES.put(8, Cres.get().getString("tuYear"));
        UNITS = new LinkedList<TimeUnit>();
        UNITS.add(MILLISECOND_UNIT);
        UNITS.add(SECOND_UNIT);
        UNITS.add(MINUTE_UNIT);
        UNITS.add(HOUR_UNIT);
        UNITS.add(DAY_UNIT);
        UNITS.add(WEEK_UNIT);
        UNITS.add(MONTH_UNIT);
        UNITS.add(QUARTER_UNIT);
        UNITS.add(YEAR_UNIT);
        REVERSED_UNITS = new LinkedList<TimeUnit>(TimeHelper.getUnits());
        Collections.reverse(REVERSED_UNITS);
        NAMED_UNITS.put(NAME_MILLISECOND, MILLISECOND_UNIT);
        NAMED_UNITS.put(NAME_MS, MILLISECOND_UNIT);
        NAMED_UNITS.put(NAME_SECOND, SECOND_UNIT);
        NAMED_UNITS.put(NAME_SEC, SECOND_UNIT);
        NAMED_UNITS.put(NAME_S, SECOND_UNIT);
        NAMED_UNITS.put(NAME_MINUTE, MINUTE_UNIT);
        NAMED_UNITS.put(NAME_MIN, MINUTE_UNIT);
        NAMED_UNITS.put(NAME_M, MINUTE_UNIT);
        NAMED_UNITS.put(NAME_HOUR, HOUR_UNIT);
        NAMED_UNITS.put(NAME_HR, HOUR_UNIT);
        NAMED_UNITS.put(NAME_H, HOUR_UNIT);
        NAMED_UNITS.put(NAME_DAY, DAY_UNIT);
        NAMED_UNITS.put(NAME_D, DAY_UNIT);
        NAMED_UNITS.put(NAME_WEEK, WEEK_UNIT);
        NAMED_UNITS.put(NAME_W, WEEK_UNIT);
        NAMED_UNITS.put(NAME_MONTH, MONTH_UNIT);
        NAMED_UNITS.put(NAME_YEAR, YEAR_UNIT);
        NAMED_UNITS.put(NAME_Y, YEAR_UNIT);
    }
}

