/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadGroupPoolFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber;
    private final String namePrefix;

    public ThreadGroupPoolFactory(ThreadGroup group, String name) {
        this.group = group;
        this.threadNumber = new AtomicInteger(1);
        StringBuilder buffer = new StringBuilder();
        buffer.append(group.getName()).append("/");
        buffer.append(name).append("-").append(poolNumber.getAndIncrement()).append("-thread-");
        this.namePrefix = buffer.toString();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

