/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import java.util.LinkedList;
import java.util.List;

public class StringWrapper {
    private final String source;
    private String result = null;
    private int beginIndex = -1;
    private int endIndex = -1;

    private StringWrapper(String source) {
        this.source = source;
    }

    private StringWrapper(String source, int beginIndex, int endIndex) {
        this.source = source;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public static StringWrapper valueOf(String source) {
        return new StringWrapper(source);
    }

    public static StringWrapper valueOf(String source, int beginIndex, int endIndex) {
        return new StringWrapper(source, beginIndex, endIndex);
    }

    public String getString() {
        if (this.result == null) {
            this.result = this.beginIndex >= 0 ? this.source.substring(this.beginIndex, this.endIndex) : this.source;
        }
        return this.result;
    }

    public String toString() {
        return this.getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            int l;
            String anotherString = (String)obj;
            int bi = this.beginIndex >= 0 ? this.beginIndex : 0;
            int n = l = this.beginIndex >= 0 ? this.endIndex - this.beginIndex : this.source.length();
            if (anotherString.length() != l) {
                return false;
            }
            for (int i = 0; i < l; ++i) {
                if (this.source.charAt(bi + i) == anotherString.charAt(i)) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof StringWrapper) {
            int l;
            StringWrapper anotherString = (StringWrapper)obj;
            int bi = this.beginIndex >= 0 ? this.beginIndex : 0;
            int n = l = this.beginIndex >= 0 ? this.endIndex - this.beginIndex : this.source.length();
            if (anotherString.length() != l) {
                return false;
            }
            for (int i = 0; i < l; ++i) {
                if (this.source.charAt(bi + i) == anotherString.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int length() {
        if (this.beginIndex >= 0) {
            return this.endIndex - this.beginIndex;
        }
        return this.source.length();
    }

    public char charAt(int i) {
        if (this.beginIndex >= 0) {
            return this.source.charAt(i + this.beginIndex);
        }
        return this.source.charAt(i);
    }

    public static List<StringWrapper> split(String str, char ch) {
        LinkedList<StringWrapper> res;
        block2: {
            res = new LinkedList<StringWrapper>();
            int index = 0;
            int newindex = 0;
            boolean finished = false;
            do {
                if ((newindex = str.indexOf(ch, index)) == -1) {
                    finished = true;
                    newindex = str.length();
                }
                res.add(StringWrapper.valueOf(str, index, newindex));
                if (finished) break block2;
            } while ((index = newindex + 1) != str.length());
            res.add(StringWrapper.valueOf(""));
        }
        return res;
    }
}

