/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.util.BlockingChannel;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class SocketBlockingChannel
implements BlockingChannel {
    private final Socket socket;
    private final InputStream is;
    private final OutputStream os;
    private BufferedOutputStream bos;
    private final ReadableByteChannel rbc;
    private final WritableByteChannel wbc;
    private final int sendBufferSize;
    private final ByteBuffer buf;
    private boolean usesCompression;
    private int bufferSize;

    public SocketBlockingChannel(Socket socket) throws IOException {
        this(socket, false, 0);
    }

    public SocketBlockingChannel(Socket socket, boolean compressData, int bufferSize) throws IOException {
        this.socket = socket;
        this.bufferSize = bufferSize;
        this.is = socket.getInputStream();
        this.os = socket.getOutputStream();
        this.rbc = Channels.newChannel(this.is);
        if (bufferSize > 0) {
            this.bos = new BufferedOutputStream(this.os, bufferSize);
            this.wbc = Channels.newChannel(this.bos);
        } else {
            this.wbc = Channels.newChannel(this.os);
        }
        this.setUsesCompression(compressData);
        this.sendBufferSize = socket.getSendBufferSize();
        this.buf = ByteBuffer.allocateDirect(this.sendBufferSize);
    }

    public SocketBlockingChannel() {
        this.socket = null;
        this.is = null;
        this.os = null;
        this.bos = null;
        this.rbc = null;
        this.wbc = null;
        this.sendBufferSize = 0;
        this.buf = null;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        try {
            return this.rbc.read(dst);
        }
        catch (SocketTimeoutException e) {
            return 0;
        }
        catch (IOException ex) {
            throw ex;
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int startPosition;
        int bytesWritten = 0;
        byte[] byteArray = byteBuffer.array();
        if (byteBuffer.remaining() == 0) {
            return 0;
        }
        for (startPosition = 0; startPosition < byteArray.length; startPosition += this.sendBufferSize) {
            int expectedWrite;
            int numberOfBytesToSend = byteArray.length - startPosition;
            this.buf.clear();
            if (numberOfBytesToSend < this.sendBufferSize) {
                this.buf.put(byteArray, startPosition, numberOfBytesToSend);
                expectedWrite = numberOfBytesToSend;
            } else {
                this.buf.put(byteArray, startPosition, this.sendBufferSize);
                expectedWrite = this.sendBufferSize;
            }
            this.buf.flip();
            bytesWritten = this.wbc.write(this.buf);
            if (this.bufferSize == 0) {
                this.os.flush();
            }
            if (bytesWritten < expectedWrite) break;
        }
        if (startPosition > byteArray.length) {
            return byteArray.length;
        }
        return startPosition + bytesWritten;
    }

    @Override
    public void flush() throws IOException {
        if (this.bos != null) {
            this.bos.flush();
        }
    }

    @Override
    public boolean isUsesCompression() {
        return this.usesCompression;
    }

    @Override
    public void setUsesCompression(boolean usesCompression) {
        this.usesCompression = usesCompression;
    }

    @Override
    public void close() throws IOException {
        try {
            this.socket.close();
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed() && this.socket.isConnected();
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public String getChannelAddress() {
        return this.getSocket().getInetAddress().getHostAddress();
    }
}

