/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;

public class ReflectUtils {
    public static Object getPrivateField(Object obj, String fieldName) {
        for (Class<?> c = obj.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                return ReflectUtils.getPrivateField(obj, fieldName, c);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public static Object getPrivateField(Object obj, String fieldName, Class c) throws NoSuchFieldException, IllegalAccessException {
        Field field = c.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    public static void setPrivateField(Object obj, String fieldName, Object value) {
        for (Class<?> c = obj.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                ReflectUtils.setPrivateField(obj, fieldName, value, c);
                return;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static void setPrivateField(Object obj, String fieldName, Object value, Class c) throws NoSuchFieldException, IllegalAccessException {
        Field field = c.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(obj, value);
    }

    public static <F, T> void copyProperties(F from, Class<F> stopFromClass, T to, Class<T> stopToClass) {
        PropertyDescriptor[] fromProperties = new PropertyDescriptor[]{};
        PropertyDescriptor[] toProperties = new PropertyDescriptor[]{};
        try {
            fromProperties = Introspector.getBeanInfo(from.getClass(), stopFromClass).getPropertyDescriptors();
            toProperties = Introspector.getBeanInfo(to.getClass(), stopToClass).getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        for (PropertyDescriptor fromPropDesc : fromProperties) {
            if (fromPropDesc.getReadMethod() == null) continue;
            for (PropertyDescriptor toPropDesc : toProperties) {
                boolean propertyIsTheSame = fromPropDesc.getName().equals(toPropDesc.getName());
                if (!propertyIsTheSame || toPropDesc.getWriteMethod() == null) continue;
                try {
                    Object value = fromPropDesc.getReadMethod().invoke(from, new Object[0]);
                    toPropDesc.getWriteMethod().invoke(to, value);
                }
                catch (Exception e) {
                    Logger.getLogger(ReflectUtils.class).info((Object)("Copying property: " + fromPropDesc.getName() + ", from " + from + " to " + to + " caused an exception"), (Throwable)e);
                }
            }
        }
    }
}

